/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.values;

import docking.Tool;
import docking.widgets.values.GValuesMap;
import ghidra.features.base.values.AddressValue;
import ghidra.features.base.values.LanguageValue;
import ghidra.features.base.values.ProgramFileValue;
import ghidra.features.base.values.ProjectFileValue;
import ghidra.features.base.values.ProjectFolderValue;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class GhidraValuesMap
extends GValuesMap {
    private TaskMonitor monitor = TaskMonitor.DUMMY;

    public void setTaskMonitor(TaskMonitor monitor) {
        this.monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
    }

    public AddressValue defineAddress(String name, Program program) {
        this.checkDup(name);
        AddressValue value = new AddressValue(name, null, program);
        this.valuesMap.put(name, value);
        return value;
    }

    public AddressValue defineAddress(String name, Address defaultValue, Program program) {
        this.checkDup(name);
        AddressValue value = new AddressValue(name, defaultValue, program);
        this.valuesMap.put(name, value);
        return value;
    }

    public AddressValue defineAddress(String name, Address defaultValue, AddressFactory factory) {
        this.checkDup(name);
        AddressValue value = new AddressValue(name, defaultValue, factory);
        this.valuesMap.put(name, value);
        return value;
    }

    public LanguageValue defineLanguage(String name, LanguageCompilerSpecPair defaultValue) {
        this.checkDup(name);
        LanguageValue value = new LanguageValue(name, defaultValue);
        this.valuesMap.put(name, value);
        return value;
    }

    public ProgramFileValue defineProgram(String name) {
        return this.defineProgram(name, null);
    }

    public ProgramFileValue defineProgram(String name, String startPath) {
        this.checkDup(name);
        ProgramFileValue value = new ProgramFileValue(name, startPath);
        this.valuesMap.put(name, value);
        return value;
    }

    public ProjectFileValue defineProjectFile(String name) {
        return this.defineProjectFile(name, null);
    }

    public ProjectFileValue defineProjectFile(String name, String startingPath) {
        this.checkDup(name);
        ProjectFileValue value = new ProjectFileValue(name, startingPath);
        this.valuesMap.put(name, value);
        return value;
    }

    public ProjectFolderValue defineProjectFolder(String name) {
        return this.defineProjectFolder(name, null);
    }

    public ProjectFolderValue defineProjectFolder(String name, String defaultValuePath) {
        this.checkDup(name);
        ProjectFolderValue value = new ProjectFolderValue(name, defaultValuePath);
        this.valuesMap.put(name, value);
        return value;
    }

    public Address getAddress(String name) {
        AddressValue addressValue = (AddressValue)((Object)this.getValue(name, AddressValue.class, "Address"));
        return (Address)addressValue.getValue();
    }

    public LanguageCompilerSpecPair getLanguage(String name) {
        LanguageValue value = (LanguageValue)((Object)this.getValue(name, LanguageValue.class, "Language"));
        return (LanguageCompilerSpecPair)value.getValue();
    }

    public Program getProgram(String name, Object consumer, Tool tool, boolean upgradeIfNeeded) throws VersionException, IOException, CancelledException {
        ProgramFileValue programFileValue = (ProgramFileValue)((Object)this.getValue(name, ProgramFileValue.class, "Program"));
        return programFileValue.openProgram(consumer, tool, upgradeIfNeeded, this.monitor);
    }

    public DomainFile getProjectFile(String name) {
        ProjectFileValue domainFileValue = (ProjectFileValue)((Object)this.getValue(name, ProjectFileValue.class, "Domain File"));
        return (DomainFile)domainFileValue.getValue();
    }

    public DomainFolder getProjectFolder(String name) {
        ProjectFolderValue domainFolderValue = (ProjectFolderValue)((Object)this.getValue(name, ProjectFolderValue.class, "Domain Folder"));
        return (DomainFolder)domainFolderValue.getValue();
    }

    public void setAddress(String name, Address address) {
        AddressValue addressValue = (AddressValue)((Object)this.getValue(name, AddressValue.class, "Address"));
        addressValue.setValue(address);
    }

    public void setLanguage(String name, LanguageCompilerSpecPair value) {
        LanguageValue languageValue = (LanguageValue)((Object)this.getValue(name, LanguageValue.class, "Language"));
        languageValue.setValue(value);
    }

    public void setProgram(String name, Program program) {
        ProgramFileValue programFileValue = (ProgramFileValue)((Object)this.getValue(name, ProgramFileValue.class, "Program"));
        programFileValue.setValue(program == null ? null : program.getDomainFile());
    }

    public void setProjectFile(String name, DomainFile file) {
        ProjectFileValue domainFileValue = (ProjectFileValue)((Object)this.getValue(name, ProjectFileValue.class, "Domain File"));
        domainFileValue.setValue(file);
    }

    public void setProjectFolder(String name, DomainFolder folder) {
        ProjectFolderValue domainFolderValue = (ProjectFolderValue)((Object)this.getValue(name, ProjectFolderValue.class, "Domain Folder"));
        domainFolderValue.setValue(folder);
    }
}

