/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Accumulator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public class CallbackAccumulator<T>
implements Accumulator<T> {
    private final Collection<T> NULL_COLLECTION = Collections.emptyList();
    private Consumer<T> consumer;

    public CallbackAccumulator(Consumer<T> consumer) {
        this.consumer = Objects.requireNonNull(consumer, "Consumer callback cannot be null");
    }

    @Override
    public void add(T t) {
        this.consumer.accept(t);
    }

    @Override
    public void addAll(Collection<T> collection) {
        for (T t : collection) {
            this.consumer.accept(t);
        }
    }

    @Override
    public boolean contains(T t) {
        return false;
    }

    @Override
    public Collection<T> get() {
        return this.NULL_COLLECTION;
    }

    @Override
    public Iterator<T> iterator() {
        return this.NULL_COLLECTION.iterator();
    }

    @Override
    public int size() {
        return 0;
    }
}

