/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.router.shortpath;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;
import org.jkiss.dbeaver.ui.editors.erd.figures.EntityFigure;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouter;

public class ShortPathRouting
extends ERDConnectionRouter {
    private static final int POINT_DISTANCE = 7;
    private double indentation = 30.0;
    private static final int RIGHT = 180;
    private static final int LEFT = 0;
    private static final int UP = 90;
    private static final int DOWN = -90;
    private final Map<Connection, Object> constraintMap = new HashMap<Connection, Object>();
    private Map<IFigure, Rectangle> figuresToBounds;
    private Map<Connection, Path> connectionToPaths;
    private boolean isDirty;
    private final ShortestPathRouter algorithm = new ShortestPathRouter();
    private final Set<Connection> staleConnections = new HashSet<Connection>();
    private final LayoutListener listener = new LayoutTracker();
    private boolean ignoreInvalidate;
    private final FigureListener figureListener = source -> {
        Rectangle newBounds = source.getBounds().getCopy();
        if (this.algorithm.updateObstacle(this.figuresToBounds.get(source), newBounds)) {
            this.queueSomeRouting();
            this.isDirty = true;
        }
        this.figuresToBounds.put(source, newBounds);
    };

    void addChild(IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        if (this.figuresToBounds.containsKey(child)) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        this.algorithm.addObstacle(bounds);
        this.figuresToBounds.put(child, bounds);
        child.addFigureListener(this.figureListener);
        this.isDirty = true;
    }

    private void hookAll() {
        this.figuresToBounds = new HashMap<IFigure, Rectangle>();
        this.getContainer().getChildren().forEach(this::addChild);
        this.getContainer().addLayoutListener(this.listener);
    }

    private void unhookAll() {
        this.getContainer().removeLayoutListener(this.listener);
        if (this.figuresToBounds != null) {
            Iterator<IFigure> figureItr = this.figuresToBounds.keySet().iterator();
            while (figureItr.hasNext()) {
                IFigure child = figureItr.next();
                figureItr.remove();
                this.removeChild(child);
            }
            this.figuresToBounds = null;
        }
    }

    public Object getConstraint(Connection connection) {
        return this.constraintMap.get(connection);
    }

    public int getSpacing() {
        return this.algorithm.getSpacing();
    }

    public void invalidate(Connection connection) {
        if (this.ignoreInvalidate) {
            return;
        }
        this.staleConnections.add(connection);
        this.getConnectionPoints().put(connection, new PointList());
        this.isDirty = true;
    }

    private void processStaleConnections() {
        Iterator<Connection> iter = this.staleConnections.iterator();
        if (iter.hasNext() && this.connectionToPaths == null) {
            this.connectionToPaths = new HashMap<Connection, Path>();
            this.hookAll();
        }
        while (iter.hasNext()) {
            List constraint;
            Connection conn = iter.next();
            Path path = this.connectionToPaths.get(conn);
            if (path == null) {
                path = new Path((Object)conn);
                this.connectionToPaths.put(conn, path);
                this.algorithm.addPath(path);
            }
            if ((constraint = (List)this.getConstraint(conn)) == null) {
                constraint = Collections.emptyList();
            }
            Point start = conn.getSourceAnchor().getReferencePoint().getCopy();
            Point end = conn.getTargetAnchor().getReferencePoint().getCopy();
            this.getContainer().translateToRelative((Translatable)start);
            this.getContainer().translateToRelative((Translatable)end);
            path.setStartPoint(start);
            path.setEndPoint(end);
            if (!constraint.isEmpty()) {
                PointList bends = new PointList(constraint.size());
                for (Object element : constraint) {
                    Bendpoint bp = (Bendpoint)element;
                    bends.addPoint(bp.getLocation());
                }
                path.setBendPoints(bends);
            } else {
                path.setBendPoints(null);
            }
            this.isDirty |= path.isDirty;
        }
        this.staleConnections.clear();
    }

    void queueSomeRouting() {
        if (this.connectionToPaths == null || this.connectionToPaths.isEmpty()) {
            return;
        }
        try {
            this.ignoreInvalidate = true;
            this.connectionToPaths.keySet().iterator().next().revalidate();
        }
        finally {
            this.ignoreInvalidate = false;
        }
    }

    public void remove(Connection connection) {
        this.staleConnections.remove(connection);
        this.constraintMap.remove(connection);
        if (this.connectionToPaths == null) {
            return;
        }
        Path path = this.connectionToPaths.remove(connection);
        this.algorithm.removePath(path);
        this.isDirty = true;
        if (this.connectionToPaths.isEmpty()) {
            this.unhookAll();
            this.connectionToPaths = null;
        } else {
            this.queueSomeRouting();
        }
    }

    void removeChild(IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        boolean change = this.algorithm.removeObstacle(bounds);
        this.figuresToBounds.remove(child);
        child.removeFigureListener(this.figureListener);
        if (change) {
            this.isDirty = true;
            this.queueSomeRouting();
        }
    }

    public void route(Connection conn) {
        if (this.isDirty) {
            this.ignoreInvalidate = true;
            this.processStaleConnections();
            this.isDirty = false;
            List<Path> paths = this.computePaths();
            for (Path path : paths) {
                IFigure targetOwner;
                Rectangle bounds;
                Connection current = (Connection)path.data;
                current.revalidate();
                PointList points = path.getPoints().getCopy();
                PrecisionPoint ref1 = new PrecisionPoint(points.getPoint(1));
                PrecisionPoint ref2 = new PrecisionPoint(points.getPoint(points.size() - 2));
                current.translateToAbsolute((Translatable)ref1);
                current.translateToAbsolute((Translatable)ref2);
                Point start = current.getSourceAnchor().getLocation((Point)ref1).getCopy();
                Point end = current.getTargetAnchor().getLocation((Point)ref2).getCopy();
                current.translateToRelative((Translatable)start);
                current.translateToRelative((Translatable)end);
                points.setPoint(start, 0);
                points.setPoint(end, points.size() - 1);
                int srcTrgAngel = 0;
                int trgSrcAngel = 0;
                if (current.getSourceAnchor().getOwner() instanceof EntityFigure) {
                    bounds = ((EntityFigure)current.getSourceAnchor().getOwner()).getBounds().getCopy();
                    srcTrgAngel = 90 - this.getDirection(bounds, points.getPoint(0));
                }
                if (current.getTargetAnchor().getOwner() instanceof EntityFigure) {
                    bounds = ((EntityFigure)current.getTargetAnchor().getOwner()).getBounds().getCopy();
                    trgSrcAngel = -90 + this.getDirection(bounds, points.getPoint(points.size() - 1));
                }
                int dxSrcTrg = (int)(Math.cos(Math.toRadians(srcTrgAngel)) * this.indentation);
                int dySrcTrg = (int)(Math.sin(Math.toRadians(srcTrgAngel)) * this.indentation);
                int dxTrgSrc = (int)(Math.cos(Math.toRadians(trgSrcAngel)) * this.indentation);
                int dyTrgSrc = (int)(Math.sin(Math.toRadians(trgSrcAngel)) * this.indentation);
                for (Map.Entry<Connection, PointList> entry : this.getConnectionPoints().entrySet()) {
                    if (entry.getKey().equals((Object)current)) continue;
                    for (int i = 0; i < entry.getKey().getPoints().size(); ++i) {
                        Point p = entry.getKey().getPoints().getPoint(i);
                        int dxStart = Math.abs(start.x - p.x);
                        int dyStart = Math.abs(start.y - p.y);
                        int dxEnd = Math.abs(end.x - p.x);
                        int dyEnd = Math.abs(end.y - p.y);
                        if (dxStart == 0 && dyStart < 7) {
                            start = new Point(start.x + dxSrcTrg, start.y - dySrcTrg);
                            Point firstPoint = points.getPoint(0);
                            firstPoint = new Point(firstPoint.x + dxSrcTrg, firstPoint.y - dySrcTrg);
                            points.setPoint(firstPoint, 0);
                        }
                        if (dxEnd != 0 || dyEnd >= 7) continue;
                        end = new Point(end.x - dxTrgSrc, end.y - dyTrgSrc);
                        Point endPoint = points.getPoint(points.size() - 1);
                        endPoint = new Point(endPoint.x - dxTrgSrc, endPoint.y - dyTrgSrc);
                        points.setPoint(endPoint, points.size() - 1);
                    }
                }
                PointList modifiedPoints = new PointList();
                modifiedPoints.addPoint(points.getFirstPoint());
                int direction1 = 0;
                int direction2 = 0;
                IFigure srcOwner = current.getSourceAnchor().getOwner();
                if (srcOwner instanceof EntityFigure) {
                    Rectangle bounds2 = ((EntityFigure)srcOwner).getBounds().getCopy();
                    direction1 = 180 - this.getDirection(bounds2, points.getPoint(0).getCopy());
                }
                if ((targetOwner = current.getTargetAnchor().getOwner()) instanceof EntityFigure) {
                    Rectangle bounds3 = ((EntityFigure)targetOwner).getBounds().getCopy();
                    direction2 = this.getDirection(bounds3, points.getPoint(points.size() - 1).getCopy());
                }
                int dx1 = (int)(Math.cos(Math.toRadians(direction1)) * this.indentation);
                int dy1 = (int)(Math.sin(Math.toRadians(direction1)) * this.indentation);
                int dx2 = (int)(Math.cos(Math.toRadians(direction2)) * this.indentation);
                int dy2 = (int)(Math.sin(Math.toRadians(direction2)) * this.indentation);
                Point p1 = new Point(start.x + dx1, start.y - dy1);
                modifiedPoints.addPoint(p1);
                for (int i = 1; i < points.size() - 1; ++i) {
                    modifiedPoints.addPoint(points.getPoint(i));
                }
                Point p2 = new Point(end.x - dx2, end.y - dy2);
                modifiedPoints.addPoint(p2);
                modifiedPoints.addPoint(points.getLastPoint());
                current.setPoints(modifiedPoints);
            }
            this.ignoreInvalidate = false;
        }
    }

    private List<Path> computePaths() {
        List paths = this.algorithm.solve();
        for (Path path : paths) {
            this.removeOverlappingBendPoints(path);
        }
        paths = this.algorithm.solve();
        return paths;
    }

    private void removeOverlappingBendPoints(Path path) {
        PointList bendPoints = path.getBendPoints();
        if (bendPoints != null) {
            PointList actualBendPoints = new PointList(bendPoints.size());
            for (int index = 0; index < bendPoints.size(); ++index) {
                Point bp = bendPoints.getPoint(index);
                boolean requireToSkipp = false;
                for (Map.Entry<IFigure, Rectangle> entry : this.figuresToBounds.entrySet()) {
                    Rectangle rectangle = entry.getValue();
                    if (!rectangle.contains(bp)) continue;
                    requireToSkipp = true;
                    break;
                }
                if (requireToSkipp) continue;
                actualBendPoints.addPoint(bp);
            }
            path.setBendPoints(actualBendPoints);
        }
    }

    protected int getDirection(Rectangle r, Point p) {
        int i = 0;
        int direction = 0;
        int distance = Math.abs(r.x - p.x);
        i = Math.abs(r.y - p.y);
        if (i <= distance) {
            distance = i;
            direction = 90;
        }
        if ((i = Math.abs(r.bottom() - p.y)) <= distance) {
            distance = i;
            direction = -90;
        }
        if ((i = Math.abs(r.right() - p.x)) < distance) {
            direction = 180;
        }
        return direction;
    }

    public List<?> getPathsAfterRouting() {
        if (this.isDirty) {
            this.processStaleConnections();
            this.isDirty = false;
            return this.algorithm.solve();
        }
        return Collections.emptyList();
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.staleConnections.add(connection);
        this.constraintMap.put(connection, constraint);
        this.isDirty = true;
    }

    public void setSpacing(int spacing) {
        this.algorithm.setSpacing(spacing);
    }

    public boolean hasMoreConnections() {
        return this.connectionToPaths != null && !this.connectionToPaths.isEmpty();
    }

    public void setIgnoreInvalidate(boolean b) {
        this.ignoreInvalidate = b;
    }

    public boolean shouldIgnoreInvalidate() {
        return this.ignoreInvalidate;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean containsConnection(Connection conn) {
        return this.connectionToPaths != null && this.connectionToPaths.containsKey(conn);
    }

    public double getIndentation() {
        return this.indentation;
    }

    public void setIndentation(double indentation) {
        this.indentation = indentation;
    }

    private class LayoutTracker
    extends LayoutListener.Stub {
        private LayoutTracker() {
        }

        public void postLayout(IFigure container) {
            if (ShortPathRouting.this.staleConnections.isEmpty()) {
                return;
            }
            ShortPathRouting.this.staleConnections.iterator().next().revalidate();
        }

        public void remove(IFigure child) {
            ShortPathRouting.this.removeChild(child);
        }

        public void setConstraint(IFigure child, Object constraint) {
            ShortPathRouting.this.addChild(child);
        }
    }
}

