/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.layout.algorithm.direct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Point;

public class StandaloneNodeConnector {
    private AbstractGraphicalEditPart diagram;
    private NodeList nodeList;
    private EdgeList edgeList;

    public StandaloneNodeConnector(AbstractGraphicalEditPart diagram) {
        this.diagram = diagram;
    }

    public void visit(DirectedGraph graph) {
        this.nodeList = graph.nodes;
        this.edgeList = graph.edges;
        this.setDummyEdges();
    }

    protected void setDummyEdges() {
        if (this.nodeList.size() > 1) {
            Collections.sort(this.nodeList, new Comparator<Node>(this){

                @Override
                public int compare(Node o1, Node o2) {
                    int connCount1 = o2.outgoing.size() + o2.incoming.size();
                    int connCount2 = o1.outgoing.size() + o1.incoming.size();
                    if (connCount1 == 0 && connCount1 == connCount2) {
                        if (o1.data instanceof NodeEditPart && o2.data instanceof NodeEditPart) {
                            return ((NodeEditPart)o1.data).getFigure().getMinimumSize().height - ((NodeEditPart)o2.data).getFigure().getMinimumSize().height;
                        }
                        return 0;
                    }
                    return connCount1 - connCount2;
                }
            });
            ArrayList<Node> unconnectedNodes = new ArrayList<Node>();
            for (int i = 0; i < this.nodeList.size(); ++i) {
                Node sourceNode = (Node)this.nodeList.get(i);
                if (sourceNode.outgoing.size() + sourceNode.incoming.size() != 0) continue;
                unconnectedNodes.add(sourceNode);
            }
            int nodeCount = unconnectedNodes.size();
            if (nodeCount > 1) {
                Point diagramSize = this.diagram.getViewer().getControl().getSize();
                double horizontalRatio = (float)diagramSize.x / (float)diagramSize.y;
                double middleRowSize = Math.sqrt(nodeCount);
                int nodesInLine = (int)(middleRowSize * horizontalRatio) + 1;
                for (int i = 0; i < nodeCount; ++i) {
                    for (int k = 0; k < nodesInLine - 1 && i < nodeCount - 1; ++k, ++i) {
                        Node sourceNode = (Node)unconnectedNodes.get(i);
                        Node targetNode = (Node)unconnectedNodes.get(i + 1);
                        Edge edge = new Edge(null, sourceNode, targetNode);
                        edge.weight = 2;
                        this.edgeList.add((Object)edge);
                    }
                }
            }
        }
    }
}

