/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.utils.CommonUtils;

public class ProviderPropertyDescriptor
extends PropertyDescriptor {
    private static final Log log = Log.getLog(ProviderPropertyDescriptor.class);
    private static final String ATTR_SUPPORTED_CONFIGURATION_TYPES = "supportedConfigurationTypes";
    private final Set<DBPDriverConfigurationType> configurationTypes;

    public ProviderPropertyDescriptor(String category, IConfigurationElement config) {
        super(category, config);
        String configurationTypes = config.getAttribute(ATTR_SUPPORTED_CONFIGURATION_TYPES);
        if (CommonUtils.isEmpty((String)configurationTypes)) {
            this.configurationTypes = Set.of(DBPDriverConfigurationType.MANUAL, DBPDriverConfigurationType.URL);
        } else {
            String[] supportedConfigurationTypes = CommonUtils.split((String)configurationTypes, (String)",");
            this.configurationTypes = Stream.of(supportedConfigurationTypes).map(DBPDriverConfigurationType::valueOf).collect(Collectors.toSet());
        }
    }

    public static List<ProviderPropertyDescriptor> extractProviderProperties(IConfigurationElement config) {
        IConfigurationElement[] propElements;
        String category = ProviderPropertyDescriptor.getPropertyCategory(config);
        ArrayList<ProviderPropertyDescriptor> properties = new ArrayList<ProviderPropertyDescriptor>();
        for (IConfigurationElement prop : propElements = config.getChildren("property")) {
            properties.add(new ProviderPropertyDescriptor(category, prop));
        }
        return properties;
    }

    public Set<DBPDriverConfigurationType> getConfigurationTypes() {
        return this.configurationTypes;
    }
}

