/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation;

import java.io.FileInputStream;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.cs.OutOfExtentException;
import org.cts.datum.Ellipsoid;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.Geocentric2Geographic;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.UnitConversion;
import org.cts.op.transformation.GeocentricTransformation;
import org.cts.op.transformation.GeocentricTranslation;
import org.cts.op.transformation.GridBasedTransformation;
import org.cts.op.transformation.grids.GridUtils;
import org.cts.op.transformation.grids.IGNGeographicGrid;
import org.cts.units.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrenchGeocentricNTF2RGF
extends AbstractCoordinateOperation
implements GeocentricTransformation,
GridBasedTransformation {
    static final Logger LOGGER = LoggerFactory.getLogger(FrenchGeocentricNTF2RGF.class);
    private final GeocentricTranslation NTF2WGS84 = new GeocentricTranslation(-168.0, -60.0, 320.0);
    private final Geocentric2Geographic GEOC2GEOG = new Geocentric2Geographic(Ellipsoid.GRS80);
    private final UnitConversion RAD2DD = UnitConversion.createUnitConverter(Unit.RADIAN, Unit.DEGREE);
    private IGNGeographicGrid GRID3D;
    private FrenchGeocentricNTF2RGF inverse;

    public FrenchGeocentricNTF2RGF() throws Exception {
        super(new Identifier("EPSG", "9655", "French geographic interpolation", "NTF2RGF93"));
        this.precision = 0.001;
        try {
            String gridName = "gr3df97a.txt";
            this.GRID3D = new IGNGeographicGrid(new FileInputStream(GridUtils.findGrid(gridName)), false);
        }
        catch (Exception e) {
            throw new Exception("A problem occured during gr3df97a.txt grid file loading", e);
        }
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 3) {
            throw new CoordinateDimensionException(coord, 3);
        }
        double[] coordi = (double[])coord.clone();
        coordi = this.NTF2WGS84.transform(coordi);
        coordi = this.GEOC2GEOG.transform(coordi);
        double oldLon = 10.0;
        double oldLat = 10.0;
        double tx = -168.0;
        double ty = -60.0;
        double tz = 320.0;
        while (Math.max(Math.abs(oldLon - coordi[0]), Math.abs(oldLat - coordi[1])) > 1.0E-11) {
            oldLon = coordi[0];
            oldLat = coordi[1];
            coordi = this.RAD2DD.transform(coordi);
            try {
                double[] t = this.GRID3D.bilinearInterpolation(coordi[0], coordi[1]);
                tx = t[0];
                ty = t[1];
                tz = t[2];
            }
            catch (OutOfExtentException e) {
                throw new IllegalCoordinateException(e.getMessage());
            }
            coordi[0] = tx + coord[0];
            coordi[1] = ty + coord[1];
            coordi[2] = tz + coord[2];
            coordi = this.GEOC2GEOG.transform(coordi);
        }
        coord[0] = tx + coord[0];
        coord[1] = ty + coord[1];
        coord[2] = tz + coord[2];
        return coord;
    }

    @Override
    public GeocentricTransformation inverse() throws NonInvertibleOperationException {
        if (this.inverse == null) {
            try {
                this.inverse = new FrenchGeocentricNTF2RGF(){

                    @Override
                    public double[] transform(double[] coord) throws IllegalCoordinateException {
                        double[] coordi = (double[])coord.clone();
                        coordi = FrenchGeocentricNTF2RGF.this.GEOC2GEOG.transform(coordi);
                        coordi = FrenchGeocentricNTF2RGF.this.RAD2DD.transform(coordi);
                        double tx = -168.0;
                        double ty = -60.0;
                        double tz = 320.0;
                        try {
                            double[] t = FrenchGeocentricNTF2RGF.this.GRID3D.bilinearInterpolation(coordi[0], coordi[1]);
                            tx = t[0];
                            ty = t[1];
                            tz = t[2];
                        }
                        catch (OutOfExtentException e) {
                            throw new IllegalCoordinateException(e.getMessage());
                        }
                        coord[0] = -tx + coord[0];
                        coord[1] = -ty + coord[1];
                        coord[2] = -tz + coord[2];
                        return coord;
                    }

                    @Override
                    public GeocentricTransformation inverse() {
                        return FrenchGeocentricNTF2RGF.this;
                    }

                    @Override
                    public double getPrecision() {
                        return 0.001;
                    }
                };
                return this.inverse;
            }
            catch (Exception e) {
                throw new NonInvertibleOperationException(e.getMessage());
            }
        }
        return this.inverse;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return "French Geocentric transformation from NTF to RGF93 - precision = " + this.precision;
    }
}

