﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/timestream-influxdb/TimestreamInfluxDB_EXPORTS.h>
#include <aws/timestream-influxdb/model/ClusterDeploymentType.h>
#include <aws/timestream-influxdb/model/ClusterStatus.h>
#include <aws/timestream-influxdb/model/DbInstanceType.h>
#include <aws/timestream-influxdb/model/DbStorageType.h>
#include <aws/timestream-influxdb/model/EngineType.h>
#include <aws/timestream-influxdb/model/NetworkType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace TimestreamInfluxDB {
namespace Model {

/**
 * <p>Describes a summary of a Timestream for InfluxDB cluster.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/DbClusterSummary">AWS
 * API Reference</a></p>
 */
class DbClusterSummary {
 public:
  AWS_TIMESTREAMINFLUXDB_API DbClusterSummary() = default;
  AWS_TIMESTREAMINFLUXDB_API DbClusterSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_TIMESTREAMINFLUXDB_API DbClusterSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_TIMESTREAMINFLUXDB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Service-generated unique identifier of the DB cluster to retrieve.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  DbClusterSummary& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Customer supplied name of the Timestream for InfluxDB cluster.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DbClusterSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the DB cluster.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  DbClusterSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the DB cluster.</p>
   */
  inline ClusterStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(ClusterStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline DbClusterSummary& WithStatus(ClusterStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The endpoint used to connect to the Timestream for InfluxDB cluster for write
   * and read operations.</p>
   */
  inline const Aws::String& GetEndpoint() const { return m_endpoint; }
  inline bool EndpointHasBeenSet() const { return m_endpointHasBeenSet; }
  template <typename EndpointT = Aws::String>
  void SetEndpoint(EndpointT&& value) {
    m_endpointHasBeenSet = true;
    m_endpoint = std::forward<EndpointT>(value);
  }
  template <typename EndpointT = Aws::String>
  DbClusterSummary& WithEndpoint(EndpointT&& value) {
    SetEndpoint(std::forward<EndpointT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The endpoint used to connect to the Timestream for InfluxDB cluster for
   * read-only operations.</p>
   */
  inline const Aws::String& GetReaderEndpoint() const { return m_readerEndpoint; }
  inline bool ReaderEndpointHasBeenSet() const { return m_readerEndpointHasBeenSet; }
  template <typename ReaderEndpointT = Aws::String>
  void SetReaderEndpoint(ReaderEndpointT&& value) {
    m_readerEndpointHasBeenSet = true;
    m_readerEndpoint = std::forward<ReaderEndpointT>(value);
  }
  template <typename ReaderEndpointT = Aws::String>
  DbClusterSummary& WithReaderEndpoint(ReaderEndpointT&& value) {
    SetReaderEndpoint(std::forward<ReaderEndpointT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The port number on which InfluxDB accepts connections.</p>
   */
  inline int GetPort() const { return m_port; }
  inline bool PortHasBeenSet() const { return m_portHasBeenSet; }
  inline void SetPort(int value) {
    m_portHasBeenSet = true;
    m_port = value;
  }
  inline DbClusterSummary& WithPort(int value) {
    SetPort(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Deployment type of the DB cluster</p>
   */
  inline ClusterDeploymentType GetDeploymentType() const { return m_deploymentType; }
  inline bool DeploymentTypeHasBeenSet() const { return m_deploymentTypeHasBeenSet; }
  inline void SetDeploymentType(ClusterDeploymentType value) {
    m_deploymentTypeHasBeenSet = true;
    m_deploymentType = value;
  }
  inline DbClusterSummary& WithDeploymentType(ClusterDeploymentType value) {
    SetDeploymentType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Timestream for InfluxDB DB instance type that InfluxDB runs on.</p>
   */
  inline DbInstanceType GetDbInstanceType() const { return m_dbInstanceType; }
  inline bool DbInstanceTypeHasBeenSet() const { return m_dbInstanceTypeHasBeenSet; }
  inline void SetDbInstanceType(DbInstanceType value) {
    m_dbInstanceTypeHasBeenSet = true;
    m_dbInstanceType = value;
  }
  inline DbClusterSummary& WithDbInstanceType(DbInstanceType value) {
    SetDbInstanceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the network type of the Timestream for InfluxDB Cluster is
   * IPv4, which can communicate over IPv4 protocol only, or DUAL, which can
   * communicate over both IPv4 and IPv6 protocols.</p>
   */
  inline NetworkType GetNetworkType() const { return m_networkType; }
  inline bool NetworkTypeHasBeenSet() const { return m_networkTypeHasBeenSet; }
  inline void SetNetworkType(NetworkType value) {
    m_networkTypeHasBeenSet = true;
    m_networkType = value;
  }
  inline DbClusterSummary& WithNetworkType(NetworkType value) {
    SetNetworkType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Timestream for InfluxDB DB storage type that InfluxDB stores data on.</p>
   */
  inline DbStorageType GetDbStorageType() const { return m_dbStorageType; }
  inline bool DbStorageTypeHasBeenSet() const { return m_dbStorageTypeHasBeenSet; }
  inline void SetDbStorageType(DbStorageType value) {
    m_dbStorageTypeHasBeenSet = true;
    m_dbStorageType = value;
  }
  inline DbClusterSummary& WithDbStorageType(DbStorageType value) {
    SetDbStorageType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The amount of storage allocated for your DB storage type (in gibibytes).</p>
   */
  inline int GetAllocatedStorage() const { return m_allocatedStorage; }
  inline bool AllocatedStorageHasBeenSet() const { return m_allocatedStorageHasBeenSet; }
  inline void SetAllocatedStorage(int value) {
    m_allocatedStorageHasBeenSet = true;
    m_allocatedStorage = value;
  }
  inline DbClusterSummary& WithAllocatedStorage(int value) {
    SetAllocatedStorage(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The engine type of your DB cluster.</p>
   */
  inline EngineType GetEngineType() const { return m_engineType; }
  inline bool EngineTypeHasBeenSet() const { return m_engineTypeHasBeenSet; }
  inline void SetEngineType(EngineType value) {
    m_engineTypeHasBeenSet = true;
    m_engineType = value;
  }
  inline DbClusterSummary& WithEngineType(EngineType value) {
    SetEngineType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_name;

  Aws::String m_arn;

  ClusterStatus m_status{ClusterStatus::NOT_SET};

  Aws::String m_endpoint;

  Aws::String m_readerEndpoint;

  int m_port{0};

  ClusterDeploymentType m_deploymentType{ClusterDeploymentType::NOT_SET};

  DbInstanceType m_dbInstanceType{DbInstanceType::NOT_SET};

  NetworkType m_networkType{NetworkType::NOT_SET};

  DbStorageType m_dbStorageType{DbStorageType::NOT_SET};

  int m_allocatedStorage{0};

  EngineType m_engineType{EngineType::NOT_SET};
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_endpointHasBeenSet = false;
  bool m_readerEndpointHasBeenSet = false;
  bool m_portHasBeenSet = false;
  bool m_deploymentTypeHasBeenSet = false;
  bool m_dbInstanceTypeHasBeenSet = false;
  bool m_networkTypeHasBeenSet = false;
  bool m_dbStorageTypeHasBeenSet = false;
  bool m_allocatedStorageHasBeenSet = false;
  bool m_engineTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace TimestreamInfluxDB
}  // namespace Aws
