/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.winp;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import org.jvnet.winp.WinpException;

class CtrlCSender {
    private static final int TIMEOUT_MILLIS = 5000;

    CtrlCSender() {
    }

    static boolean sendCtrlC(int pid, String ctrlCExePath) {
        Process process;
        ProcessBuilder builder = new ProcessBuilder(ctrlCExePath, String.valueOf(pid));
        builder.redirectErrorStream(true);
        try {
            process = builder.start();
        }
        catch (IOException e) {
            throw new WinpException(e);
        }
        StreamGobbler stdout = new StreamGobbler(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
        Integer exitCode = null;
        try {
            exitCode = CtrlCSender.waitFor(process);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        stdout.stop();
        if (exitCode == null) {
            process.destroy();
            throw new WinpException("Failed to send Ctrl+C to " + pid + ": 5000 ms timeout exceeded");
        }
        if (exitCode == 0) {
            return true;
        }
        throw new WinpException("Failed to send Ctrl+C, " + new File(ctrlCExePath).getName() + " terminated with exit code " + CtrlCSender.stringifyExitCode(exitCode) + ", output: " + stdout.getText());
    }

    private static String stringifyExitCode(int exitCode) {
        if (exitCode >= -1073741824 && exitCode < -805306368) {
            return exitCode + " (0x" + Integer.toHexString(exitCode).toUpperCase(Locale.ENGLISH) + ")";
        }
        return String.valueOf(exitCode);
    }

    private static Integer waitFor(Process process) throws InterruptedException {
        long endTime = System.currentTimeMillis() + 5000L;
        int i = 0;
        while (true) {
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException ignore) {
                Thread.sleep(i++ < 3 ? 10L : (i < 5 ? 30L : 100L));
                if (System.currentTimeMillis() < endTime) continue;
                return null;
            }
            break;
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private final Reader reader;
        private final StringBuilder myBuffer = new StringBuilder();
        private final Thread thread;
        private boolean isStopped = false;

        private StreamGobbler(Reader reader) {
            this.reader = reader;
            this.thread = new Thread((Runnable)this, "sendctrlc.exe output reader");
            this.thread.start();
        }

        @Override
        public void run() {
            char[] buf = new char[8192];
            try {
                int readCount;
                while (!this.isStopped && (readCount = this.reader.read(buf)) >= 0) {
                    this.myBuffer.append(buf, 0, readCount);
                }
                if (this.isStopped) {
                    this.myBuffer.append("Failed to read output: force stopped");
                }
            }
            catch (Exception e) {
                this.myBuffer.append("Failed to read output: ").append(e.getClass().getName()).append(" raised");
            }
        }

        private void stop() {
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isStopped = true;
        }

        private String getText() {
            return this.myBuffer.toString();
        }
    }
}

