/*
 * Decompiled with CFR 0.152.
 */
package net.fellbaum.jemoji;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.fellbaum.jemoji.EmojiGroup;
import net.fellbaum.jemoji.EmojiManager;
import net.fellbaum.jemoji.EmojiSubGroup;
import net.fellbaum.jemoji.Fitzpatrick;
import net.fellbaum.jemoji.HairStyle;
import net.fellbaum.jemoji.Qualification;

public class Emoji {
    private final String emoji;
    private final String unicode;
    private final List<String> discordAliases;
    private final List<String> githubAliases;
    private final List<String> slackAliases;
    private final boolean hasFitzpatrick;
    private final boolean hasHairStyle;
    private final double version;
    private final Qualification qualification;
    private final String description;
    private final EmojiGroup group;
    private final EmojiSubGroup subgroup;
    private final List<String> allAliases;

    Emoji(@JsonProperty(value="emoji") String emoji, @JsonProperty(value="unicode") String unicode, @JsonProperty(value="discordAliases") List<String> discordAliases, @JsonProperty(value="githubAliases") List<String> githubAliases, @JsonProperty(value="slackAliases") List<String> slackAliases, @JsonProperty(value="hasFitzpatrick") boolean hasFitzpatrick, @JsonProperty(value="hasHairStyle") boolean hasHairStyle, @JsonProperty(value="version") double version, @JsonProperty(value="qualification") Qualification qualification, @JsonProperty(value="description") String description, @JsonProperty(value="group") EmojiGroup group, @JsonProperty(value="subgroup") EmojiSubGroup subgroup) {
        this.emoji = emoji;
        this.unicode = unicode;
        this.discordAliases = discordAliases;
        this.githubAliases = githubAliases;
        this.slackAliases = slackAliases;
        this.hasFitzpatrick = hasFitzpatrick;
        this.hasHairStyle = hasHairStyle;
        this.version = version;
        this.qualification = qualification;
        this.description = description;
        this.group = group;
        this.subgroup = subgroup;
        HashSet<String> aliases = new HashSet<String>();
        aliases.addAll(this.getDiscordAliases());
        aliases.addAll(this.getGithubAliases());
        aliases.addAll(this.getSlackAliases());
        this.allAliases = Collections.unmodifiableList(new ArrayList(aliases));
    }

    public String getEmoji() {
        return this.emoji;
    }

    public String getUnicode() {
        return this.unicode;
    }

    public String getHtmlDecimalCode() {
        return this.getEmoji().codePoints().mapToObj(operand -> "&#" + operand).collect(Collectors.joining(";")) + ";";
    }

    public String getHtmlHexadecimalCode() {
        return this.getEmoji().codePoints().mapToObj(operand -> "&#x" + Integer.toHexString(operand).toUpperCase()).collect(Collectors.joining(";")) + ";";
    }

    public List<Emoji> getVariations() {
        String baseEmoji = HairStyle.removeHairStyle(Fitzpatrick.removeFitzpatrick(this.emoji));
        return EmojiManager.getAllEmojis().parallelStream().filter(emoji -> HairStyle.removeHairStyle(Fitzpatrick.removeFitzpatrick(emoji.getEmoji())).equals(baseEmoji)).filter(emoji -> !emoji.equals(this)).collect(Collectors.toList());
    }

    public String getURLEncoded() {
        try {
            return URLEncoder.encode(this.getEmoji(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getDiscordAliases() {
        return this.discordAliases;
    }

    public List<String> getGithubAliases() {
        return this.githubAliases;
    }

    public List<String> getSlackAliases() {
        return this.slackAliases;
    }

    public List<String> getAllAliases() {
        return this.allAliases;
    }

    public boolean hasFitzpatrickComponent() {
        return this.hasFitzpatrick;
    }

    public boolean hasHairStyleComponent() {
        return this.hasHairStyle;
    }

    public double getVersion() {
        return this.version;
    }

    public Qualification getQualification() {
        return this.qualification;
    }

    public String getDescription() {
        return this.description;
    }

    public EmojiGroup getGroup() {
        return this.group;
    }

    public EmojiSubGroup getSubgroup() {
        return this.subgroup;
    }

    public String toString() {
        return "Emoji{emoji='" + this.emoji + '\'' + ", unicode='" + this.unicode + '\'' + ", discordAliases=" + this.discordAliases + ", githubAliases=" + this.githubAliases + ", slackAliases=" + this.slackAliases + ", hasFitzpatrick=" + this.hasFitzpatrick + ", hasHairStyle=" + this.hasHairStyle + ", version=" + this.version + ", qualification=" + (Object)((Object)this.qualification) + ", description='" + this.description + '\'' + ", group=" + (Object)((Object)this.group) + ", subgroup=" + (Object)((Object)this.subgroup) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Emoji emoji1 = (Emoji)o;
        if (this.hasFitzpatrick != emoji1.hasFitzpatrick) {
            return false;
        }
        if (this.hasHairStyle != emoji1.hasHairStyle) {
            return false;
        }
        if (Double.compare(emoji1.version, this.version) != 0) {
            return false;
        }
        if (!this.emoji.equals(emoji1.emoji)) {
            return false;
        }
        if (!this.unicode.equals(emoji1.unicode)) {
            return false;
        }
        if (!this.discordAliases.equals(emoji1.discordAliases)) {
            return false;
        }
        if (!this.githubAliases.equals(emoji1.githubAliases)) {
            return false;
        }
        if (!this.slackAliases.equals(emoji1.slackAliases)) {
            return false;
        }
        if (this.qualification != emoji1.qualification) {
            return false;
        }
        if (!this.description.equals(emoji1.description)) {
            return false;
        }
        if (this.group != emoji1.group) {
            return false;
        }
        return this.subgroup == emoji1.subgroup;
    }

    public int hashCode() {
        int result = this.emoji.hashCode();
        result = 31 * result + this.unicode.hashCode();
        result = 31 * result + this.discordAliases.hashCode();
        result = 31 * result + this.githubAliases.hashCode();
        result = 31 * result + this.slackAliases.hashCode();
        result = 31 * result + (this.hasFitzpatrick ? 1 : 0);
        result = 31 * result + (this.hasHairStyle ? 1 : 0);
        long temp = Double.doubleToLongBits(this.version);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.qualification.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.subgroup.hashCode();
        return result;
    }
}

