/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend.hyperlinks;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.FilterApplyResult;
import com.intellij.execution.impl.HyperlinksKt;
import com.intellij.execution.impl.HypertextInput;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.terminal.backend.hyperlinks.BackendTerminalHyperlinkHighlighterKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.session.impl.TerminalHyperlinkId;
import org.jetbrains.plugins.terminal.session.impl.dto.TerminalFilterResultInfoDto;
import org.jetbrains.plugins.terminal.session.impl.dto.TerminalHighlightingInfoDto;
import org.jetbrains.plugins.terminal.session.impl.dto.TerminalHyperlinkInfoDto;
import org.jetbrains.plugins.terminal.session.impl.dto.TerminalHyperlinksDtoKt;
import org.jetbrains.plugins.terminal.session.impl.dto.TerminalInlayInfoDto;
import org.jetbrains.plugins.terminal.view.TerminalLineIndex;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelSnapshot;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/terminal/backend/hyperlinks/HyperlinkProcessor;", "", "hyperlinkId", "Ljava/util/concurrent/atomic/AtomicLong;", "<init>", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "processBatch", "", "Lorg/jetbrains/plugins/terminal/session/impl/dto/TerminalFilterResultInfoDto;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModelSnapshot;", "filter", "Lcom/intellij/execution/filters/CompositeFilter;", "startLine", "Lorg/jetbrains/plugins/terminal/view/TerminalLineIndex;", "endLine", "(Lorg/jetbrains/plugins/terminal/view/TerminalOutputModelSnapshot;Lcom/intellij/execution/filters/CompositeFilter;Lorg/jetbrains/plugins/terminal/view/TerminalLineIndex;Lorg/jetbrains/plugins/terminal/view/TerminalLineIndex;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createHyperlinkOrHighlighting", "resultItem", "Lcom/intellij/execution/filters/Filter$ResultItem;", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nBackendTerminalHyperlinkHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHyperlinkHighlighter.kt\ncom/intellij/terminal/backend/hyperlinks/HyperlinkProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,531:1\n1374#2:532\n1460#2,5:533\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHyperlinkHighlighter.kt\ncom/intellij/terminal/backend/hyperlinks/HyperlinkProcessor\n*L\n456#1:532\n456#1:533,5\n*E\n"})
final class HyperlinkProcessor {
    @NotNull
    private final AtomicLong hyperlinkId;

    public HyperlinkProcessor(@NotNull AtomicLong hyperlinkId) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkId, (String)"hyperlinkId");
        this.hyperlinkId = hyperlinkId;
    }

    @Nullable
    public final Object processBatch(@NotNull TerminalOutputModelSnapshot outputModel, @NotNull CompositeFilter filter, @NotNull TerminalLineIndex startLine, @NotNull TerminalLineIndex endLine, @NotNull Continuation<? super List<? extends TerminalFilterResultInfoDto>> $completion) {
        return CoroutinesKt.readAction(() -> HyperlinkProcessor.processBatch$lambda$0(filter, outputModel, startLine, endLine, this), $completion);
    }

    private final List<TerminalFilterResultInfoDto> createHyperlinkOrHighlighting(TerminalOutputModelSnapshot outputModel, Filter.ResultItem resultItem) {
        TerminalInlayInfoDto terminalInlayInfoDto;
        TerminalFilterResultInfoDto terminalFilterResultInfoDto;
        HyperlinkInfo hyperlinkInfo = resultItem.getHyperlinkInfo();
        TextAttributes highlightAttributes = resultItem.getHighlightAttributes();
        if (hyperlinkInfo != null) {
            TextAttributes textAttributes = highlightAttributes;
            TextAttributes textAttributes2 = resultItem.getFollowedHyperlinkAttributes();
            TextAttributes textAttributes3 = resultItem.getHoveredHyperlinkAttributes();
            terminalFilterResultInfoDto = new TerminalHyperlinkInfoDto(new TerminalHyperlinkId(this.hyperlinkId.incrementAndGet()), hyperlinkInfo, BackendTerminalHyperlinkHighlighterKt.access$relativeOffset(outputModel, resultItem.getHighlightStartOffset()).toAbsolute(), BackendTerminalHyperlinkHighlighterKt.access$relativeOffset(outputModel, resultItem.getHighlightEndOffset()).toAbsolute(), textAttributes != null ? TerminalHyperlinksDtoKt.toDto(textAttributes) : null, textAttributes2 != null ? TerminalHyperlinksDtoKt.toDto(textAttributes2) : null, textAttributes3 != null ? TerminalHyperlinksDtoKt.toDto(textAttributes3) : null, resultItem.getHighlighterLayer());
        } else {
            terminalFilterResultInfoDto = highlightAttributes != null ? (TerminalFilterResultInfoDto)new TerminalHighlightingInfoDto(new TerminalHyperlinkId(this.hyperlinkId.incrementAndGet()), BackendTerminalHyperlinkHighlighterKt.access$relativeOffset(outputModel, resultItem.getHighlightStartOffset()).toAbsolute(), BackendTerminalHyperlinkHighlighterKt.access$relativeOffset(outputModel, resultItem.getHighlightEndOffset()).toAbsolute(), TerminalHyperlinksDtoKt.toDto(highlightAttributes), resultItem.getHighlighterLayer()) : null;
        }
        TerminalFilterResultInfoDto notInlayResult = terminalFilterResultInfoDto;
        InlayProvider inlayProvider = resultItem instanceof InlayProvider ? (InlayProvider)resultItem : null;
        if (inlayProvider != null) {
            InlayProvider inlayProvider2 = inlayProvider;
            boolean bl = false;
            terminalInlayInfoDto = new TerminalInlayInfoDto(new TerminalHyperlinkId(this.hyperlinkId.incrementAndGet()), BackendTerminalHyperlinkHighlighterKt.access$relativeOffset(outputModel, resultItem.getHighlightStartOffset()).toAbsolute(), BackendTerminalHyperlinkHighlighterKt.access$relativeOffset(outputModel, resultItem.getHighlightEndOffset()).toAbsolute(), inlayProvider2);
        } else {
            terminalInlayInfoDto = null;
        }
        TerminalInlayInfoDto inlayResult = terminalInlayInfoDto;
        Object[] objectArray = new TerminalFilterResultInfoDto[]{notInlayResult, inlayResult};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final List processBatch$lambda$0(CompositeFilter $filter, TerminalOutputModelSnapshot $outputModel, TerminalLineIndex $startLine, TerminalLineIndex $endLine, HyperlinkProcessor this$0) {
        List list;
        List results = list = (List)new ArrayList();
        boolean bl = false;
        HyperlinksKt.applyToLineRange((Filter)((Filter)$filter), (HypertextInput)BackendTerminalHyperlinkHighlighterKt.access$asHypertext($outputModel), (int)BackendTerminalHyperlinkHighlighterKt.access$toRelative($startLine, $outputModel), (int)BackendTerminalHyperlinkHighlighterKt.access$toRelative($endLine, $outputModel), arg_0 -> HyperlinkProcessor.processBatch$lambda$0$0$0(results, this$0, $outputModel, arg_0));
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit processBatch$lambda$0$0$0(List $results, HyperlinkProcessor this$0, TerminalOutputModelSnapshot $outputModel, FilterApplyResult applyResult) {
        List list;
        Intrinsics.checkNotNullParameter((Object)applyResult, (String)"applyResult");
        ProgressManager.checkCanceled();
        Object object = applyResult.getFilterResult();
        if (object != null && (object = object.getResultItems()) != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)object;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Filter.ResultItem it = (Filter.ResultItem)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Iterable list$iv$iv = this$0.createHyperlinkOrHighlighting($outputModel, it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List hyperlinks = list;
        $results.addAll(hyperlinks);
        return Unit.INSTANCE;
    }
}

