/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UPolygon;

public class Hexagon {
    public static final double hexagonHalfSize = 12.0;

    public static UPolygon asPolygon(double shadowing) {
        UPolygon diams = new UPolygon();
        diams.addPoint(12.0, 0.0);
        diams.addPoint(24.0, 12.0);
        diams.addPoint(12.0, 24.0);
        diams.addPoint(0.0, 12.0);
        diams.addPoint(12.0, 0.0);
        diams.setDeltaShadow(shadowing);
        return diams;
    }

    public static UPolygon asPolygon(double shadowing, double width, double height) {
        UPolygon diams = new UPolygon();
        diams.addPoint(12.0, 0.0);
        diams.addPoint(width - 12.0, 0.0);
        diams.addPoint(width, height / 2.0);
        diams.addPoint(width - 12.0, height);
        diams.addPoint(12.0, height);
        diams.addPoint(0.0, height / 2.0);
        diams.addPoint(12.0, 0.0);
        diams.setDeltaShadow(shadowing);
        return diams;
    }

    public static Stencil asStencil(final TextBlock tb) {
        return new Stencil(){

            private final double getDeltaX(double height, double y) {
                double p = y / height * 2.0;
                if (p <= 1.0) {
                    return 12.0 * p;
                }
                return 12.0 * (2.0 - p);
            }

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                XDimension2D dim = tb.calculateDimension(stringBounder);
                return -this.getDeltaX(dim.getHeight(), y);
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                XDimension2D dim = tb.calculateDimension(stringBounder);
                return dim.getWidth() + this.getDeltaX(dim.getHeight(), y);
            }
        };
    }

    public static UPolygon asPolygonSquare(double shadowing, double width, double height) {
        UPolygon diams = new UPolygon();
        diams.addPoint(width / 2.0, 0.0);
        diams.addPoint(width, height / 2.0);
        diams.addPoint(width / 2.0, height);
        diams.addPoint(0.0, height / 2.0);
        diams.setDeltaShadow(shadowing);
        return diams;
    }
}

