/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.store;

import java.io.IOException;
import lombok.NonNull;
import org.apache.lucene.store.IndexInput;

public class IndexInputWithBuffer {
    private IndexInput indexInput;
    private long contentLength;
    private byte[] buffer = new byte[65536];

    public IndexInputWithBuffer(@NonNull IndexInput indexInput) {
        if (indexInput == null) {
            throw new NullPointerException("indexInput is marked non-null but is null");
        }
        this.indexInput = indexInput;
        this.contentLength = indexInput.length();
    }

    private int copyBytes(long nbytes) throws IOException {
        int readBytes = (int)Math.min(nbytes, (long)this.buffer.length);
        this.indexInput.readBytes(this.buffer, 0, readBytes);
        return readBytes;
    }

    private long remainingBytes() {
        return this.contentLength - this.indexInput.getFilePointer();
    }

    public String toString() {
        return "{indexInput=" + String.valueOf(this.indexInput) + ", len(buffer)=" + this.buffer.length + "}";
    }
}

