/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.ServerConnectionId;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.ConnectionDisconnectListener;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011eqA\u0002/^\u0011\u0003y\u0016M\u0002\u0004d;\"\u0005q\f\u001a\u0005\u0006W\u0006!\t!\u001c\u0005\b]\u0006\u0011\r\u0011\"\u0003p\u0011\u0019A\u0018\u0001)A\u0005a\"9\u00110\u0001b\u0001\n\u0003y\u0007B\u0002>\u0002A\u0003%\u0001\u000fC\u0004|\u0003\t\u0007I\u0011A8\t\rq\f\u0001\u0015!\u0003q\u0011\u001di\u0018A1A\u0005\u0002yDq!!\u0002\u0002A\u0003%q\u0010\u0003\u0005\u0002\b\u0005!\t!XA\u0005\r\u0019\u0019W\fA0\u0002F!I\u0011q\f\u0007\u0003\u0006\u0004%\tA \u0005\n\u0003Cb!\u0011!Q\u0001\n}D!\"a\u0019\r\u0005\u0003\u0005\u000b\u0011BA3\u0011%\ty\u0007\u0004B\u0001B\u0003%q\u0010\u0003\u0006\u0002r1\u0011\t\u0011)A\u0005\u0003gB!\"!\u001f\r\u0005\u0003\u0005\u000b\u0011BA>\u0011)\t\t\t\u0004B\u0001B\u0003%\u00111\u0011\u0005\n\u0003\u0013c!\u0011!Q\u0001\n}D!\"a#\r\u0005\u0003\u0005\u000b\u0011BAG\u0011)\t9\n\u0004B\u0001B\u0003%\u0011\u0011\u0014\u0005\u000b\u0003Sc!\u0011!Q\u0001\n\u0005-\u0006BCA[\u0019\t\u0005\t\u0015!\u0003\u00028\"Q\u0011\u0011\u0019\u0007\u0003\u0002\u0003\u0006I!a1\t\u0015\u00055GB!A!\u0002\u0013\ty\r\u0003\u0006\u0002\\2\u0011\t\u0011)A\u0005\u0003;D\u0011\"a9\r\u0005\u0003\u0005\u000b\u0011B@\t\u0015\u0005\u0015HB!A!\u0002\u0013\t9\u000f\u0003\u0006\u0002(1\u0011\t\u0011)A\u0005\u0003SA!\"!<\r\u0005\u0003\u0005\u000b\u0011BAx\u0011)\u0011\u0019\u0001\u0004B\u0001B\u0003%!Q\u0001\u0005\u0007W2!\tAa\u0007\t\u0011\t\u0015CB1A\u0005\n=DqAa\u0012\rA\u0003%\u0001\u000f\u0003\u0005\u0003J1\u0011\r\u0011\"\u0003p\u0011\u001d\u0011Y\u0005\u0004Q\u0001\nAD\u0011B!\u0014\r\u0005\u0004%IAa\u0014\t\u0011\tmC\u0002)A\u0005\u0005#B\u0011B!\u0018\r\u0005\u0004%\tAa\u0018\t\u0011\tUD\u0002)A\u0005\u0005CB\u0011Ba\u001e\r\u0005\u0004%IAa\u0018\t\u0011\teD\u0002)A\u0005\u0005CB\u0011Ba\u001f\r\u0005\u0004%\tA! \t\u0011\t\u0015E\u0002)A\u0005\u0005\u007fB\u0011Ba\"\r\u0005\u0004%IA!#\t\u0011\t}E\u0002)A\u0005\u0005\u0017C\u0011B!)\r\u0005\u0004%IAa)\t\u0011\t}F\u0002)A\u0005\u0005KC\u0011B!1\r\u0005\u0004%IAa1\t\u0011\t-G\u0002)A\u0005\u0005\u000bD!B!4\r\u0005\u0004%\ta\u0018Bh\u0011!\u00119\u000e\u0004Q\u0001\n\tE\u0007\"\u0003Bm\u0019\t\u0007I\u0011\u0002Bn\u0011!\u0011I\u000f\u0004Q\u0001\n\tu\u0007\"\u0003Bv\u0019\t\u0007I\u0011\u0002Bw\u0011!\u00119\u0010\u0004Q\u0001\n\t=\bB\u0003B}\u0019\t\u0007I\u0011A/\u0003|\"A11\u0001\u0007!\u0002\u0013\u0011i\u0010\u0003\u0005\u0004\u00061!\t\"XB\u0004\u0011!\u0019\u0019\u0002\u0004a\u0001\n\u0013q\b\"CB\u000b\u0019\u0001\u0007I\u0011BB\f\u0011\u001d\u0019\u0019\u0003\u0004Q!\n}Dqa!\n\r\t\u0003\u001a9\u0003\u0003\u0005\u0004*1!\t!XB\u0016\u0011\u001d\u00199\u0005\u0004C\u0005\u0007\u0013Bqaa\u0015\r\t\u0013\u00199\u0003\u0003\u0005\u0004V1!\t\"XB,\u0011\u001d\u00199\u0007\u0004C\u0005\u0007OAqa!\u001b\r\t\u0013\u00199\u0003C\u0004\u0004l1!Iaa\n\t\u000f\r5D\u0002\"\u0003\u0004p!911\u000f\u0007\u0005\n\r\u001d\u0002bBB;\u0019\u0011%1q\u0005\u0005\b\u0007obA\u0011BB=\u0011\u001d\u0019y\b\u0004C\u0001\u0007\u0003Cqa!*\r\t\u0013\u00199\u0003C\u0004\u0004(2!Iaa\n\t\u0011\ruD\u0002\"\u0005^\u0007SC\u0001ba/\r\t\u0003i6Q\u0018\u0005\b\u0007\u0003dA\u0011BBb\u0011\u001d\u0019)\r\u0004C\u0001;zDqaa2\r\t\u0003if\u0010\u0003\u0005\u0004J2!\t!XBf\u0011\u001d\u0019Y\u000e\u0004C\u0005\u0007;Dq\u0001b\u0002\r\t\u0013!I\u0001\u0003\u0005\u0005\u000e1!\t!\u0018C\b\u0011\u001d!\u0019\u0002\u0004C\u0001\u0007OAq\u0001\"\u0006\r\t\u0003\u00199\u0003C\u0004\u0005\u00181!\taa\n\t\u000f\r]D\u0002\"\u0001\u0004(\u0005I\u0001K]8dKN\u001cxN\u001d\u0006\u0003=~\u000bqA\\3uo>\u00148NC\u0001a\u0003\u0015Y\u0017MZ6b!\t\u0011\u0017!D\u0001^\u0005%\u0001&o\\2fgN|'o\u0005\u0002\u0002KB\u0011a-[\u0007\u0002O*\t\u0001.A\u0003tG\u0006d\u0017-\u0003\u0002kO\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002C\u0006)\u0012\n\u001a7f!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,W#\u00019\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001\u00027b]\u001eT\u0011!^\u0001\u0005U\u00064\u0018-\u0003\u0002xe\n11\u000b\u001e:j]\u001e\fa#\u00133mKB+'oY3oi6+GO]5d\u001d\u0006lW\rI\u0001\u001a\u001d\u0016$xo\u001c:l!J|7-Z:t_JlU\r\u001e:jGR\u000bw-\u0001\u000eOKR<xN]6Qe>\u001cWm]:pe6+GO]5d)\u0006<\u0007%A\tMSN$XM\\3s\u001b\u0016$(/[2UC\u001e\f!\u0003T5ti\u0016tWM]'fiJL7\rV1hA\u0005\u00192i\u001c8oK\u000e$\u0018n\u001c8Rk\u0016,XmU5{KV\tq\u0010E\u0002g\u0003\u0003I1!a\u0001h\u0005\rIe\u000e^\u0001\u0015\u0007>tg.Z2uS>t\u0017+^3vKNK'0\u001a\u0011\u0002%A\f'o]3SKF,Xm\u001d;IK\u0006$WM\u001d\u000b\u0007\u0003\u0017\t)#!\u000e\u0011\t\u00055\u0011\u0011E\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005A!/Z9vKN$8O\u0003\u0003\u0002\u0016\u0005]\u0011AB2p[6|gNC\u0002a\u00033QA!a\u0007\u0002\u001e\u00051\u0011\r]1dQ\u0016T!!a\b\u0002\u0007=\u0014x-\u0003\u0003\u0002$\u0005=!!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0002(-\u0001\r!!\u000b\u0002#\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'\u000f\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\u0011\ty#a\u0006\u0002\rM,'O^3s\u0013\u0011\t\u0019$!\f\u0003#\u0005\u0003\u0018NV3sg&|g.T1oC\u001e,'\u000fC\u0004\u00028-\u0001\r!!\u000f\u0002\r\t,hMZ3s!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA i\u0006\u0019a.[8\n\t\u0005\r\u0013Q\b\u0002\u000b\u0005f$XMQ;gM\u0016\u00148c\u0002\u0007\u0002H\u00055\u00131\u000b\t\u0004c\u0006%\u0013bAA&e\n1qJ\u00196fGR\u00042!]A(\u0013\r\t\tF\u001d\u0002\t%Vtg.\u00192mKB!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z}\u000bQ!\u001e;jYNLA!!\u0018\u0002X\t9Aj\\4hS:<\u0017AA5e\u0003\rIG\rI\u0001\u0005i&lW\r\u0005\u0003\u0002h\u0005-TBAA5\u0015\u0011\tI&a\u0005\n\t\u00055\u0014\u0011\u000e\u0002\u0005)&lW-\u0001\bnCb\u0014V-];fgR\u001c\u0016N_3\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u0019!-!\u001e\n\u0007\u0005]TL\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002!\r|gN\\3di&|g.U;pi\u0006\u001c\bc\u00012\u0002~%\u0019\u0011qP/\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\u0018\u0001F2p]:,7\r^5p]Nl\u0015\r_%eY\u0016l5\u000fE\u0002g\u0003\u000bK1!a\"h\u0005\u0011auN\\4\u00027\u0019\f\u0017\u000e\\3e\u0003V$\b.\u001a8uS\u000e\fG/[8o\t\u0016d\u0017-_'t\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\ty)a%\u000e\u0005\u0005E%b\u00010\u0002\u0014%!\u0011QSAI\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0003\u0002\u001c\u0006\u0015VBAAO\u0015\u0011\ty*!)\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003G\u000b\u0019\"\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t9+!(\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017AB2p]\u001aLw\r\u0005\u0003\u0002.\u0006EVBAAX\u0015\r\tycX\u0005\u0005\u0003g\u000byKA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB7fiJL7m\u001d\t\u0005\u0003s\u000bi,\u0004\u0002\u0002<*!\u0011QWA\n\u0013\u0011\ty,a/\u0003\u000f5+GO]5dg\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s!\u0011\t)-!3\u000e\u0005\u0005\u001d'\u0002BAR\u0003/IA!a3\u0002H\n\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0003)iW-\\8ssB{w\u000e\u001c\t\u0005\u0003#\f9.\u0004\u0002\u0002T*!\u0011Q[A\n\u0003\u0019iW-\\8ss&!\u0011\u0011\\Aj\u0005)iU-\\8ssB{w\u000e\\\u0001\u000bY><7i\u001c8uKb$\b\u0003BA4\u0003?LA!!9\u0002j\tQAj\\4D_:$X\r\u001f;\u0002'\r|gN\\3di&|g.U;fk\u0016\u001c\u0016N_3\u0002)%\u001c\bK]5wS2,w-\u001a3MSN$XM\\3s!\r1\u0017\u0011^\u0005\u0004\u0003W<'a\u0002\"p_2,\u0017M\\\u0001\u000bi\"\u0014X-\u00193OC6,\u0007\u0003BAy\u0003\u007ftA!a=\u0002|B\u0019\u0011Q_4\u000e\u0005\u0005](bAA}Y\u00061AH]8pizJ1!!@h\u0003\u0019\u0001&/\u001a3fM&\u0019qO!\u0001\u000b\u0007\u0005ux-A\u000fd_:tWm\u0019;j_:$\u0015n]2p]:,7\r\u001e'jgR,g.\u001a:t!\u0019\u00119A!\u0004\u0003\u00125\u0011!\u0011\u0002\u0006\u0004\u0005\u00179\u0017AC2pY2,7\r^5p]&!!q\u0002B\u0005\u0005\r\u0019V-\u001d\t\u0005\u0005'\u00119\"\u0004\u0002\u0003\u0016)\u0019a,!\f\n\t\te!Q\u0003\u0002\u001d\u0007>tg.Z2uS>tG)[:d_:tWm\u0019;MSN$XM\\3s)!\u0012iBa\b\u0003\"\t\r\"Q\u0005B\u0014\u0005S\u0011YC!\f\u00030\tE\"1\u0007B\u001b\u0005o\u0011IDa\u000f\u0003>\t}\"\u0011\tB\"!\t\u0011G\u0002\u0003\u0004\u0002`\u0005\u0002\ra \u0005\b\u0003G\n\u0003\u0019AA3\u0011\u0019\ty'\ta\u0001\u007f\"9\u0011\u0011O\u0011A\u0002\u0005M\u0004bBA=C\u0001\u0007\u00111\u0010\u0005\b\u0003\u0003\u000b\u0003\u0019AAB\u0011\u0019\tI)\ta\u0001\u007f\"9\u00111R\u0011A\u0002\u00055\u0005bBALC\u0001\u0007\u0011\u0011\u0014\u0005\b\u0003S\u000b\u0003\u0019AAV\u0011\u001d\t),\ta\u0001\u0003oCq!!1\"\u0001\u0004\t\u0019\rC\u0004\u0002N\u0006\u0002\r!a4\t\u000f\u0005m\u0017\u00051\u0001\u0002^\"1\u00111]\u0011A\u0002}Dq!!:\"\u0001\u0004\t9\u000fC\u0004\u0002(\u0005\u0002\r!!\u000b\t\u000f\u00055\u0018\u00051\u0001\u0002p\"9!1A\u0011A\u0002\t\u0015\u0011AD7fiJL7m\u001d)bG.\fw-Z\u0001\u0010[\u0016$(/[2t!\u0006\u001c7.Y4fA\u0005\u0001R.\u001a;sS\u000e\u001c8\t\\1tg:\u000bW.Z\u0001\u0012[\u0016$(/[2t\u00072\f7o\u001d(b[\u0016\u0004\u0013\u0001D7fiJL7m]$s_V\u0004XC\u0001B)!\u0011\u0011\u0019Fa\u0016\u000e\u0005\tU#\u0002BA[\u0003[IAA!\u0017\u0003V\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003%\u0019\bn\\;mIJ+h.\u0006\u0002\u0003bA!!1\rB9\u001b\t\u0011)G\u0003\u0003\u0003h\t%\u0014AB1u_6L7M\u0003\u0003\u0003l\t5\u0014AC2p]\u000e,(O]3oi*\u0019!q\u000e;\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005g\u0012)GA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000bg\"|W\u000f\u001c3Sk:\u0004\u0013aB:uCJ$X\rZ\u0001\tgR\f'\u000f^3eA\u00051A\u000f\u001b:fC\u0012,\"Aa \u0011\t\u0005\u001d$\u0011Q\u0005\u0005\u0005\u0007\u000bIGA\u0006LC\u001a\\\u0017\r\u00165sK\u0006$\u0017a\u0002;ie\u0016\fG\rI\u0001\u000f]\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t+\t\u0011Y\t\u0005\u0004\u0003\u000e\n=%1S\u0007\u0003\u0005SJAA!%\u0003j\t\u0011\u0012I\u001d:bs\ncwnY6j]\u001e\fV/Z;f!\u0011\u0011)Ja'\u000e\u0005\t]%\u0002\u0002BM\u0003{\t\u0001b\u00195b]:,Gn]\u0005\u0005\u0005;\u00139JA\u0007T_\u000e\\W\r^\"iC:tW\r\\\u0001\u0010]\u0016<8i\u001c8oK\u000e$\u0018n\u001c8tA\u0005\t\u0012N\u001c4mS\u001eDGOU3ta>t7/Z:\u0016\u0005\t\u0015\u0006\u0003\u0003BT\u0005[\u000byO!-\u000e\u0005\t%&\u0002\u0002BV\u0005\u0013\tq!\\;uC\ndW-\u0003\u0003\u00030\n%&aA'baB!!1\u0017B]\u001d\r\u0011'QW\u0005\u0004\u0005ok\u0016A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0005w\u0013iL\u0001\u0005SKN\u0004xN\\:f\u0015\r\u00119,X\u0001\u0013S:4G.[4iiJ+7\u000f]8og\u0016\u001c\b%A\u0007sKN\u0004xN\\:f#V,W/Z\u000b\u0003\u0005\u000b\u0004bA!$\u0003H\nE\u0016\u0002\u0002Be\u0005S\u00121\u0003T5oW\u0016$'\t\\8dW&tw\rR3rk\u0016\faB]3ta>t7/Z)vKV,\u0007%\u0001\u0006nKR\u0014\u0018n\u0019+bON,\"A!5\u0011\r\tM'Q\u001b9q\u001b\t\u0011i'\u0003\u0003\u00030\n5\u0014aC7fiJL7\rV1hg\u0002\nQ$\u001a=qSJ,GmQ8o]\u0016\u001cG/[8og.KG\u000e\\3e\u0007>,h\u000e^\u000b\u0003\u0005;\u0004BAa8\u0003f6\u0011!\u0011\u001d\u0006\u0005\u0005G\fY,A\u0003ti\u0006$8/\u0003\u0003\u0003h\n\u0005(!D\"v[Vd\u0017\r^5wKN+X.\u0001\u0010fqBL'/\u001a3D_:tWm\u0019;j_:\u001c8*\u001b7mK\u0012\u001cu.\u001e8uA\u00059S\r\u001f9je\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0017&dG.\u001a3D_VtG/T3ue&\u001cg*Y7f+\t\u0011y\u000f\u0005\u0003\u0003r\nMXBAA\n\u0013\u0011\u0011)0a\u0005\u0003\u00155+GO]5d\u001d\u0006lW-\u0001\u0015fqBL'/\u001a3D_:tWm\u0019;j_:\u001c8*\u001b7mK\u0012\u001cu.\u001e8u\u001b\u0016$(/[2OC6,\u0007%\u0001\u0005tK2,7\r^8s+\t\u0011i\u0010\u0005\u0003\u0002\u0010\n}\u0018\u0002BB\u0001\u0003#\u0013\u0001bU3mK\u000e$xN]\u0001\ng\u0016dWm\u0019;pe\u0002\nab\u0019:fCR,7+\u001a7fGR|'\u000f\u0006\u0003\u0003~\u000e%\u0001bBB\u0006y\u0001\u00071QB\u0001\u000fG\"\fgN\\3m\u0005VLG\u000eZ3s!\u0011\tyia\u0004\n\t\rE\u0011\u0011\u0013\u0002\u000f\u0007\"\fgN\\3m\u0005VLG\u000eZ3s\u0003MqW\r\u001f;D_:tWm\u0019;j_:Le\u000eZ3y\u0003]qW\r\u001f;D_:tWm\u0019;j_:Le\u000eZ3y?\u0012*\u0017\u000f\u0006\u0003\u0004\u001a\r}\u0001c\u00014\u0004\u001c%\u00191QD4\u0003\tUs\u0017\u000e\u001e\u0005\t\u0007Cq\u0014\u0011!a\u0001\u007f\u0006\u0019\u0001\u0010J\u0019\u0002)9,\u0007\u0010^\"p]:,7\r^5p]&sG-\u001a=!\u0003\r\u0011XO\u001c\u000b\u0003\u00073\t\u0001\u0003\u001d:pG\u0016\u001c8/\u0012=dKB$\u0018n\u001c8\u0015\r\re1QFB\u0019\u0011\u001d\u0019y#\u0011a\u0001\u0003_\fA\"\u001a:s_JlUm]:bO\u0016Dqaa\rB\u0001\u0004\u0019)$A\u0005uQJ|w/\u00192mKB!1qGB!\u001d\u0011\u0019Id!\u0010\u000f\t\u0005U81H\u0005\u0002Q&\u00191qH4\u0002\u000fA\f7m[1hK&!11IB#\u0005%!\u0006N]8xC\ndWMC\u0002\u0004@\u001d\fq\u0003\u001d:pG\u0016\u001c8o\u00115b]:,G.\u0012=dKB$\u0018n\u001c8\u0015\u0011\re11JB(\u0007#Bqa!\u0014C\u0001\u0004\ty/A\u0005dQ\u0006tg.\u001a7JI\"91q\u0006\"A\u0002\u0005=\bbBB\u001a\u0005\u0002\u00071QG\u0001\u0014aJ|7-Z:t\u001d\u0016<(+Z:q_:\u001cXm]\u0001\rg\u0016tGMU3ta>t7/\u001a\u000b\u0007\u00073\u0019If!\u0018\t\u000f\rmC\t1\u0001\u00032\u0006A!/Z:q_:\u001cX\rC\u0004\u0004`\u0011\u0003\ra!\u0019\u0002\u0019I,7\u000f]8og\u0016\u001cVM\u001c3\u0011\t\u0005=51M\u0005\u0005\u0007K\n\tJ\u0001\u0003TK:$\u0017\u0001\u00029pY2\f\u0001\u0004\u001d:pG\u0016\u001c8oQ8na2,G/\u001a3SK\u000e,\u0017N^3t\u0003U\u0001(o\\2fgN\u001cu.\u001c9mKR,GmU3oIN\fA#\u001e9eCR,'+Z9vKN$X*\u001a;sS\u000e\u001cH\u0003BB\r\u0007cBqaa\u0017I\u0001\u0004\u0011\t,A\nqe>\u001cWm]:ESN\u001cwN\u001c8fGR,G-\u0001\fdY>\u001cX-\u0012=dKN\u001c8i\u001c8oK\u000e$\u0018n\u001c8t\u0003\u0015\u0019Gn\\:f)\u0011\u0019Iba\u001f\t\u000f\ru4\n1\u0001\u0002p\u0006a1m\u001c8oK\u000e$\u0018n\u001c8JI\u00061\u0011mY2faR$\u0002\"a:\u0004\u0004\u000e\u001d51\u0012\u0005\b\u0007\u000bc\u0005\u0019\u0001BJ\u00035\u0019xnY6fi\u000eC\u0017M\u001c8fY\"91\u0011\u0012'A\u0002\u0005\u001d\u0018\u0001C7bs\ncwnY6\t\u000f\r5E\n1\u0001\u0004\u0010\u0006Y\u0012mY2faR|'O\u00117pG.,G\rU3sG\u0016tG/T3uKJ\u0004Ba!%\u0004\"6\u001111\u0013\u0006\u0005\u0007+\u001b9*\u0001\u0003d_J,'\u0002BA[\u00073SAaa'\u0004\u001e\u00061\u00110Y7nKJT!aa(\u0002\u0007\r|W.\u0003\u0003\u0004$\u000eM%!B'fi\u0016\u0014\u0018aF2p]\u001aLw-\u001e:f\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t\u0003!\u0019Gn\\:f\u00032dG\u0003BAx\u0007WCqa!,P\u0001\u0004\u0019y+\u0001\u0004t_\u000e\\W\r\u001e\t\u0005\u0007c\u001b9,\u0004\u0002\u00044*\u00191Q\u0017;\u0002\u00079,G/\u0003\u0003\u0004:\u000eM&AB*pG.,G/A\bf]F,X-^3SKN\u0004xN\\:f)\u0011\u0019Iba0\t\u000f\rm\u0003\u000b1\u0001\u00032\u0006yA-Z9vKV,'+Z:q_:\u001cX\r\u0006\u0002\u00032\u0006\t\"/Z:q_:\u001cX-U;fk\u0016\u001c\u0016N_3\u0002+%tg\r\\5hQR\u0014Vm\u001d9p]N,7i\\;oi\u0006!r\u000e]3o\u001fJ\u001cEn\\:j]\u001e\u001c\u0005.\u00198oK2$Ba!4\u0004ZB)ama4\u0004T&\u00191\u0011[4\u0003\r=\u0003H/[8o!\u0011\tyi!6\n\t\r]\u0017\u0011\u0013\u0002\r\u0017\u000647.Y\"iC:tW\r\u001c\u0005\b\u0007{\"\u0006\u0019AAx\u0003YA\u0017M\u001c3mK\u000eC\u0017M\u001c8fY6+H/Z#wK:$HCBB\r\u0007?\u001c\t\u000fC\u0004\u0004~U\u0003\r!a<\t\u000f\r\rX\u000b1\u0001\u0004f\u0006)QM^3oiB!1q\u001dC\u0001\u001d\u0011\u0019Io!@\u000f\t\r-81 \b\u0005\u0007[\u001cIP\u0004\u0003\u0004p\u000e]h\u0002BBy\u0007ktA!!>\u0004t&\u0011\u0011qD\u0005\u0005\u00037\ti\"C\u0002a\u00033IA!!\u0006\u0002\u0018%\u0019a,a\u0005\n\t\r}\u0018\u0011S\u0001\r\u0017\u000647.Y\"iC:tW\r\\\u0005\u0005\t\u0007!)A\u0001\tDQ\u0006tg.\u001a7NkR,WI^3oi*!1q`AI\u0003A!(/_+o[V$Xm\u00115b]:,G\u000e\u0006\u0003\u0004\u001a\u0011-\u0001bBB?-\u0002\u0007\u0011q^\u0001\bG\"\fgN\\3m)\u0011\u0019i\r\"\u0005\t\u000f\rut\u000b1\u0001\u0002p\u0006)1\u000f^1si\u00061q/Y6fkB\fQBY3hS:\u001c\u0006.\u001e;e_^t\u0007")
public class Processor
implements Runnable,
Logging {
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final boolean isPrivilegedListener;
    private final ApiVersionManager apiVersionManager;
    private final Seq<ConnectionDisconnectListener> connectionDisconnectListeners;
    private final String metricsPackage;
    private final String metricsClassName;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicBoolean shouldRun;
    private final AtomicBoolean started;
    private final KafkaThread thread;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    private String metricsPackage() {
        return this.metricsPackage;
    }

    private String metricsClassName() {
        return this.metricsClassName;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    private CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    public Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        try {
            while (this.shouldRun().get()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing selector - processor " + this.id());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.closeAll(), this, Level.ERROR);
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (ControlThrowable)throwable;
        }
        this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Closing socket for " + channelId + " because of error", (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Socket server received empty response to send, registering for read: " + noOpResponse);
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException("Unknown response type: " + currentResponse.getClass());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, "Exception while processing response for " + channelId, e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable)() -> "Socket server received response to send to " + connectionId + ", registering for write and sending data: " + response);
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Attempting to send response via channel for which there is no open connection, connection id " + connectionId);
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            this.selector().send(new NetworkSend(connectionId, responseSend));
            this.inflightResponses().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
            return;
        }
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof IllegalStateException ? true : throwable instanceof IOException) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Processor " + this.id() + " poll failed", (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        this.selector().completedReceives().forEach(receive -> {
            block9: {
                try {
                    Option<KafkaChannel> option = this.openOrClosingChannel(receive.source());
                    if (option instanceof Some) {
                        KafkaChannel channel = (KafkaChannel)((Some)option).value();
                        RequestHeader header = Processor$.MODULE$.parseRequestHeader($this.apiVersionManager, receive.payload());
                        ApiKeys apiKeys = header.apiKey();
                        ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                        if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, () -> Predef$.MODULE$.long2Long($this.time.nanoseconds()))) {
                            this.trace((Function0<String>)(Function0 & Serializable)() -> "Begin re-authentication: " + channel);
                        } else {
                            long nowNanos = $this.time.nanoseconds();
                            if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> "Disconnecting expired channel: " + channel + " : " + header);
                                this.close(channel.id());
                                this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                            } else {
                                ApiVersionsRequest apiVersionsRequest;
                                String connectionId = receive.source();
                                RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), Optional.of(Predef$.MODULE$.int2Integer(channel.socketPort())), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation(), $this.isPrivilegedListener, channel.principalSerde());
                                RequestChannel.Request req = new RequestChannel.Request(this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics(), (Option<RequestChannel.Request>)None$.MODULE$);
                                ApiKeys apiKeys3 = header.apiKey();
                                ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                                if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class))).isValid()) {
                                    channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data().clientSoftwareName(), apiVersionsRequest.data().clientSoftwareVersion()));
                                }
                                $this.requestChannel.sendRequest(req);
                                this.selector().mute(connectionId);
                                this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                            }
                        }
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException("Channel " + receive.source() + " removed from selector before processing completed receive");
                    }
                    throw new MatchError(option);
                }
                catch (Throwable e) {
                    this.processChannelException(receive.source(), "Exception while processing request from " + receive.source(), e);
                }
            }
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        this.selector().completedSends().forEach(send -> {
            try {
                RequestChannel.Response response = (RequestChannel.Response)this.inflightResponses().remove((Object)send.destinationId()).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException("Send for " + send.destinationId() + " completed, but not in `inflightResponses`");
                });
                response.onComplete().foreach((Function1 & Serializable)onComplete -> {
                    onComplete.apply((Object)send);
                    return BoxedUnit.UNIT;
                });
                this.updateRequestMetrics(response);
                this.handleChannelMuteEvent(send.destinationId(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                this.tryUnmuteChannel(send.destinationId());
                return;
            }
            catch (Throwable e) {
                this.processChannelException(send.destinationId(), "Exception while processing completed send to " + send.destinationId(), e);
                return;
            }
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        this.selector().disconnected().keySet().forEach(connectionId -> {
            try {
                String remoteHost = ((ServerConnectionId)ServerConnectionId.fromString((String)connectionId).orElseThrow(() -> {
                    throw new IllegalStateException("connectionId has unexpected format: " + connectionId);
                })).remoteHost();
                this.inflightResponses().remove(connectionId).foreach((Function1 & Serializable)response -> {
                    this.updateRequestMetrics(response);
                    return BoxedUnit.UNIT;
                });
                $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
                $this.connectionDisconnectListeners.foreach((Function1 & Serializable)listener -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxedUnit.UNIT);
                        listener.onDisconnect(connectionId$2);
                        Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxedUnit.UNIT);
                    }, this, Level.ERROR);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (Throwable e) {
                this.processException("Exception while processing disconnection of " + connectionId, e);
                return;
            }
        });
    }

    private void closeExcessConnections() {
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName)) {
            KafkaChannel channel = this.selector().lowestPriorityChannel();
            if (channel != null) {
                this.close(channel.id());
                return;
            }
            return;
        }
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)channel -> {
            Processor.$anonfun$close$2(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorBlockedPercentMeter) {
        boolean accepted;
        if (this.newConnections().offer(socketChannel)) {
            v0 = true;
        } else if (mayBlock) {
            long startNs = this.time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorBlockedPercentMeter.mark(this.time.nanoseconds() - startNs);
            v0 = true;
        } else {
            v0 = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Processor " + this.id() + " listening to new connection from " + channel.socket().getRemoteSocketAddress());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.connectionQuotas.closeChannel(this, this.listenerName, channel);
                this.processException("Processor " + this.id() + " closed connection from " + remoteAddress, e);
            }
        }
    }

    private void closeAll() {
        while (!this.newConnections().isEmpty()) {
            ((AbstractInterruptibleChannel)this.newConnections().poll()).close();
        }
        this.selector().channels().forEach(channel -> this.close(channel.id()));
        this.selector().close();
        this.metricsGroup().removeMetric(Processor$.MODULE$.kafka$network$Processor$$IdlePercentMetricName(), CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(this.id()))}))).asJava());
    }

    public String connectionId(Socket socket) {
        String connId = ServerConnectionId.generateConnectionId((Socket)socket, (int)this.id(), (int)this.nextConnectionIndex());
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    private RequestChannel.Response dequeueResponse() {
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return response;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    public void start() {
        if (!this.started().getAndSet(true)) {
            this.thread().start();
            return;
        }
    }

    public void wakeup() {
        this.selector().wakeup();
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            return;
        }
    }

    public void close() {
        try {
            this.beginShutdown();
            this.thread().join();
            if (!this.started().get()) {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.closeAll(), this, Level.ERROR);
            }
        }
        catch (Throwable throwable) {
            this.metricsGroup().removeMetric("IdlePercent", CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)Integer.toString(this.id()))}))).asJava());
            this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
            throw throwable;
        }
        this.metricsGroup().removeMetric("IdlePercent", CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)Integer.toString(this.id()))}))).asJava());
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    public static final /* synthetic */ double $anonfun$new$19(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double $anonfun$new$17(Processor $this) {
        void metricName_tags;
        void metricName_group;
        void metricName_name;
        Metrics metrics = $this.metrics;
        java.util.Map<String, String> map = $this.metricTags();
        String string = SocketServer$.MODULE$.MetricsGroup();
        String string2 = "io-wait-ratio";
        if (metrics == null) {
            throw null;
        }
        string2 = null;
        string = null;
        map = null;
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics.metric(metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags))).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$19(m))));
    }

    public static final /* synthetic */ void $anonfun$close$2(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing selector connection " + connectionId$3);
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        $this.connectionDisconnectListeners.foreach((Function1 & Serializable)listener -> {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxedUnit.UNIT);
                listener.onDisconnect(connectionId$3);
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxedUnit.UNIT);
            }, $this, Level.ERROR);
            return BoxedUnit.UNIT;
        });
        $this.inflightResponses().remove((Object)connectionId$3).foreach((Function1 & Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    /*
     * WARNING - void declaration
     */
    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize, boolean isPrivilegedListener, ApiVersionManager apiVersionManager, String threadName, Seq<ConnectionDisconnectListener> connectionDisconnectListeners) {
        void addMetric_measurable;
        void metricName_tags;
        void metricName_group;
        void metricName_name;
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        this.isPrivilegedListener = isPrivilegedListener;
        this.apiVersionManager = apiVersionManager;
        this.connectionDisconnectListeners = connectionDisconnectListeners;
        this.metricsPackage = "kafka.network";
        this.metricsClassName = "Processor";
        this.metricsGroup = new KafkaMetricsGroup(this.metricsPackage(), this.metricsClassName());
        this.shouldRun = new AtomicBoolean(true);
        this.started = new AtomicBoolean();
        this.thread = new KafkaThread(threadName, (Runnable)this, false);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))).asJava();
        this.metricsGroup().newGauge(Processor$.MODULE$.kafka$network$Processor$$IdlePercentMetricName(), () -> BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$17(this)), CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))).asJava());
        this.expiredConnectionsKilledCount = new CumulativeSum();
        java.util.Map<String, String> map = this.metricTags();
        String string = SocketServer$.MODULE$.MetricsGroup();
        String string2 = "expired-connections-killed-count";
        if (metrics == null) {
            throw null;
        }
        string2 = null;
        string = null;
        map = null;
        this.expiredConnectionsKilledCountMetricName = metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags);
        CumulativeSum cumulativeSum = this.expiredConnectionsKilledCount();
        MetricName addMetric_metricName = this.expiredConnectionsKilledCountMetricName();
        metrics.addMetric(addMetric_metricName, null, (MetricValueProvider)addMetric_measurable);
        Object var24_24 = null;
        cumulativeSum = null;
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache, (DelegationTokenCache)credentialProvider.tokenCache, (Time)time, (LogContext)logContext, version -> $this.apiVersionManager.apiVersionResponse(0, Predef$.MODULE$.Short2short(version) < 4)));
        this.nextConnectionIndex = 0;
    }
}

