/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.ArrayList;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class RunEclipseTasksBuilder
implements ToolingModelBuilder {
    public boolean canBuild(String modelName) {
        return RunEclipseTasksBuilder.isSyncModel(modelName) || RunEclipseTasksBuilder.isAutoBuildModel(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        StartParameter startParameter = project.getGradle().getStartParameter();
        ArrayList<String> taskPaths = new ArrayList<String>();
        taskPaths.addAll(startParameter.getTaskNames());
        boolean isSyncModel = RunEclipseTasksBuilder.isSyncModel(modelName);
        boolean isAutoBuildModel = RunEclipseTasksBuilder.isAutoBuildModel(modelName);
        for (Project p : project.getAllprojects()) {
            EclipseModel model = (EclipseModel)p.getExtensions().findByType(EclipseModel.class);
            if (model == null) continue;
            if (isSyncModel) {
                for (Task t : TaskDependencyUtil.getDependenciesForInternalUse((TaskDependency)model.getSynchronizationTasks(), null)) {
                    taskPaths.add(t.getPath());
                }
            }
            if (!isAutoBuildModel) continue;
            for (Task t : TaskDependencyUtil.getDependenciesForInternalUse((TaskDependency)model.getAutoBuildTasks(), null)) {
                taskPaths.add(t.getPath());
            }
        }
        if (taskPaths.isEmpty()) {
            String placeHolderTaskName = RunEclipseTasksBuilder.placeHolderTaskName(project, "nothing");
            project.getTasks().register(placeHolderTaskName);
            taskPaths.add(placeHolderTaskName);
        }
        project.getGradle().getStartParameter().setTaskNames(taskPaths);
        return null;
    }

    private static boolean isSyncModel(String modelName) {
        return modelName.equals("org.gradle.tooling.model.eclipse.RunEclipseSynchronizationTasks");
    }

    private static boolean isAutoBuildModel(String modelName) {
        return modelName.equals("org.gradle.tooling.model.eclipse.RunEclipseAutoBuildTasks");
    }

    private static String placeHolderTaskName(Project project, String baseName) {
        if (project.getTasks().findByName(baseName) == null) {
            return baseName;
        }
        return RunEclipseTasksBuilder.placeHolderTaskName(project, baseName + "_");
    }
}

