/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore.disk;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.lang.Args;

public class NestedFolders {
    private final File base;

    public NestedFolders(File base) {
        this.base = (File)Args.notNull((Object)base, (String)"base");
    }

    public File getBase() {
        return this.base;
    }

    public File get(String name, boolean create) {
        name = name.replace('*', '_');
        name = name.replace('/', '_');
        name = name.replace(':', '_');
        String path = this.createPathFrom(name);
        File folder = new File(this.base, path);
        if (create && !folder.exists()) {
            Files.mkdirs((File)folder);
        }
        return folder;
    }

    private String createPathFrom(String name) {
        int hash = Math.abs(name.hashCode());
        String low = String.valueOf(hash % 9973);
        String high = String.valueOf(hash / 9973 % 9973);
        StringBuilder bs = new StringBuilder(name.length() + 10);
        bs.append(low);
        bs.append(File.separator);
        bs.append(high);
        bs.append(File.separator);
        bs.append(name);
        return bs.toString();
    }

    public void remove(String name) {
        File folder = this.get(name, false);
        if (folder.exists()) {
            File low;
            String[] lowChildren;
            Files.removeFolder((File)folder);
            File high = folder.getParentFile();
            String[] highChildren = high.list();
            if (highChildren != null && highChildren.length == 0 && Files.removeFolder((File)high) && (lowChildren = (low = high.getParentFile()).list()) != null && lowChildren.length == 0) {
                Files.removeFolder((File)low);
            }
        }
    }

    public Set<File> getAll() {
        HashSet<File> files = new HashSet<File>();
        if (this.base.exists()) {
            for (File low : Files.list((File)this.base)) {
                for (File high : Files.list((File)low)) {
                    Collections.addAll(files, Files.list((File)high));
                }
            }
        }
        return files;
    }
}

