/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.security.AccessController;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.conf.OpenJPAVersion;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCBrokerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.slice.DistributedBroker;
import org.apache.openjpa.slice.DistributedBrokerFactory;
import org.apache.openjpa.slice.DistributedBrokerImpl;
import org.apache.openjpa.slice.Slice;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfiguration;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfigurationImpl;
import org.apache.openjpa.slice.jdbc.DistributedJDBCStoreManager;

public class DistributedJDBCBrokerFactory
extends JDBCBrokerFactory
implements DistributedBrokerFactory {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(DistributedJDBCBrokerFactory.class);

    public static DistributedJDBCBrokerFactory newInstance(ConfigurationProvider cp) {
        DistributedJDBCConfigurationImpl conf = new DistributedJDBCConfigurationImpl();
        cp.setInto(conf);
        return new DistributedJDBCBrokerFactory(conf);
    }

    public static JDBCBrokerFactory getInstance(ConfigurationProvider cp) {
        Map<String, Object> properties = cp.getProperties();
        Object key = DistributedJDBCBrokerFactory.toPoolKey(properties);
        DistributedJDBCBrokerFactory factory = (DistributedJDBCBrokerFactory)DistributedJDBCBrokerFactory.getPooledFactoryForKey(key);
        if (factory != null) {
            return factory;
        }
        factory = DistributedJDBCBrokerFactory.newInstance(cp);
        DistributedJDBCBrokerFactory.pool(key, factory);
        return factory;
    }

    public static synchronized JDBCBrokerFactory getInstance(DistributedJDBCConfiguration conf) {
        Map<String, Object> properties = conf.toProperties(false);
        Object key = DistributedJDBCBrokerFactory.toPoolKey(properties);
        DistributedJDBCBrokerFactory factory = (DistributedJDBCBrokerFactory)DistributedJDBCBrokerFactory.getPooledFactoryForKey(key);
        if (factory != null) {
            return factory;
        }
        factory = new DistributedJDBCBrokerFactory(conf);
        DistributedJDBCBrokerFactory.pool(key, factory);
        return factory;
    }

    public DistributedJDBCBrokerFactory(DistributedJDBCConfiguration conf) {
        super(conf);
    }

    @Override
    public DistributedJDBCConfiguration getConfiguration() {
        return (DistributedJDBCConfiguration)super.getConfiguration();
    }

    @Override
    public Slice addSlice(String name, Map properties) {
        Slice slice = ((DistributedJDBCConfigurationImpl)this.getConfiguration()).addSlice(name, properties);
        ClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        this.synchronizeMappings(loader, (JDBCConfiguration)slice.getConfiguration());
        Collection<Broker> brokers = this.getOpenBrokers();
        for (Broker broker : brokers) {
            ((DistributedBroker)broker).getDistributedStoreManager().addSlice(slice);
        }
        return slice;
    }

    @Override
    protected DistributedJDBCStoreManager newStoreManager() {
        return new DistributedJDBCStoreManager(this.getConfiguration());
    }

    @Override
    public DistributedBroker newBroker() {
        return new DistributedBrokerImpl();
    }

    @Override
    protected boolean synchronizeMappings(ClassLoader loader) {
        List<Slice> slices = this.getConfiguration().getSlices(Slice.Status.ACTIVE);
        boolean result = false;
        for (Slice slice : slices) {
            result = this.synchronizeMappings(loader, (JDBCConfiguration)slice.getConfiguration()) || result;
        }
        return result;
    }

    @Override
    protected Object getFactoryInitializationBanner() {
        return _loc.get("factory-init", OpenJPAVersion.VERSION_NUMBER);
    }
}

