/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.network.trace.component.command;

import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Command;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.oap.server.network.trace.component.command.BaseCommand;
import org.apache.skywalking.oap.server.network.trace.component.command.Deserializable;
import org.apache.skywalking.oap.server.network.trace.component.command.Serializable;

public class PprofTaskCommand
extends BaseCommand
implements Serializable,
Deserializable<PprofTaskCommand> {
    public static final Deserializable<PprofTaskCommand> DESERIALIZER = new PprofTaskCommand("", "", "", 0L, 0L, 0);
    public static final String NAME = "PprofTaskQuery";
    private String taskId;
    private String events;
    private long duration;
    private long createTime;
    private int dumpPeriod;

    public PprofTaskCommand(String serialNumber, String taskId, String events, long duration, long createTime, int dumpPeriod) {
        super(NAME, serialNumber);
        this.taskId = taskId;
        this.duration = duration;
        this.createTime = createTime;
        this.dumpPeriod = dumpPeriod;
        this.events = events;
    }

    @Override
    public PprofTaskCommand deserialize(Command command) {
        List<KeyStringValuePair> argsList = command.getArgsList();
        String taskId = null;
        String events = null;
        long duration = 0L;
        long createTime = 0L;
        int dumpPeriod = 0;
        String serialNumber = null;
        for (KeyStringValuePair pair : argsList) {
            if ("SerialNumber".equals(pair.getKey())) {
                serialNumber = pair.getValue();
                continue;
            }
            if ("TaskId".equals(pair.getKey())) {
                taskId = pair.getValue();
                continue;
            }
            if ("Events".equals(pair.getKey())) {
                events = pair.getValue();
                continue;
            }
            if ("Duration".equals(pair.getKey())) {
                duration = Long.parseLong(pair.getValue());
                continue;
            }
            if ("CreateTime".equals(pair.getKey())) {
                createTime = Long.parseLong(pair.getValue());
                continue;
            }
            if (!"DumpPeriod".equals(pair.getKey())) continue;
            dumpPeriod = Integer.parseInt(pair.getValue());
        }
        return new PprofTaskCommand(serialNumber, taskId, events, duration, createTime, dumpPeriod);
    }

    @Override
    public Command.Builder serialize() {
        Command.Builder builder = this.commandBuilder();
        builder.addArgs(KeyStringValuePair.newBuilder().setKey("TaskId").setValue(this.taskId)).addArgs(KeyStringValuePair.newBuilder().setKey("Events").setValue(this.events)).addArgs(KeyStringValuePair.newBuilder().setKey("Duration").setValue(String.valueOf(this.duration))).addArgs(KeyStringValuePair.newBuilder().setKey("CreateTime").setValue(String.valueOf(this.createTime))).addArgs(KeyStringValuePair.newBuilder().setKey("DumpPeriod").setValue(String.valueOf(this.dumpPeriod)));
        return builder;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getEvents() {
        return this.events;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public int getDumpPeriod() {
        return this.dumpPeriod;
    }
}

