/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Assert;
import graphql.Internal;
import graphql.com.google.common.collect.HashBiMap;
import graphql.com.google.common.collect.HashMultimap;
import graphql.com.google.common.collect.Multimaps;
import graphql.schema.GraphQLSchema;
import graphql.schema.diffing.DiffImpl;
import graphql.schema.diffing.EditOperation;
import graphql.schema.diffing.EditorialCostForMapping;
import graphql.schema.diffing.Mapping;
import graphql.schema.diffing.PossibleMappingsCalculator;
import graphql.schema.diffing.SchemaDiffingRunningCheck;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.SchemaGraphFactory;
import graphql.schema.diffing.Vertex;
import graphql.schema.diffing.ana.EditOperationAnalysisResult;
import graphql.schema.diffing.ana.EditOperationAnalyzer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
public class SchemaDiffing {
    private final SchemaDiffingRunningCheck runningCheck = new SchemaDiffingRunningCheck();
    SchemaGraph sourceGraph;
    SchemaGraph targetGraph;

    public void stop() {
        this.runningCheck.stop();
    }

    public List<EditOperation> diffGraphQLSchema(GraphQLSchema graphQLSchema1, GraphQLSchema graphQLSchema2) throws Exception {
        this.sourceGraph = new SchemaGraphFactory("source-").createGraph(graphQLSchema1);
        this.targetGraph = new SchemaGraphFactory("target-").createGraph(graphQLSchema2);
        return this.diffImpl(this.sourceGraph, this.targetGraph, new AtomicInteger()).getListOfEditOperations();
    }

    public EditOperationAnalysisResult diffAndAnalyze(GraphQLSchema graphQLSchema1, GraphQLSchema graphQLSchema2) throws Exception {
        this.sourceGraph = new SchemaGraphFactory("source-").createGraph(graphQLSchema1);
        this.targetGraph = new SchemaGraphFactory("target-").createGraph(graphQLSchema2);
        DiffImpl.OptimalEdit optimalEdit = this.diffImpl(this.sourceGraph, this.targetGraph, new AtomicInteger());
        EditOperationAnalyzer editOperationAnalyzer = new EditOperationAnalyzer(graphQLSchema1, graphQLSchema1, this.sourceGraph, this.targetGraph);
        return editOperationAnalyzer.analyzeEdits(optimalEdit.getListOfEditOperations(), optimalEdit.mapping);
    }

    public DiffImpl.OptimalEdit diffGraphQLSchemaAllEdits(GraphQLSchema graphQLSchema1, GraphQLSchema graphQLSchema2, AtomicInteger algoIterationCount) throws Exception {
        this.sourceGraph = new SchemaGraphFactory("source-").createGraph(graphQLSchema1);
        this.targetGraph = new SchemaGraphFactory("target-").createGraph(graphQLSchema2);
        return this.diffImpl(this.sourceGraph, this.targetGraph, algoIterationCount);
    }

    private DiffImpl.OptimalEdit diffImpl(SchemaGraph sourceGraph, SchemaGraph targetGraph, AtomicInteger algoIterationCount) throws Exception {
        PossibleMappingsCalculator possibleMappingsCalculator = new PossibleMappingsCalculator(sourceGraph, targetGraph, this.runningCheck);
        PossibleMappingsCalculator.PossibleMappings possibleMappings = possibleMappingsCalculator.calculate();
        Mapping startMapping = Mapping.newMapping(possibleMappingsCalculator.getFixedParentRestrictions(), possibleMappings.fixedOneToOneMappings, possibleMappings.fixedOneToOneSources, possibleMappings.fixedOneToOneTargets);
        Assert.assertTrue(sourceGraph.size() == targetGraph.size());
        if (possibleMappings.fixedOneToOneMappings.size() == sourceGraph.size()) {
            return new DiffImpl.OptimalEdit(sourceGraph, targetGraph, startMapping, EditorialCostForMapping.baseEditorialCostForMapping(startMapping, sourceGraph, targetGraph));
        }
        ArrayList<Vertex> nonMappedSource = new ArrayList<Vertex>(sourceGraph.getVertices());
        nonMappedSource.removeAll(possibleMappings.fixedOneToOneSources);
        ArrayList<Vertex> nonMappedTarget = new ArrayList<Vertex>(targetGraph.getVertices());
        nonMappedTarget.removeAll(possibleMappings.fixedOneToOneTargets);
        this.runningCheck.check();
        int isolatedSourceCount = (int)nonMappedSource.stream().filter(Vertex::isIsolated).count();
        int isolatedTargetCount = (int)nonMappedTarget.stream().filter(Vertex::isIsolated).count();
        if (isolatedTargetCount > isolatedSourceCount) {
            HashBiMap<Vertex, Vertex> fixedOneToOneInverted = HashBiMap.create();
            for (Vertex s : possibleMappings.fixedOneToOneMappings.keySet()) {
                Vertex t = (Vertex)possibleMappings.fixedOneToOneMappings.get(s);
                fixedOneToOneInverted.put(t, s);
            }
            Mapping startMappingInverted = Mapping.newMapping(possibleMappingsCalculator.getFixedParentRestrictionsInverse(fixedOneToOneInverted), fixedOneToOneInverted, possibleMappings.fixedOneToOneTargets, possibleMappings.fixedOneToOneSources);
            HashMultimap<Vertex, Vertex> invertedPossibleOnes = HashMultimap.create();
            Multimaps.invertFrom(possibleMappings.possibleMappings, invertedPossibleOnes);
            possibleMappings.possibleMappings = invertedPossibleOnes;
            ArrayList<Vertex> sourceVertices = new ArrayList<Vertex>();
            sourceVertices.addAll(possibleMappings.fixedOneToOneSources);
            sourceVertices.addAll(nonMappedSource);
            ArrayList<Vertex> targetVertices = new ArrayList<Vertex>();
            targetVertices.addAll(possibleMappings.fixedOneToOneTargets);
            targetVertices.addAll(nonMappedTarget);
            this.sortVertices(nonMappedTarget, targetGraph, possibleMappings);
            DiffImpl diffImpl = new DiffImpl(possibleMappingsCalculator, targetGraph, sourceGraph, possibleMappings, this.runningCheck);
            DiffImpl.OptimalEdit optimalEdit = diffImpl.diffImpl(startMappingInverted, targetVertices, sourceVertices, algoIterationCount);
            DiffImpl.OptimalEdit invertedBackOptimalEdit = new DiffImpl.OptimalEdit(sourceGraph, targetGraph, optimalEdit.mapping.invert(), optimalEdit.ged);
            return invertedBackOptimalEdit;
        }
        this.sortVertices(nonMappedSource, sourceGraph, possibleMappings);
        ArrayList<Vertex> sourceVertices = new ArrayList<Vertex>();
        sourceVertices.addAll(possibleMappings.fixedOneToOneSources);
        sourceVertices.addAll(nonMappedSource);
        ArrayList<Vertex> targetVertices = new ArrayList<Vertex>();
        targetVertices.addAll(possibleMappings.fixedOneToOneTargets);
        targetVertices.addAll(nonMappedTarget);
        DiffImpl diffImpl = new DiffImpl(possibleMappingsCalculator, sourceGraph, targetGraph, possibleMappings, this.runningCheck);
        DiffImpl.OptimalEdit optimalEdit = diffImpl.diffImpl(startMapping, sourceVertices, targetVertices, algoIterationCount);
        return optimalEdit;
    }

    private void sortVertices(List<Vertex> vertices, SchemaGraph schemaGraph, PossibleMappingsCalculator.PossibleMappings possibleMappings) {
        Comparator<Vertex> vertexComparator = Comparator.comparing(schemaGraph::adjacentEdgesAndInverseCount).reversed();
        vertices.sort(vertexComparator);
    }
}

