/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.module.CycleDependencyException;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleNotFoundException;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BootstrapFlow {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapFlow.class);
    private Map<String, ModuleDefine> loadedModules;
    private List<ModuleProvider> startupSequence;

    BootstrapFlow(Map<String, ModuleDefine> loadedModules) throws CycleDependencyException, ModuleNotFoundException {
        this.loadedModules = loadedModules;
        this.startupSequence = new ArrayList<ModuleProvider>();
        this.makeSequence();
    }

    void start(ModuleManager moduleManager) throws ModuleNotFoundException, ServiceNotProvidedException, ModuleStartException {
        for (ModuleProvider provider : this.startupSequence) {
            log.info("start the provider {} in {} module.", (Object)provider.name(), (Object)provider.getModuleName());
            provider.requiredCheck(provider.getModule().services());
            provider.start();
        }
    }

    void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        for (ModuleProvider provider : this.startupSequence) {
            provider.notifyAfterCompleted();
        }
    }

    private void makeSequence() throws CycleDependencyException, ModuleNotFoundException {
        ArrayList<ModuleProvider> allProviders = new ArrayList<ModuleProvider>();
        for (ModuleDefine module : this.loadedModules.values()) {
            String[] requiredModules = module.provider().requiredModules();
            if (requiredModules != null) {
                for (String requiredModule : requiredModules) {
                    if (this.loadedModules.containsKey(requiredModule)) continue;
                    throw new ModuleNotFoundException(requiredModule + " module is required by " + module.provider().getModuleName() + "." + module.provider().name() + ", but not found.");
                }
            }
            allProviders.add(module.provider());
        }
        do {
            int numOfToBeSequenced = allProviders.size();
            for (int i = 0; i < allProviders.size(); ++i) {
                ModuleProvider provider2 = (ModuleProvider)allProviders.get(i);
                Object[] requiredModules = provider2.requiredModules();
                if (CollectionUtils.isNotEmpty((Object[])requiredModules)) {
                    boolean isAllRequiredModuleStarted = true;
                    for (Object module : requiredModules) {
                        boolean exist = false;
                        for (ModuleProvider moduleProvider : this.startupSequence) {
                            if (!moduleProvider.getModuleName().equals(module)) continue;
                            exist = true;
                            break;
                        }
                        if (exist) continue;
                        isAllRequiredModuleStarted = false;
                        break;
                    }
                    if (!isAllRequiredModuleStarted) continue;
                    this.startupSequence.add(provider2);
                    allProviders.remove(i);
                    --i;
                    continue;
                }
                this.startupSequence.add(provider2);
                allProviders.remove(i);
                --i;
            }
            if (numOfToBeSequenced != allProviders.size()) continue;
            StringBuilder unSequencedProviders = new StringBuilder();
            allProviders.forEach(provider -> unSequencedProviders.append(provider.getModuleName()).append("[provider=").append(provider.getClass().getName()).append("]\n"));
            throw new CycleDependencyException("Exist cycle module dependencies in \n" + unSequencedProviders.substring(0, unSequencedProviders.length() - 1));
        } while (allProviders.size() != 0);
    }
}

