/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.common.stream.FixedStreamMessage;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;

@UnstableApi
public class OneElementFixedStreamMessage<T>
extends FixedStreamMessage<T> {
    @Nullable
    private T obj;

    public OneElementFixedStreamMessage(T obj) {
        this.obj = obj;
    }

    @Override
    public long demand() {
        return 0L;
    }

    @Override
    final void cleanupObjects(@Nullable Throwable cause) {
        if (this.obj != null) {
            StreamMessageUtil.closeOrAbort(this.obj, cause);
            this.obj = null;
        }
    }

    @Override
    final List<T> drainAll(boolean withPooledObjects) {
        assert (this.obj != null);
        T item = StreamMessageUtil.touchOrCopyAndClose(this.obj, withPooledObjects);
        this.obj = null;
        return ImmutableList.of(item);
    }

    @Override
    public void request(long n) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.request0(n);
        } else {
            executor.execute(() -> this.request0(n));
        }
    }

    private void request0(long n) {
        if (this.obj == null) {
            return;
        }
        if (n <= 0L) {
            this.onError(new IllegalArgumentException("n: " + n + " (expected: > 0, see Reactive Streams specification rule 3.9)"));
            return;
        }
        T item = this.obj;
        this.obj = null;
        this.onNext(item);
        this.onComplete();
    }

    @Override
    public void cancel() {
        if (this.obj == null) {
            return;
        }
        super.cancel();
    }

    @Override
    public void abort() {
        if (this.obj == null) {
            return;
        }
        super.abort();
    }

    @Override
    public void abort(Throwable cause) {
        if (this.obj == null) {
            return;
        }
        super.abort(cause);
    }
}

