/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.polaris.extension.auth.opa.OpaAuthorizationConfig;
import org.immutables.value.Generated;

@Generated(from="OpaAuthorizationConfig", generator="Immutables")
public final class ImmutableOpaAuthorizationConfig
implements OpaAuthorizationConfig {
    private final URI policyUri;
    private final OpaAuthorizationConfig.AuthenticationConfig auth;
    private final OpaAuthorizationConfig.HttpConfig http;
    private transient int hashCode;

    private ImmutableOpaAuthorizationConfig(URI policyUri, OpaAuthorizationConfig.AuthenticationConfig auth, OpaAuthorizationConfig.HttpConfig http) {
        this.policyUri = policyUri;
        this.auth = auth;
        this.http = http;
    }

    @Override
    public Optional<URI> policyUri() {
        return Optional.ofNullable(this.policyUri);
    }

    @Override
    public OpaAuthorizationConfig.AuthenticationConfig auth() {
        return this.auth;
    }

    @Override
    public OpaAuthorizationConfig.HttpConfig http() {
        return this.http;
    }

    public final ImmutableOpaAuthorizationConfig withPolicyUri(URI value) {
        URI newValue = Objects.requireNonNull(value, "policyUri");
        if (this.policyUri == newValue) {
            return this;
        }
        return new ImmutableOpaAuthorizationConfig(newValue, this.auth, this.http);
    }

    public final ImmutableOpaAuthorizationConfig withPolicyUri(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.policyUri == value) {
            return this;
        }
        return new ImmutableOpaAuthorizationConfig(value, this.auth, this.http);
    }

    public final ImmutableOpaAuthorizationConfig withAuth(OpaAuthorizationConfig.AuthenticationConfig value) {
        if (this.auth == value) {
            return this;
        }
        OpaAuthorizationConfig.AuthenticationConfig newValue = Objects.requireNonNull(value, "auth");
        return new ImmutableOpaAuthorizationConfig(this.policyUri, newValue, this.http);
    }

    public final ImmutableOpaAuthorizationConfig withHttp(OpaAuthorizationConfig.HttpConfig value) {
        if (this.http == value) {
            return this;
        }
        OpaAuthorizationConfig.HttpConfig newValue = Objects.requireNonNull(value, "http");
        return new ImmutableOpaAuthorizationConfig(this.policyUri, this.auth, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOpaAuthorizationConfig && this.equalsByValue((ImmutableOpaAuthorizationConfig)another);
    }

    private boolean equalsByValue(ImmutableOpaAuthorizationConfig another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.policyUri, another.policyUri) && this.auth.equals(another.auth) && this.http.equals(another.http);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.policyUri);
        h += (h << 5) + this.auth.hashCode();
        h += (h << 5) + this.http.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OpaAuthorizationConfig").omitNullValues().add("policyUri", (Object)this.policyUri).add("auth", (Object)this.auth).add("http", (Object)this.http).toString();
    }

    public static ImmutableOpaAuthorizationConfig copyOf(OpaAuthorizationConfig instance) {
        if (instance instanceof ImmutableOpaAuthorizationConfig) {
            return (ImmutableOpaAuthorizationConfig)instance;
        }
        return ImmutableOpaAuthorizationConfig.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableOpaAuthorizationConfig.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OpaAuthorizationConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_AUTH = 1L;
        private static final long INIT_BIT_HTTP = 2L;
        private long initBits = 3L;
        private URI policyUri;
        private OpaAuthorizationConfig.AuthenticationConfig auth;
        private OpaAuthorizationConfig.HttpConfig http;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OpaAuthorizationConfig instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<URI> policyUriOptional = instance.policyUri();
            if (policyUriOptional.isPresent()) {
                this.policyUri(policyUriOptional);
            }
            this.auth(instance.auth());
            this.http(instance.http());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder policyUri(URI policyUri) {
            this.policyUri = Objects.requireNonNull(policyUri, "policyUri");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder policyUri(Optional<? extends URI> policyUri) {
            this.policyUri = policyUri.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auth(OpaAuthorizationConfig.AuthenticationConfig auth) {
            this.auth = Objects.requireNonNull(auth, "auth");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder http(OpaAuthorizationConfig.HttpConfig http) {
            this.http = Objects.requireNonNull(http, "http");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 3L;
            this.policyUri = null;
            this.auth = null;
            this.http = null;
            return this;
        }

        public ImmutableOpaAuthorizationConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOpaAuthorizationConfig(this.policyUri, this.auth, this.http);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("auth");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("http");
            }
            return "Cannot build OpaAuthorizationConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

