/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.gcp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CredentialAccessBoundary;
import com.google.auth.oauth2.DownscopedCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.storage.InMemoryStorageIntegration;
import org.apache.polaris.core.storage.StorageAccessConfig;
import org.apache.polaris.core.storage.StorageAccessProperty;
import org.apache.polaris.core.storage.StorageUtil;
import org.apache.polaris.core.storage.gcp.GcpStorageConfigurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcpCredentialsStorageIntegration
extends InMemoryStorageIntegration<GcpStorageConfigurationInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GcpCredentialsStorageIntegration.class);
    private final GoogleCredentials sourceCredentials;
    private final HttpTransportFactory transportFactory;

    public GcpCredentialsStorageIntegration(GcpStorageConfigurationInfo config, GoogleCredentials sourceCredentials, HttpTransportFactory transportFactory) {
        super(config, GcpCredentialsStorageIntegration.class.getName());
        this.sourceCredentials = sourceCredentials.createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
        this.transportFactory = transportFactory;
    }

    @Override
    public StorageAccessConfig getSubscopedCreds(@Nonnull RealmConfig realmConfig, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        AccessToken token;
        try {
            this.sourceCredentials.refresh();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to refresh GCP credentials", e);
        }
        CredentialAccessBoundary accessBoundary = GcpCredentialsStorageIntegration.generateAccessBoundaryRules(allowListOperation, allowedReadLocations, allowedWriteLocations);
        DownscopedCredentials credentials = DownscopedCredentials.newBuilder().setHttpTransportFactory(this.transportFactory).setSourceCredential(this.sourceCredentials).setCredentialAccessBoundary(accessBoundary).build();
        try {
            token = credentials.refreshAccessToken();
        }
        catch (IOException e) {
            LOGGER.atError().addKeyValue("readLocations", allowedReadLocations).addKeyValue("writeLocations", allowedWriteLocations).addKeyValue("includesList", (Object)allowListOperation).addKeyValue("accessBoundary", (Object)this.convertToString(accessBoundary)).log("Unable to refresh access credentials", (Object)e);
            throw new RuntimeException("Unable to fetch access credentials " + e.getMessage());
        }
        StorageAccessConfig.Builder accessConfig = StorageAccessConfig.builder();
        accessConfig.put(StorageAccessProperty.GCS_ACCESS_TOKEN, token.getTokenValue());
        accessConfig.put(StorageAccessProperty.GCS_ACCESS_TOKEN_EXPIRES_AT, String.valueOf(token.getExpirationTime().getTime()));
        refreshCredentialsEndpoint.ifPresent(endpoint -> accessConfig.put(StorageAccessProperty.GCS_REFRESH_CREDENTIALS_ENDPOINT, (String)endpoint));
        return accessConfig.build();
    }

    private String convertToString(CredentialAccessBoundary accessBoundary) {
        try {
            return new ObjectMapper().writeValueAsString((Object)accessBoundary);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Unable to convert access boundary to json", (Throwable)e);
            return Objects.toString(accessBoundary);
        }
    }

    @VisibleForTesting
    public static CredentialAccessBoundary generateAccessBoundaryRules(boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations) {
        HashMap readConditionsMap = new HashMap();
        HashMap writeConditionsMap = new HashMap();
        HashSet readBuckets = new HashSet();
        HashSet writeBuckets = new HashSet();
        Stream.concat(allowedReadLocations.stream(), allowedWriteLocations.stream()).distinct().forEach(location -> {
            URI uri = URI.create(location);
            String bucket = StorageUtil.getBucket(uri);
            readBuckets.add(bucket);
            String path = uri.getPath().substring(1);
            List resourceExpressions = readConditionsMap.computeIfAbsent(bucket, key -> new ArrayList());
            resourceExpressions.add(String.format("resource.name.startsWith('projects/_/buckets/%s/objects/%s')", bucket, path));
            if (allowListOperation) {
                resourceExpressions.add(String.format("api.getAttribute('storage.googleapis.com/objectListPrefix', '').startsWith('%s')", path));
            }
            if (allowedWriteLocations.contains(location)) {
                writeBuckets.add(bucket);
                List writeExpressions = writeConditionsMap.computeIfAbsent(bucket, key -> new ArrayList());
                writeExpressions.add(String.format("resource.name.startsWith('projects/_/buckets/%s/objects/%s')", bucket, path));
            }
        });
        CredentialAccessBoundary.Builder accessBoundaryBuilder = CredentialAccessBoundary.newBuilder();
        readBuckets.forEach(bucket -> {
            List readConditions = (List)readConditionsMap.get(bucket);
            if (readConditions == null || readConditions.isEmpty()) {
                return;
            }
            CredentialAccessBoundary.AccessBoundaryRule.Builder builder = CredentialAccessBoundary.AccessBoundaryRule.newBuilder();
            builder.setAvailableResource(GcpCredentialsStorageIntegration.bucketResource(bucket));
            builder.setAvailabilityCondition(CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression(String.join((CharSequence)" || ", readConditions)).build());
            builder.setAvailablePermissions(List.of("inRole:roles/storage.legacyObjectReader"));
            if (allowListOperation) {
                builder.addAvailablePermission("inRole:roles/storage.objectViewer");
            }
            accessBoundaryBuilder.addRule(builder.build());
        });
        writeBuckets.forEach(bucket -> {
            List writeConditions = (List)writeConditionsMap.get(bucket);
            if (writeConditions == null || writeConditions.isEmpty()) {
                return;
            }
            CredentialAccessBoundary.AccessBoundaryRule.Builder builder = CredentialAccessBoundary.AccessBoundaryRule.newBuilder();
            builder.setAvailableResource(GcpCredentialsStorageIntegration.bucketResource(bucket));
            builder.setAvailabilityCondition(CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression(String.join((CharSequence)" || ", writeConditions)).build());
            builder.setAvailablePermissions(List.of("inRole:roles/storage.legacyBucketWriter"));
            accessBoundaryBuilder.addRule(builder.build());
        });
        return accessBoundaryBuilder.build();
    }

    private static String bucketResource(String bucket) {
        return "//storage.googleapis.com/projects/_/buckets/" + bucket;
    }
}

