/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.iotdb.library.dprofile.util.YuleWalker;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFPACF
implements UDTF {
    ArrayList<Double> value = new ArrayList();
    ArrayList<Long> timestamp = new ArrayList();
    int lag;
    int n = 0;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.value.clear();
        this.timestamp.clear();
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.lag = parameters.getIntOrDefault("lag", -1);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double v = Util.getValueAsDouble(row);
        if (Double.isFinite(v)) {
            this.value.add(v);
        } else {
            this.value.add(0.0);
        }
        this.timestamp.add(row.getTime());
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        String method = "adjusted";
        this.n = this.value.size();
        if (this.n > 1) {
            if (this.lag < 0 || this.lag > this.value.size() - 1) {
                this.lag = Math.min((int)(10.0 * Math.log10(this.value.size())), this.value.size() - 1);
            }
            double[] x = Arrays.stream(this.value.toArray(new Double[0])).mapToDouble(Double::valueOf).toArray();
            double xmean = StatUtils.mean(x);
            int i = 0;
            while (i < x.length) {
                int n = i++;
                x[n] = x[n] - xmean;
            }
            collector.putDouble(this.timestamp.get(0), 1.0);
            for (int k = 1; k <= this.lag; ++k) {
                collector.putDouble(this.timestamp.get(k), new YuleWalker().yuleWalker(x, k, method, this.n));
            }
        }
    }
}

