/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils;

import java.io.IOException;
import java.util.List;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.read.reader.page.ValuePageReader;
import org.apache.tsfile.utils.TsPrimitiveType;

public class CompactionAlignedPageLazyLoadPointReader
implements IPointReader {
    private final TimePageReader timeReader;
    private final List<ValuePageReader> valueReaders;
    private final boolean ignoreAllNullRows;
    private boolean hasNextRow = false;
    private int timeIndex = -1;
    private long currentTime;
    private TsPrimitiveType currentRow;

    public CompactionAlignedPageLazyLoadPointReader(TimePageReader timeReader, List<ValuePageReader> valueReaders, boolean ignoreAllNullRows) throws IOException {
        this.timeReader = timeReader;
        this.valueReaders = valueReaders;
        this.ignoreAllNullRows = ignoreAllNullRows;
        this.prepareNextRow();
    }

    private void prepareNextRow() throws IOException {
        while (this.timeReader.hasNextTime()) {
            this.currentTime = this.timeReader.nextTime();
            ++this.timeIndex;
            boolean someValueNotNull = false;
            TsPrimitiveType[] valuesInThisRow = new TsPrimitiveType[this.valueReaders.size()];
            for (int i = 0; i < this.valueReaders.size(); ++i) {
                TsPrimitiveType value = this.valueReaders.get(i) == null ? null : this.valueReaders.get(i).nextValue(this.currentTime, this.timeIndex);
                someValueNotNull = someValueNotNull || value != null;
                valuesInThisRow[i] = value;
            }
            if (this.timeReader.isDeleted(this.currentTime) || this.ignoreAllNullRows && !someValueNotNull) continue;
            this.currentRow = new TsPrimitiveType.TsVector(valuesInThisRow);
            this.hasNextRow = true;
            return;
        }
        this.hasNextRow = false;
    }

    public boolean hasNextTimeValuePair() throws IOException {
        return this.hasNextRow;
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        TimeValuePair ret = this.currentTimeValuePair();
        this.prepareNextRow();
        return ret;
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        return new TimeValuePair(this.currentTime, this.currentRow);
    }

    public long getUsedMemorySize() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

