# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.2.1",
                "commands": r"cc",
                "args": r"",
                "linker args": r"",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.2.4",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.2.1",
                "commands": r"c++",
                "args": r"",
                "linker args": r"",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.2.1",
                "commands": r"gfortran",
                "args": r"",
                "linker args": r"",
            },
            "pythran": {
                "version": r"0.18.1",
                "include directory": r"../../tmp/build-env-99dkri7b/lib/python3.11/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"aarch64",
                "family": r"aarch64",
                "endian": r"little",
                "system": r"linux",
            },
            "build": {
                "cpu": r"aarch64",
                "family": r"aarch64",
                "endian": r"little",
                "system": r"linux",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "scipy-openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.30",
                "detection method": "pkgconfig",
                "include directory": r"/opt/_internal/cpython-3.11.13/lib/python3.11/site-packages/scipy_openblas32/include",
                "lib directory": r"/opt/_internal/cpython-3.11.13/lib/python3.11/site-packages/scipy_openblas32/lib",
                "openblas configuration": r"OpenBLAS 0.3.30 DYNAMIC_ARCH NO_AFFINITY neoversev2 MAX_THREADS=64",
                "pc file directory": r"/project/",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "lapack": {
                "name": "scipy-openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.30",
                "detection method": "pkgconfig",
                "include directory": r"/opt/_internal/cpython-3.11.13/lib/python3.11/site-packages/scipy_openblas32/include",
                "lib directory": r"/opt/_internal/cpython-3.11.13/lib/python3.11/site-packages/scipy_openblas32/lib",
                "openblas configuration": r"OpenBLAS 0.3.30 DYNAMIC_ARCH NO_AFFINITY neoversev2 MAX_THREADS=64",
                "pc file directory": r"/project/",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "pybind11": {
                "name": "pybind11",
                "version": "3.0.2",
                "detection method": "config-tool",
                "include directory": r"unknown",
            },
        },
        "Python Information": {
            "path": r"/tmp/build-env-99dkri7b/bin/python",
            "version": "3.11",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Examples
    --------
    >>> import scipy
    >>> scipy.show_config()
    ... # formatted output is printed to the console

    >>> config_dict = scipy.show_config(mode='dicts')
    >>> list(config_dict.keys())
    ['Compilers', 'Machine Information', 'Build Dependencies', 'Python Information']

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
