/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.iotdb.commons.pipe.config.constant;

public class SystemConstant {

  // This can be arbitrarily changed since it's only a memory key and not stored
  public static final String RESTART_OR_NEWLY_ADDED_KEY = "__system.restart_or_newly_added";
  public static final boolean RESTART_OR_NEWLY_ADDED_DEFAULT_VALUE = false;

  private SystemConstant() {
    throw new IllegalStateException("Utility class");
  }
}
