/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.iotdb.commons.exception.pipe;

import java.util.Objects;

public class PipeRuntimeSinkRetryTimesConfigurableException
    extends PipeRuntimeSinkCriticalException {

  private final int retryTimes;

  public PipeRuntimeSinkRetryTimesConfigurableException(
      final String message, final int retryTimes) {
    super(message);
    this.retryTimes = retryTimes;
  }

  public int getRetryTimes() {
    return retryTimes;
  }

  // We do not record the timestamp here for logger reduction detection
  @Override
  public String toString() {
    return "PipeRuntimeSinkRetryTimesConfigurableException{"
        + "message='"
        + getMessage()
        + "', retryTimes='"
        + retryTimes
        + "'}";
  }

  @Override
  public boolean equals(final Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final PipeRuntimeSinkRetryTimesConfigurableException that =
        (PipeRuntimeSinkRetryTimesConfigurableException) o;
    return super.equals(that) && retryTimes == that.retryTimes;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), retryTimes);
  }
}
