/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushStatus;
import org.apache.iotdb.db.storageengine.dataregion.flush.NotifyFlushMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.WritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.WritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IChunkHandle;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.MemAlignedChunkHandleImpl;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.MemChunkHandleImpl;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public abstract class AbstractMemTable
implements IMemTable {
    public static final AtomicLong memTableIdCounter = new AtomicLong(-1L);
    private static final int FIXED_SERIALIZED_SIZE = 57;
    private final Map<IDeviceID, IWritableMemChunkGroup> memTableMap;
    private static final DeviceIDFactory deviceIDFactory = DeviceIDFactory.getInstance();
    private boolean shouldFlush = false;
    private volatile FlushStatus flushStatus = FlushStatus.WORKING;
    private long memSize = 0L;
    private long tvListRamCost = 0L;
    private int seriesNumber = 0;
    private long totalPointsNum = 0L;
    private long totalPointsNumThreshold = 0L;
    private long maxPlanIndex = Long.MIN_VALUE;
    private long minPlanIndex = Long.MAX_VALUE;
    private final long memTableId = memTableIdCounter.incrementAndGet();
    private final long createdTime;
    private long updateTime = this.createdTime = System.currentTimeMillis();
    private long lastTotalPointsNum = this.totalPointsNum;
    private String database;
    private String dataRegionId;
    private static final String METRIC_POINT_IN = Metric.POINTS_IN.toString();

    protected AbstractMemTable() {
        this.database = null;
        this.dataRegionId = null;
        this.memTableMap = new HashMap<IDeviceID, IWritableMemChunkGroup>();
    }

    protected AbstractMemTable(String database, String dataRegionId) {
        this.database = database;
        this.dataRegionId = dataRegionId;
        this.memTableMap = new HashMap<IDeviceID, IWritableMemChunkGroup>();
    }

    protected AbstractMemTable(String database, String dataRegionId, Map<IDeviceID, IWritableMemChunkGroup> memTableMap) {
        this.database = database;
        this.dataRegionId = dataRegionId;
        this.memTableMap = memTableMap;
    }

    @Override
    public Map<IDeviceID, IWritableMemChunkGroup> getMemTableMap() {
        return this.memTableMap;
    }

    private IWritableMemChunkGroup createMemChunkGroupIfNotExistAndGet(IDeviceID deviceId, List<IMeasurementSchema> schemaList) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.computeIfAbsent(deviceId, k -> new WritableMemChunkGroup());
        for (IMeasurementSchema schema : schemaList) {
            if (schema == null || memChunkGroup.contains(schema.getMeasurementId())) continue;
            ++this.seriesNumber;
        }
        return memChunkGroup;
    }

    private IWritableMemChunkGroup createAlignedMemChunkGroupIfNotExistAndGet(IDeviceID deviceId, List<IMeasurementSchema> schemaList) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.computeIfAbsent(deviceId, k -> {
            this.seriesNumber += schemaList.size();
            return new AlignedWritableMemChunkGroup(schemaList.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        });
        for (IMeasurementSchema schema : schemaList) {
            if (schema == null || memChunkGroup.contains(schema.getMeasurementId())) continue;
            ++this.seriesNumber;
        }
        return memChunkGroup;
    }

    @Override
    public int insert(InsertRowNode insertRowNode) {
        String[] measurements = insertRowNode.getMeasurements();
        Object[] values = insertRowNode.getValues();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        int nullPointsNumber = 0;
        for (int i = 0; i < insertRowNode.getMeasurements().length; ++i) {
            if (measurements[i] == null || values[i] == null) {
                if (values[i] == null) {
                    ++nullPointsNumber;
                }
                schemaList.add(null);
                continue;
            }
            MeasurementSchema schema = insertRowNode.getMeasurementSchemas()[i];
            schemaList.add((IMeasurementSchema)schema);
            dataTypes.add(schema.getType());
        }
        this.memSize += MemUtils.getRowRecordSize(dataTypes, values);
        this.write(insertRowNode.getDeviceID(), schemaList, insertRowNode.getTime(), values);
        int pointsInserted = insertRowNode.getMeasurements().length - insertRowNode.getFailedMeasurementNumber() - nullPointsNumber;
        this.totalPointsNum += (long)pointsInserted;
        return pointsInserted;
    }

    @Override
    public int insertAlignedRow(InsertRowNode insertRowNode) {
        String[] measurements = insertRowNode.getMeasurements();
        Object[] values = insertRowNode.getValues();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < insertRowNode.getMeasurements().length; ++i) {
            if (measurements[i] == null || values[i] == null) {
                schemaList.add(null);
                continue;
            }
            MeasurementSchema schema = insertRowNode.getMeasurementSchemas()[i];
            schemaList.add((IMeasurementSchema)schema);
            dataTypes.add(schema.getType());
        }
        if (schemaList.isEmpty()) {
            return 0;
        }
        this.memSize += MemUtils.getAlignedRowRecordSize(dataTypes, values);
        this.writeAlignedRow(insertRowNode.getDeviceID(), schemaList, insertRowNode.getTime(), values);
        int pointsInserted = insertRowNode.getMeasurements().length - insertRowNode.getFailedMeasurementNumber();
        this.totalPointsNum += (long)pointsInserted;
        return pointsInserted;
    }

    @Override
    public int insertTablet(InsertTabletNode insertTabletNode, int start, int end) throws WriteProcessException {
        try {
            this.writeTabletNode(insertTabletNode, start, end);
            this.memSize += MemUtils.getTabletSize(insertTabletNode, start, end);
            int pointsInserted = (insertTabletNode.getDataTypes().length - insertTabletNode.getFailedMeasurementNumber()) * (end - start);
            this.totalPointsNum += (long)pointsInserted;
            return pointsInserted;
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e);
        }
    }

    @Override
    public int insertAlignedTablet(InsertTabletNode insertTabletNode, int start, int end) throws WriteProcessException {
        try {
            this.writeAlignedTablet(insertTabletNode, start, end);
            this.memSize += MemUtils.getAlignedTabletSize(insertTabletNode, start, end);
            int pointsInserted = (insertTabletNode.getDataTypes().length - insertTabletNode.getFailedMeasurementNumber()) * (end - start);
            this.totalPointsNum += (long)pointsInserted;
            return pointsInserted;
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e);
        }
    }

    @Override
    public void updateMemtablePointCountMetric(InsertNode insertNode, int pointsInserted) {
        MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        if (!insertNode.isGeneratedByRemoteConsensusLeader()) {
            MetricService.getInstance().count((long)pointsInserted, Metric.LEADER_QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        }
    }

    @Override
    public void write(IDeviceID deviceId, List<IMeasurementSchema> schemaList, long insertTime, Object[] objectValue) {
        IWritableMemChunkGroup memChunkGroup = this.createMemChunkGroupIfNotExistAndGet(deviceId, schemaList);
        memChunkGroup.writeRow(insertTime, objectValue, schemaList);
    }

    @Override
    public void writeAlignedRow(IDeviceID deviceId, List<IMeasurementSchema> schemaList, long insertTime, Object[] objectValue) {
        IWritableMemChunkGroup memChunkGroup = this.createAlignedMemChunkGroupIfNotExistAndGet(deviceId, schemaList);
        memChunkGroup.writeRow(insertTime, objectValue, schemaList);
    }

    public void writeTabletNode(InsertTabletNode insertTabletNode, int start, int end) {
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        for (int i = 0; i < insertTabletNode.getMeasurementSchemas().length; ++i) {
            if (insertTabletNode.getColumns()[i] == null) {
                schemaList.add(null);
                continue;
            }
            schemaList.add((IMeasurementSchema)insertTabletNode.getMeasurementSchemas()[i]);
        }
        IWritableMemChunkGroup memChunkGroup = this.createMemChunkGroupIfNotExistAndGet(insertTabletNode.getDeviceID(), schemaList);
        memChunkGroup.writeTablet(insertTabletNode.getTimes(), insertTabletNode.getColumns(), insertTabletNode.getBitMaps(), schemaList, start, end);
    }

    public void writeAlignedTablet(InsertTabletNode insertTabletNode, int start, int end) {
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        for (int i = 0; i < insertTabletNode.getMeasurementSchemas().length; ++i) {
            if (insertTabletNode.getColumns()[i] == null) {
                schemaList.add(null);
                continue;
            }
            schemaList.add((IMeasurementSchema)insertTabletNode.getMeasurementSchemas()[i]);
        }
        if (schemaList.isEmpty()) {
            return;
        }
        IWritableMemChunkGroup memChunkGroup = this.createAlignedMemChunkGroupIfNotExistAndGet(insertTabletNode.getDeviceID(), schemaList);
        memChunkGroup.writeTablet(insertTabletNode.getTimes(), insertTabletNode.getColumns(), insertTabletNode.getBitMaps(), schemaList, start, end);
    }

    @Override
    public boolean checkIfChunkDoesNotExist(IDeviceID deviceId, String measurement) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceId);
        if (null == memChunkGroup) {
            return true;
        }
        return !memChunkGroup.contains(measurement);
    }

    @Override
    public IWritableMemChunk getWritableMemChunk(IDeviceID deviceId, String measurement) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceId);
        if (null == memChunkGroup) {
            return null;
        }
        return memChunkGroup.getWritableMemChunk(measurement);
    }

    @Override
    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    @Override
    public long getTotalPointsNum() {
        return this.totalPointsNum;
    }

    @Override
    public long size() {
        long sum = 0L;
        for (IWritableMemChunkGroup writableMemChunkGroup : this.memTableMap.values()) {
            sum += writableMemChunkGroup.count();
        }
        return sum;
    }

    @Override
    public long memSize() {
        return this.memSize;
    }

    @Override
    public void clear() {
        this.memTableMap.clear();
        this.memSize = 0L;
        this.seriesNumber = 0;
        this.totalPointsNum = 0L;
        this.totalPointsNumThreshold = 0L;
        this.tvListRamCost = 0L;
        this.maxPlanIndex = 0L;
        this.minPlanIndex = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.memTableMap.isEmpty();
    }

    @Override
    public ReadOnlyMemChunk query(QueryContext context, PartialPath fullPath, long ttlLowerBound, List<Pair<Modification, IMemTable>> modsToMemtable, Filter globalTimeFilter) throws IOException, QueryProcessException {
        return ResourceByPathUtils.getResourceInstance(fullPath).getReadOnlyMemChunkFromMemTable(context, this, modsToMemtable, ttlLowerBound, globalTimeFilter);
    }

    @Override
    public void queryForSeriesRegionScan(PartialPath fullPath, long ttlLowerBound, Map<String, List<IChunkMetadata>> chunkMetaDataMap, Map<String, List<IChunkHandle>> memChunkHandleMap, List<Pair<Modification, IMemTable>> modsToMemTabled, Filter globalTimeFilter) {
        IDeviceID deviceID = DeviceIDFactory.getInstance().getDeviceID(fullPath.getDevicePath());
        if (fullPath instanceof MeasurementPath) {
            String measurementId = fullPath.getMeasurement();
            if (!this.memTableMap.containsKey(deviceID) || !this.memTableMap.get(deviceID).contains(measurementId)) {
                return;
            }
            List<TimeRange> deletionList = new ArrayList<TimeRange>();
            if (modsToMemTabled != null) {
                deletionList = ModificationUtils.constructDeletionList((MeasurementPath)fullPath, (IMemTable)this, modsToMemTabled, ttlLowerBound);
            }
            this.getMemChunkHandleFromMemTable(deviceID, measurementId, chunkMetaDataMap, memChunkHandleMap, deletionList, globalTimeFilter);
        } else {
            if (!this.memTableMap.containsKey(deviceID)) {
                return;
            }
            ArrayList<List<TimeRange>> deletionList = new ArrayList();
            if (modsToMemTabled != null) {
                deletionList = ModificationUtils.constructDeletionList((AlignedPath)fullPath, (IMemTable)this, modsToMemTabled, ttlLowerBound);
            }
            this.getMemAlignedChunkHandleFromMemTable(deviceID, ((AlignedPath)fullPath).getSchemaList(), chunkMetaDataMap, memChunkHandleMap, deletionList, globalTimeFilter);
        }
    }

    @Override
    public void queryForDeviceRegionScan(IDeviceID deviceID, boolean isAligned, long ttlLowerBound, Map<String, List<IChunkMetadata>> chunkMetadataMap, Map<String, List<IChunkHandle>> memChunkHandleMap, List<Pair<Modification, IMemTable>> modsToMemTabled, Filter globalTimeFilter) throws IllegalPathException {
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = this.getMemTableMap();
        if (!memTableMap.containsKey(deviceID)) {
            return;
        }
        IWritableMemChunkGroup writableMemChunkGroup = memTableMap.get(deviceID);
        if (isAligned) {
            this.getMemAlignedChunkHandleFromMemTable(deviceID, (AlignedWritableMemChunkGroup)writableMemChunkGroup, chunkMetadataMap, memChunkHandleMap, ttlLowerBound, modsToMemTabled, globalTimeFilter);
        } else {
            this.getMemChunkHandleFromMemTable(deviceID, (WritableMemChunkGroup)writableMemChunkGroup, chunkMetadataMap, memChunkHandleMap, ttlLowerBound, modsToMemTabled, globalTimeFilter);
        }
    }

    private void getMemChunkHandleFromMemTable(IDeviceID deviceID, String measurementId, Map<String, List<IChunkMetadata>> chunkMetadataMap, Map<String, List<IChunkHandle>> memChunkHandleMap, List<TimeRange> deletionList, Filter globalTimeFilter) {
        WritableMemChunk memChunk = (WritableMemChunk)this.memTableMap.get(deviceID).getMemChunkMap().get(measurementId);
        if (memChunk == null) {
            return;
        }
        Optional<Long> anySatisfiedTimestamp = memChunk.getAnySatisfiedTimestamp(deletionList, globalTimeFilter);
        if (!anySatisfiedTimestamp.isPresent()) {
            return;
        }
        long satisfiedTimestamp = anySatisfiedTimestamp.get();
        chunkMetadataMap.computeIfAbsent(measurementId, k -> new ArrayList()).add(this.buildFakeChunkMetaDataForFakeMemoryChunk(measurementId, satisfiedTimestamp, satisfiedTimestamp, Collections.emptyList()));
        memChunkHandleMap.computeIfAbsent(measurementId, k -> new ArrayList()).add(new MemChunkHandleImpl(deviceID, measurementId, new long[]{satisfiedTimestamp}));
    }

    private void getMemAlignedChunkHandleFromMemTable(IDeviceID deviceID, List<IMeasurementSchema> schemaList, Map<String, List<IChunkMetadata>> chunkMetadataList, Map<String, List<IChunkHandle>> memChunkHandleMap, List<List<TimeRange>> deletionList, Filter globalTimeFilter) {
        AlignedWritableMemChunk alignedMemChunk = ((AlignedWritableMemChunkGroup)this.memTableMap.get(deviceID)).getAlignedMemChunk();
        boolean containsMeasurement = false;
        for (IMeasurementSchema measurementSchema : schemaList) {
            if (!alignedMemChunk.containsMeasurement(measurementSchema.getMeasurementId())) continue;
            containsMeasurement = true;
            break;
        }
        if (!containsMeasurement) {
            return;
        }
        ArrayList<BitMap> bitMaps = new ArrayList<BitMap>();
        long[] timestamps = alignedMemChunk.getAnySatisfiedTimestamp(deletionList, bitMaps, globalTimeFilter);
        if (timestamps.length == 0) {
            return;
        }
        this.buildAlignedMemChunkHandle(deviceID, timestamps, bitMaps, deletionList, schemaList, chunkMetadataList, memChunkHandleMap);
    }

    private void getMemAlignedChunkHandleFromMemTable(IDeviceID deviceID, AlignedWritableMemChunkGroup writableMemChunkGroup, Map<String, List<IChunkMetadata>> chunkMetadataList, Map<String, List<IChunkHandle>> memChunkHandleMap, long ttlLowerBound, List<Pair<Modification, IMemTable>> modsToMemTabled, Filter globalTimeFilter) throws IllegalPathException {
        ArrayList<BitMap> bitMaps;
        long[] timestamps;
        AlignedWritableMemChunk memChunk = writableMemChunkGroup.getAlignedMemChunk();
        List<IMeasurementSchema> schemaList = memChunk.getSchemaList();
        ArrayList<List<TimeRange>> deletionList = new ArrayList<List<TimeRange>>();
        if (modsToMemTabled != null) {
            for (IMeasurementSchema schema : schemaList) {
                deletionList.add(ModificationUtils.constructDeletionList(new MeasurementPath(deviceID, schema.getMeasurementId(), schema), (IMemTable)this, modsToMemTabled, ttlLowerBound));
            }
        }
        if ((timestamps = memChunk.getAnySatisfiedTimestamp(deletionList, bitMaps = new ArrayList<BitMap>(), globalTimeFilter)).length == 0) {
            return;
        }
        this.buildAlignedMemChunkHandle(deviceID, timestamps, bitMaps, deletionList, schemaList, chunkMetadataList, memChunkHandleMap);
    }

    private void getMemChunkHandleFromMemTable(IDeviceID deviceID, WritableMemChunkGroup writableMemChunkGroup, Map<String, List<IChunkMetadata>> chunkMetadataMap, Map<String, List<IChunkHandle>> memChunkHandleMap, long ttlLowerBound, List<Pair<Modification, IMemTable>> modsToMemTabled, Filter globalTimeFilter) throws IllegalPathException {
        for (Map.Entry<String, IWritableMemChunk> entry : writableMemChunkGroup.getMemChunkMap().entrySet()) {
            Optional<Long> anySatisfiedTimestamp;
            String measurementId = entry.getKey();
            WritableMemChunk writableMemChunk = (WritableMemChunk)entry.getValue();
            List<TimeRange> deletionList = new ArrayList<TimeRange>();
            if (modsToMemTabled != null) {
                deletionList = ModificationUtils.constructDeletionList(new MeasurementPath(deviceID, measurementId, null), (IMemTable)this, modsToMemTabled, ttlLowerBound);
            }
            if (!(anySatisfiedTimestamp = writableMemChunk.getAnySatisfiedTimestamp(deletionList, globalTimeFilter)).isPresent()) {
                return;
            }
            long satisfiedTimestamp = anySatisfiedTimestamp.get();
            chunkMetadataMap.computeIfAbsent(measurementId, k -> new ArrayList()).add(this.buildFakeChunkMetaDataForFakeMemoryChunk(measurementId, satisfiedTimestamp, satisfiedTimestamp, Collections.emptyList()));
            memChunkHandleMap.computeIfAbsent(measurementId, k -> new ArrayList()).add(new MemChunkHandleImpl(deviceID, measurementId, new long[]{satisfiedTimestamp}));
        }
    }

    private void buildAlignedMemChunkHandle(IDeviceID deviceID, long[] timestamps, List<BitMap> bitMaps, List<List<TimeRange>> deletionList, List<IMeasurementSchema> schemaList, Map<String, List<IChunkMetadata>> chunkMetadataList, Map<String, List<IChunkHandle>> chunkHandleMap) {
        for (int column = 0; column < schemaList.size(); ++column) {
            String measurement = schemaList.get(column).getMeasurementId();
            List<TimeRange> deletion = deletionList == null || deletionList.isEmpty() ? Collections.emptyList() : deletionList.get(column);
            long[] startEndTime = this.calculateStartEndTime(timestamps, bitMaps, column);
            chunkMetadataList.computeIfAbsent(measurement, k -> new ArrayList()).add(this.buildFakeChunkMetaDataForFakeMemoryChunk(measurement, startEndTime[0], startEndTime[1], deletion));
            chunkHandleMap.computeIfAbsent(measurement, k -> new ArrayList()).add(new MemAlignedChunkHandleImpl(deviceID, measurement, timestamps, bitMaps, column, startEndTime));
        }
    }

    private long[] calculateStartEndTime(long[] timestamps, List<BitMap> bitMaps, int column) {
        int i;
        if (bitMaps.isEmpty()) {
            return new long[]{timestamps[0], timestamps[timestamps.length - 1]};
        }
        long startTime = -1L;
        long endTime = -1L;
        for (i = 0; i < timestamps.length; ++i) {
            if (bitMaps.get(i).isMarked(column)) continue;
            startTime = timestamps[i];
            break;
        }
        for (i = timestamps.length - 1; i >= 0; --i) {
            if (bitMaps.get(i).isMarked(column)) continue;
            endTime = timestamps[i];
            break;
        }
        return new long[]{startTime, endTime};
    }

    private IChunkMetadata buildFakeChunkMetaDataForFakeMemoryChunk(String measurement, long startTime, long endTime, List<TimeRange> deletionList) {
        TimeStatistics timeStatistics = new TimeStatistics();
        timeStatistics.setStartTime(startTime);
        timeStatistics.setEndTime(endTime);
        ChunkMetadata chunkMetadata = new ChunkMetadata(measurement, TSDataType.UNKNOWN, 0L, (Statistics)timeStatistics);
        for (TimeRange timeRange : deletionList) {
            chunkMetadata.insertIntoSortedDeletions(timeRange);
        }
        return chunkMetadata;
    }

    @Override
    public void delete(PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        if (devicePath.hasWildcard()) {
            ArrayList<Pair> targetDeviceList = new ArrayList<Pair>();
            for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
                try {
                    PartialPath devicePathInMemTable = new PartialPath(entry.getKey());
                    if (!devicePath.matchFullPath(devicePathInMemTable)) continue;
                    targetDeviceList.add(new Pair((Object)devicePathInMemTable, (Object)entry.getValue()));
                }
                catch (IllegalPathException illegalPathException) {}
            }
            for (Pair targetDevice : targetDeviceList) {
                this.deleteDataInChunkGroup((IWritableMemChunkGroup)targetDevice.right, originalPath, (PartialPath)targetDevice.left, startTimestamp, endTimestamp);
            }
        } else {
            IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceIDFactory.getDeviceID(devicePath));
            if (memChunkGroup == null) {
                return;
            }
            this.deleteDataInChunkGroup(memChunkGroup, originalPath, devicePath, startTimestamp, endTimestamp);
        }
    }

    private void deleteDataInChunkGroup(IWritableMemChunkGroup memChunkGroup, PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        this.totalPointsNum -= (long)memChunkGroup.delete(originalPath, devicePath, startTimestamp, endTimestamp);
        if (memChunkGroup.getMemChunkMap().isEmpty()) {
            this.memTableMap.remove(deviceIDFactory.getDeviceID(devicePath));
        }
    }

    @Override
    public void addTVListRamCost(long cost) {
        this.tvListRamCost += cost;
    }

    @Override
    public void releaseTVListRamCost(long cost) {
        this.tvListRamCost -= cost;
    }

    @Override
    public long getTVListsRamCost() {
        return this.tvListRamCost;
    }

    @Override
    public void addTextDataSize(long textDataSize) {
        this.memSize += textDataSize;
    }

    @Override
    public void releaseTextDataSize(long textDataSize) {
        this.memSize -= textDataSize;
    }

    @Override
    public void setShouldFlush() {
        this.shouldFlush = true;
    }

    @Override
    public boolean shouldFlush() {
        return this.shouldFlush;
    }

    @Override
    public void release() {
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            entry.getValue().release();
        }
    }

    @Override
    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    @Override
    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    @Override
    public long getMemTableId() {
        return this.memTableId;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getUpdateTime() {
        if (this.lastTotalPointsNum != this.totalPointsNum) {
            this.lastTotalPointsNum = this.totalPointsNum;
            this.updateTime = System.currentTimeMillis();
        }
        return this.updateTime;
    }

    @Override
    public FlushStatus getFlushStatus() {
        return this.flushStatus;
    }

    @Override
    public void setFlushStatus(FlushStatus flushStatus) {
        this.flushStatus = flushStatus;
    }

    @Override
    public int serializedSize() {
        if (this.isSignalMemTable()) {
            return 1;
        }
        int size = 57;
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            size += ReadWriteIOUtils.sizeToWrite((String)((PlainDeviceID)entry.getKey()).toStringID());
            ++size;
            size += entry.getValue().serializedSize();
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        if (this.isSignalMemTable()) {
            WALWriteUtils.write(this.isSignalMemTable(), buffer);
            return;
        }
        WALWriteUtils.write((byte)-1, buffer);
        buffer.putInt(this.seriesNumber);
        buffer.putLong(this.memSize);
        buffer.putLong(this.tvListRamCost);
        buffer.putLong(this.totalPointsNum);
        buffer.putLong(this.totalPointsNumThreshold);
        buffer.putLong(this.maxPlanIndex);
        buffer.putLong(this.minPlanIndex);
        buffer.putInt(this.memTableMap.size());
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            WALWriteUtils.write(((PlainDeviceID)entry.getKey()).toStringID(), buffer);
            IWritableMemChunkGroup memChunkGroup = entry.getValue();
            WALWriteUtils.write(memChunkGroup instanceof AlignedWritableMemChunkGroup, buffer);
            memChunkGroup.serializeToWAL(buffer);
        }
    }

    protected void deserialize(DataInputStream stream, boolean multiTvListMemChunk) throws IOException {
        this.seriesNumber = stream.readInt();
        this.memSize = stream.readLong();
        this.tvListRamCost = stream.readLong();
        this.totalPointsNum = stream.readLong();
        this.totalPointsNumThreshold = stream.readLong();
        this.maxPlanIndex = stream.readLong();
        this.minPlanIndex = stream.readLong();
        int memTableMapSize = stream.readInt();
        for (int i = 0; i < memTableMapSize; ++i) {
            IDeviceID deviceID = deviceIDFactory.getDeviceID(ReadWriteIOUtils.readString((InputStream)stream));
            boolean isAligned = ReadWriteIOUtils.readBool((InputStream)stream);
            IWritableMemChunkGroup memChunkGroup = multiTvListMemChunk ? (isAligned ? AlignedWritableMemChunkGroup.deserialize(stream) : WritableMemChunkGroup.deserialize(stream)) : (isAligned ? AlignedWritableMemChunkGroup.deserializeSingleTVListMemChunks(stream) : WritableMemChunkGroup.deserializeSingleTVListMemChunks(stream));
            this.memTableMap.put(deviceID, memChunkGroup);
        }
    }

    @Override
    public Map<IDeviceID, Long> getMaxTime() {
        HashMap<IDeviceID, Long> latestTimeForEachDevice = new HashMap<IDeviceID, Long>();
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            if (entry.getValue().count() <= 0L || entry.getValue().isEmpty()) continue;
            latestTimeForEachDevice.put(entry.getKey(), entry.getValue().getMaxTime());
        }
        return latestTimeForEachDevice;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getDataRegionId() {
        return this.dataRegionId;
    }

    @Override
    public void setDatabaseAndDataRegionId(String database, String dataRegionId) {
        this.database = database;
        this.dataRegionId = dataRegionId;
    }

    public static class Factory {
        private Factory() {
        }

        public static IMemTable create(DataInputStream stream) throws IOException {
            AbstractMemTable memTable;
            boolean isSignal;
            byte marker = ReadWriteIOUtils.readByte((InputStream)stream);
            boolean bl = isSignal = marker == 1;
            if (isSignal) {
                memTable = new NotifyFlushMemTable();
            } else {
                PrimitiveMemTable primitiveMemTable = new PrimitiveMemTable();
                primitiveMemTable.deserialize(stream, marker == -1);
                memTable = primitiveMemTable;
            }
            return memTable;
        }
    }
}

