/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.optimization;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.udf.builtin.BuiltinAggregationFunction;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.PredicateUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.RawDataAggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleDeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationSourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanSourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaUtils;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class AggregationPushDown
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Analysis analysis, MPPQueryContext context) {
        if (analysis.getStatement().getType() != StatementType.QUERY) {
            return plan;
        }
        QueryStatement queryStatement = analysis.getQueryStatement();
        if (!queryStatement.isAggregationQuery() || queryStatement.isGroupBy() && !queryStatement.isGroupByTime() || this.cannotUseStatistics(queryStatement, analysis)) {
            return plan;
        }
        RewriterContext rewriterContext = new RewriterContext(analysis, context, queryStatement.isAlignByDevice());
        PlanNode node = plan.accept(new Rewriter(), rewriterContext);
        return node;
    }

    private boolean cannotUseStatistics(QueryStatement queryStatement, Analysis analysis) {
        boolean isAlignByDevice = queryStatement.isAlignByDevice();
        if (isAlignByDevice) {
            if (analysis.allDevicesInOneTemplate()) {
                return this.cannotUseStatisticsForTemplate(analysis.getAggregationExpressions());
            }
            String device = analysis.getDeviceList().get(0).toString();
            return this.cannotUseStatistics(analysis.getDeviceToAggregationExpressions().get(device), analysis.getDeviceToSourceTransformExpressions().get(device));
        }
        return this.cannotUseStatistics(analysis.getAggregationExpressions(), analysis.getSourceTransformExpressions());
    }

    private boolean cannotUseStatistics(Set<Expression> aggregationExpressions, Set<Expression> sourceTransformExpressions) {
        for (Expression expression : aggregationExpressions) {
            if (expression instanceof FunctionExpression) {
                FunctionExpression functionExpression = (FunctionExpression)expression;
                if (functionExpression.isExternalAggregationFunctionExpression()) {
                    return true;
                }
                if ("count_time".equalsIgnoreCase(functionExpression.getFunctionName())) {
                    String alignedDeviceId = "";
                    for (Expression countTimeExpression : sourceTransformExpressions) {
                        TimeSeriesOperand ts = (TimeSeriesOperand)countTimeExpression;
                        if (!(ts.getPath() instanceof AlignedPath) && !((MeasurementPath)ts.getPath()).isUnderAlignedEntity()) {
                            return true;
                        }
                        if (StringUtils.isEmpty((CharSequence)alignedDeviceId)) {
                            alignedDeviceId = ts.getPath().getDevice();
                            continue;
                        }
                        if (alignedDeviceId.equalsIgnoreCase(ts.getPath().getDevice())) continue;
                        return true;
                    }
                    return false;
                }
                if (BuiltinAggregationFunction.canUseStatistics((String)functionExpression.getFunctionName())) continue;
                return true;
            }
            throw new IllegalArgumentException(String.format("Invalid Aggregation Expression: %s", expression.getExpressionString()));
        }
        return false;
    }

    private boolean cannotUseStatisticsForTemplate(Set<Expression> aggregationExpressions) {
        for (Expression expression : aggregationExpressions) {
            if (expression instanceof FunctionExpression) {
                FunctionExpression functionExpression = (FunctionExpression)expression;
                if (functionExpression.isExternalAggregationFunctionExpression()) {
                    return true;
                }
                if ("count_time".equalsIgnoreCase(functionExpression.getFunctionName())) {
                    return false;
                }
                if (BuiltinAggregationFunction.canUseStatistics((String)functionExpression.getFunctionName())) continue;
                return true;
            }
            throw new IllegalArgumentException(String.format("Invalid Aggregation Expression: %s", expression.getExpressionString()));
        }
        return false;
    }

    private static class RewriterContext {
        private final Analysis analysis;
        private final MPPQueryContext context;
        private final boolean isAlignByDevice;
        private String curDevice;
        private PartialPath curDevicePath;

        public RewriterContext(Analysis analysis, MPPQueryContext context, boolean isAlignByDevice) {
            this.analysis = analysis;
            Validate.notNull((Object)context, (String)"Query context cannot be null.", (Object[])new Object[0]);
            this.context = context;
            this.isAlignByDevice = isAlignByDevice;
        }

        public PlanNodeId genPlanNodeId() {
            return this.context.getQueryId().genPlanNodeId();
        }

        public boolean isAlignByDevice() {
            return this.isAlignByDevice;
        }

        public void setCurDevice(String curDevice) {
            this.curDevice = curDevice;
        }

        public void setCurDevicePath(PartialPath devicePath) {
            this.curDevicePath = devicePath;
        }

        public MPPQueryContext getContext() {
            return this.context;
        }

        public Set<Expression> getAggregationExpressions() {
            if (this.isAlignByDevice) {
                if (this.analysis.allDevicesInOneTemplate()) {
                    return this.analysis.getAggregationExpressions();
                }
                return this.analysis.getDeviceToAggregationExpressions().get(this.curDevice);
            }
            return this.analysis.getAggregationExpressions();
        }

        public void releaseMemoryForFrontEnd(long bytes) {
            this.context.releaseMemoryReservedForFrontEnd(bytes);
        }
    }

    private static class Rewriter
    extends PlanVisitor<PlanNode, RewriterContext> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitPlan(PlanNode node, RewriterContext context) {
            throw new IllegalArgumentException("Unexpected plan node: " + node);
        }

        @Override
        public PlanNode visitSingleChildProcess(SingleChildProcessNode node, RewriterContext context) {
            PlanNode rewrittenChild = node.getChild().accept(this, context);
            node.setChild(rewrittenChild);
            return node;
        }

        @Override
        public PlanNode visitMultiChildProcess(MultiChildProcessNode node, RewriterContext context) {
            ArrayList<PlanNode> rewrittenChildren = new ArrayList<PlanNode>();
            for (PlanNode child : node.getChildren()) {
                rewrittenChildren.add(child.accept(this, context));
            }
            node.setChildren(rewrittenChildren);
            return node;
        }

        @Override
        public PlanNode visitDeviceView(DeviceViewNode node, RewriterContext context) {
            ArrayList<PlanNode> rewrittenChildren = new ArrayList<PlanNode>();
            for (int i = 0; i < node.getDevices().size(); ++i) {
                context.setCurDevice(node.getDevices().get(i));
                if (context.analysis.allDevicesInOneTemplate()) {
                    context.setCurDevicePath(context.analysis.getDeviceList().get(i));
                }
                rewrittenChildren.add(node.getChildren().get(i).accept(this, context));
            }
            node.setChildren(rewrittenChildren);
            return node;
        }

        @Override
        public PlanNode visitSingleDeviceView(SingleDeviceViewNode node, RewriterContext context) {
            context.setCurDevice(node.getDevice());
            try {
                context.setCurDevicePath(new PartialPath(node.getDevice()));
            }
            catch (IllegalPathException e) {
                throw new IllegalStateException(String.format("Illegal device path: %s in AggregationPushDown rule.", node.getDevice()));
            }
            PlanNode rewrittenChild = node.getChild().accept(this, context);
            node.setChild(rewrittenChild);
            return node;
        }

        @Override
        public PlanNode visitGroupByLevel(GroupByLevelNode node, RewriterContext context) {
            Preconditions.checkState((node.getChildren().size() == 1 && (node.getChildren().get(0) instanceof RawDataAggregationNode || node.getChildren().get(0) instanceof SlidingWindowAggregationNode) ? 1 : 0) != 0);
            PlanNode child = node.getChildren().get(0);
            PlanNode rewrittenChild = child.accept(this, context);
            if (rewrittenChild instanceof FullOuterTimeJoinNode) {
                node.setChildren(rewrittenChild.getChildren());
            } else {
                node.setChildren(Collections.singletonList(rewrittenChild));
            }
            return node;
        }

        @Override
        public PlanNode visitGroupByTag(GroupByTagNode node, RewriterContext context) {
            Preconditions.checkState((node.getChildren().size() == 1 && (node.getChildren().get(0) instanceof RawDataAggregationNode || node.getChildren().get(0) instanceof SlidingWindowAggregationNode) ? 1 : 0) != 0);
            PlanNode child = node.getChildren().get(0);
            PlanNode rewrittenChild = child.accept(this, context);
            if (rewrittenChild instanceof FullOuterTimeJoinNode) {
                node.setChildren(rewrittenChild.getChildren());
            } else {
                node.setChildren(Collections.singletonList(rewrittenChild));
            }
            return node;
        }

        @Override
        public PlanNode visitRawDataAggregation(RawDataAggregationNode node, RewriterContext context) {
            if (context.analysis.allDevicesInOneTemplate()) {
                return this.visitRawDataAggregationTemplateCase(node, context);
            }
            PlanNode child = node.getChild();
            if (child instanceof ProjectNode) {
                node.setChild(((ProjectNode)child).getChild());
                return this.visitRawDataAggregation(node, context);
            }
            if (child instanceof FullOuterTimeJoinNode || child instanceof SeriesScanSourceNode) {
                Expression pushDownPredicate;
                boolean needCheckAscending;
                boolean isSingleSource = child instanceof SeriesScanSourceNode;
                boolean bl = needCheckAscending = node.getGroupByTimeParameter() == null;
                if (isSingleSource && ((SeriesScanSourceNode)child).getPushDownPredicate() != null && !PredicateUtils.predicateCanPushIntoScan(pushDownPredicate = ((SeriesScanSourceNode)child).getPushDownPredicate())) {
                    return node;
                }
                HashMap<PartialPath, List<AggregationDescriptor>> sourceToAscendingAggregationsMap = new HashMap<PartialPath, List<AggregationDescriptor>>();
                HashMap<PartialPath, List<AggregationDescriptor>> sourceToDescendingAggregationsMap = new HashMap<PartialPath, List<AggregationDescriptor>>();
                HashMap<PartialPath, List<AggregationDescriptor>> sourceToCountTimeAggregationsMap = new HashMap<PartialPath, List<AggregationDescriptor>>();
                AggregationStep curStep = node.getAggregationDescriptorList().get(0).getStep();
                Set<Expression> aggregationExpressions = context.getAggregationExpressions();
                for (Expression aggregationExpression : aggregationExpressions) {
                    this.createAggregationDescriptor((FunctionExpression)aggregationExpression, curStep, node.getScanOrder(), needCheckAscending, sourceToAscendingAggregationsMap, sourceToDescendingAggregationsMap, sourceToCountTimeAggregationsMap);
                }
                List<PlanNode> sourceNodeList = this.constructSourceNodeFromAggregationsDescriptors(sourceToAscendingAggregationsMap, sourceToDescendingAggregationsMap, sourceToCountTimeAggregationsMap, node.getScanOrder(), node.getGroupByTimeParameter(), context);
                if (isSingleSource && ((SeriesScanSourceNode)child).getPushDownPredicate() != null) {
                    Expression pushDownPredicate2 = ((SeriesScanSourceNode)child).getPushDownPredicate();
                    sourceNodeList.forEach(sourceNode -> {
                        SeriesAggregationSourceNode aggregationSourceNode = (SeriesAggregationSourceNode)sourceNode;
                        aggregationSourceNode.setPushDownPredicate(pushDownPredicate2);
                        if (aggregationSourceNode instanceof AlignedSeriesAggregationScanNode) {
                            ((AlignedSeriesAggregationScanNode)aggregationSourceNode).setAlignedPath(((AlignedSeriesScanNode)child).getAlignedPath());
                        }
                    });
                }
                PlanNode resultNode = this.convergeWithTimeJoin(sourceNodeList, node.getScanOrder(), context);
                resultNode = this.planProject(resultNode, node, context);
                context.releaseMemoryForFrontEnd(this.getRamBytesUsedOfOldScanNodes(child));
                return resultNode;
            }
            return node;
        }

        private long getRamBytesUsedOfOldScanNodes(PlanNode node) {
            if (node == null) {
                return 0L;
            }
            if (node instanceof SeriesScanSourceNode) {
                SeriesScanSourceNode scanNode = (SeriesScanSourceNode)node;
                return scanNode.ramBytesUsed();
            }
            if (node instanceof FullOuterTimeJoinNode) {
                return node.getChildren().stream().mapToLong(this::getRamBytesUsedOfOldScanNodes).sum();
            }
            return 0L;
        }

        private void createAggregationDescriptor(FunctionExpression sourceExpression, AggregationStep curStep, Ordering scanOrder, boolean needCheckAscending, Map<PartialPath, List<AggregationDescriptor>> ascendingAggregations, Map<PartialPath, List<AggregationDescriptor>> descendingAggregations, Map<PartialPath, List<AggregationDescriptor>> countTimeAggregations) {
            AggregationDescriptor aggregationDescriptor = new AggregationDescriptor(sourceExpression.getFunctionName(), curStep, sourceExpression.getExpressions(), sourceExpression.getFunctionAttributes());
            if ("count_time".equalsIgnoreCase(sourceExpression.getFunctionName())) {
                HashMap<String, Pair> map = new HashMap<String, Pair>();
                for (Expression expression : sourceExpression.getCountTimeExpressions()) {
                    TimeSeriesOperand ts = (TimeSeriesOperand)expression;
                    PartialPath path = ts.getPath();
                    Pair pair = map.computeIfAbsent(path.getDevice(), k -> new Pair(new ArrayList(), new ArrayList()));
                    ((List)pair.left).add(path.getMeasurement());
                    try {
                        ((List)pair.right).add(path.getMeasurementSchema());
                    }
                    catch (MetadataException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                for (Map.Entry entry : map.entrySet()) {
                    AlignedPath alignedPath;
                    String device = (String)entry.getKey();
                    Pair pair = (Pair)entry.getValue();
                    try {
                        alignedPath = new AlignedPath(device, (List)pair.left, (List)pair.right);
                    }
                    catch (IllegalPathException e) {
                        throw new RuntimeException(e);
                    }
                    countTimeAggregations.put((PartialPath)alignedPath, Collections.singletonList(aggregationDescriptor));
                }
                return;
            }
            PartialPath selectPath = ((TimeSeriesOperand)sourceExpression.getExpressions().get(0)).getPath();
            if (!needCheckAscending || SchemaUtils.isConsistentWithScanOrder(aggregationDescriptor.getAggregationType(), scanOrder)) {
                ascendingAggregations.computeIfAbsent(selectPath, key -> new ArrayList()).add(aggregationDescriptor);
            } else {
                descendingAggregations.computeIfAbsent(selectPath, key -> new ArrayList()).add(aggregationDescriptor);
            }
        }

        private List<PlanNode> constructSourceNodeFromAggregationsDescriptors(Map<PartialPath, List<AggregationDescriptor>> ascendingAggregations, Map<PartialPath, List<AggregationDescriptor>> descendingAggregations, Map<PartialPath, List<AggregationDescriptor>> countTimeAggregations, Ordering scanOrder, GroupByTimeParameter groupByTimeParameter, RewriterContext context) {
            boolean needCheckAscending;
            ArrayList<PlanNode> sourceNodeList = new ArrayList<PlanNode>();
            Map<PartialPath, List<AggregationDescriptor>> groupedAscendingAggregations = null;
            groupedAscendingAggregations = !countTimeAggregations.isEmpty() ? countTimeAggregations : MetaUtils.groupAlignedAggregations(ascendingAggregations);
            for (Map.Entry<PartialPath, List<AggregationDescriptor>> pathAggregationsEntry : groupedAscendingAggregations.entrySet()) {
                sourceNodeList.add(this.createAggregationScanNode(pathAggregationsEntry.getKey(), pathAggregationsEntry.getValue(), scanOrder, groupByTimeParameter, context, countTimeAggregations.isEmpty() ? (byte)0 : 2));
            }
            boolean bl = needCheckAscending = groupByTimeParameter == null;
            if (needCheckAscending) {
                Map<PartialPath, List<AggregationDescriptor>> groupedDescendingAggregations = MetaUtils.groupAlignedAggregations(descendingAggregations);
                for (Map.Entry<PartialPath, List<AggregationDescriptor>> pathAggregationsEntry : groupedDescendingAggregations.entrySet()) {
                    sourceNodeList.add(this.createAggregationScanNode(pathAggregationsEntry.getKey(), pathAggregationsEntry.getValue(), scanOrder.reverse(), null, context, (byte)1));
                }
            }
            return sourceNodeList;
        }

        public PlanNode visitRawDataAggregationTemplateCase(RawDataAggregationNode node, RewriterContext context) {
            PlanNode child = node.getChild();
            if (child instanceof ProjectNode) {
                node.setChild(((ProjectNode)child).getChild());
                return this.visitRawDataAggregation(node, context);
            }
            if (child instanceof FullOuterTimeJoinNode || child instanceof SeriesScanSourceNode) {
                Expression pushDownPredicate;
                boolean isSingleSource = child instanceof SeriesScanSourceNode;
                if (isSingleSource && ((SeriesScanSourceNode)child).getPushDownPredicate() != null && !PredicateUtils.predicateCanPushIntoScan(pushDownPredicate = ((SeriesScanSourceNode)child).getPushDownPredicate())) {
                    return node;
                }
                List<PlanNode> sourceNodeList = this.constructSourceNodeFromTemplateAggregationDescriptors(context.getContext().getTypeProvider().getTemplatedInfo().getAscendingDescriptorList(), context.getContext().getTypeProvider().getTemplatedInfo().getDescendingDescriptorList(), node.getScanOrder(), node.getGroupByTimeParameter(), context);
                if (isSingleSource && ((SeriesScanSourceNode)child).getPushDownPredicate() != null) {
                    Expression pushDownPredicate2 = ((SeriesScanSourceNode)child).getPushDownPredicate();
                    sourceNodeList.forEach(sourceNode -> {
                        SeriesAggregationSourceNode aggregationSourceNode = (SeriesAggregationSourceNode)sourceNode;
                        aggregationSourceNode.setPushDownPredicate(pushDownPredicate2);
                        if (aggregationSourceNode instanceof AlignedSeriesAggregationScanNode) {
                            ((AlignedSeriesAggregationScanNode)aggregationSourceNode).setAlignedPath(((AlignedSeriesScanNode)child).getAlignedPath());
                        }
                    });
                }
                PlanNode resultNode = this.convergeWithTimeJoin(sourceNodeList, node.getScanOrder(), context);
                resultNode = this.planProject(resultNode, node, context);
                context.releaseMemoryForFrontEnd(this.getRamBytesUsedOfOldScanNodes(child));
                return resultNode;
            }
            return node;
        }

        private List<PlanNode> constructSourceNodeFromTemplateAggregationDescriptors(List<AggregationDescriptor> ascendingAggregations, List<AggregationDescriptor> descendingAggregations, Ordering scanOrder, GroupByTimeParameter groupByTimeParameter, RewriterContext context) {
            boolean needCheckAscending;
            ArrayList<PlanNode> sourceNodeList = new ArrayList<PlanNode>();
            PartialPath devicePath = context.curDevicePath;
            List<String> measurementList = context.analysis.getMeasurementList();
            List<IMeasurementSchema> measurementSchemaList = context.analysis.getMeasurementSchemaList();
            boolean bl = needCheckAscending = groupByTimeParameter == null;
            if (!context.analysis.getDeviceTemplate().isDirectAligned()) {
                throw new IllegalStateException("Aggregation descriptors with non aligned template are not supported");
            }
            AlignedPath alignedPath = new AlignedPath(devicePath);
            alignedPath.setMeasurementList(measurementList);
            alignedPath.addSchemas(measurementSchemaList);
            if (!ascendingAggregations.isEmpty()) {
                sourceNodeList.add(this.createAggregationScanNode((PartialPath)alignedPath, ascendingAggregations, scanOrder, groupByTimeParameter, context, (byte)0));
            }
            if (needCheckAscending && !descendingAggregations.isEmpty()) {
                sourceNodeList.add(this.createAggregationScanNode((PartialPath)alignedPath, descendingAggregations, scanOrder, null, context, (byte)1));
            }
            return sourceNodeList;
        }

        private SeriesAggregationSourceNode createAggregationScanNode(PartialPath selectPath, List<AggregationDescriptor> aggregationDescriptorList, Ordering scanOrder, GroupByTimeParameter groupByTimeParameter, RewriterContext context, byte descriptorType) {
            if (selectPath instanceof MeasurementPath) {
                SeriesAggregationScanNode node = new SeriesAggregationScanNode(context.genPlanNodeId(), (MeasurementPath)selectPath, aggregationDescriptorList, scanOrder, groupByTimeParameter);
                context.getContext().reserveMemoryForFrontEnd(MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(node));
                return node;
            }
            if (selectPath instanceof AlignedPath) {
                AlignedSeriesAggregationScanNode aggScanNode = new AlignedSeriesAggregationScanNode(context.genPlanNodeId(), (AlignedPath)selectPath, aggregationDescriptorList, scanOrder, groupByTimeParameter);
                aggScanNode.setDescriptorType(descriptorType);
                context.getContext().reserveMemoryForFrontEnd(MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(aggScanNode));
                return aggScanNode;
            }
            throw new IllegalArgumentException("unexpected path type");
        }

        private PlanNode convergeWithTimeJoin(List<PlanNode> sourceNodes, Ordering mergeOrder, RewriterContext context) {
            PlanNode tmpNode = sourceNodes.size() == 1 ? sourceNodes.get(0) : new FullOuterTimeJoinNode(context.genPlanNodeId(), mergeOrder, sourceNodes);
            return tmpNode;
        }

        private PlanNode planProject(PlanNode resultNode, PlanNode rawNode, RewriterContext context) {
            List<String> outputColumnNames = rawNode.getOutputColumnNames();
            outputColumnNames.remove("__endTime");
            if (context.isAlignByDevice() && !outputColumnNames.equals(resultNode.getOutputColumnNames())) {
                return new ProjectNode(context.genPlanNodeId(), resultNode, outputColumnNames);
            }
            return resultNode;
        }
    }
}

