/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheLinkedList;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;

public class FIFOCacheEntryManager<SK, V>
implements ICacheEntryManager<SK, V> {
    private static final int SLOT_NUM = 128;
    private final CacheLinkedList[] CacheLinkedLists = new CacheLinkedList[128];
    private final AtomicInteger cachePutRoundRobinIndex = new AtomicInteger(0);
    private final AtomicInteger cacheEvictRoundRobinIndex = new AtomicInteger(0);

    @Override
    public void access(CacheEntry<SK, V> cacheEntry) {
    }

    @Override
    public void put(CacheEntry<SK, V> cacheEntry) {
        this.getNextList(this.cachePutRoundRobinIndex).add(cacheEntry);
    }

    @Override
    public CacheEntry<SK, V> evict() {
        int startIndex = this.getNextIndex(this.cacheEvictRoundRobinIndex);
        for (int i = 0; i < 128; ++i) {
            CacheEntry cacheEntry;
            CacheLinkedList CacheLinkedList2;
            if (startIndex == 128) {
                startIndex = 0;
            }
            if ((CacheLinkedList2 = this.CacheLinkedLists[startIndex]) != null && (cacheEntry = CacheLinkedList2.evict()) != null) {
                return cacheEntry;
            }
            ++startIndex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        CacheLinkedList[] cacheLinkedListArray = this.CacheLinkedLists;
        synchronized (this.CacheLinkedLists) {
            for (int i = 0; i < 128; ++i) {
                this.CacheLinkedLists[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CacheLinkedList getNextList(AtomicInteger roundRobinIndex) {
        int listIndex = this.getNextIndex(roundRobinIndex);
        CacheLinkedList CacheLinkedList2 = this.CacheLinkedLists[listIndex];
        if (CacheLinkedList2 != null) return CacheLinkedList2;
        CacheLinkedList[] cacheLinkedListArray = this.CacheLinkedLists;
        synchronized (this.CacheLinkedLists) {
            CacheLinkedList2 = this.CacheLinkedLists[listIndex];
            if (CacheLinkedList2 != null) return CacheLinkedList2;
            this.CacheLinkedLists[listIndex] = CacheLinkedList2 = new CacheLinkedList();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return CacheLinkedList2;
        }
    }

    private int getNextIndex(AtomicInteger roundRobinIndex) {
        return roundRobinIndex.getAndUpdate(currentValue -> ++currentValue >= 128 ? 0 : currentValue);
    }
}

