/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.function.Function;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.ICache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CachePolicy;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheSizeComputerImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.FIFOCacheEntryManager;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.LRUCacheEntryManager;

public class CacheBuilder<SK, V> {
    private CachePolicy policy;
    private long memoryCapacity;
    private Function<SK, Integer> secondKeySizeComputer;
    private Function<V, Integer> valueSizeComputer;

    public ICache<SK, V> build() {
        ICacheEntryManager cacheEntryManager = null;
        switch (this.policy) {
            case LRU: {
                cacheEntryManager = new LRUCacheEntryManager();
                break;
            }
            case FIFO: {
                cacheEntryManager = new FIFOCacheEntryManager();
            }
        }
        return new CacheImpl(cacheEntryManager, new CacheSizeComputerImpl<SK, V>(this.secondKeySizeComputer, this.valueSizeComputer), this.memoryCapacity);
    }

    public CacheBuilder<SK, V> cacheEvictionPolicy(CachePolicy policy) {
        this.policy = policy;
        return this;
    }

    public CacheBuilder<SK, V> memoryCapacity(long memoryCapacity) {
        this.memoryCapacity = memoryCapacity;
        return this;
    }

    public CacheBuilder<SK, V> secondKeySizeComputer(Function<SK, Integer> computer) {
        this.secondKeySizeComputer = computer;
        return this;
    }

    public CacheBuilder<SK, V> valueSizeComputer(Function<V, Integer> computer) {
        this.valueSizeComputer = computer;
        return this;
    }
}

