/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.row;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.row.PipeBinaryTransformer;
import org.apache.iotdb.db.pipe.event.common.row.PipeResetTabletRow;
import org.apache.iotdb.db.pipe.event.common.row.PipeRow;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletEventConverter;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.pipe.api.type.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class PipeRowCollector
extends PipeRawTabletEventConverter
implements RowCollector {
    private Tablet tablet = null;

    public PipeRowCollector(PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent) {
        super(pipeTaskMeta, sourceEvent);
    }

    public void collectRow(Row row) {
        if (!(row instanceof PipeRow)) {
            throw new PipeException("Row can not be customized");
        }
        PipeRow pipeRow = (PipeRow)row;
        MeasurementSchema[] measurementSchemaArray = pipeRow.getMeasurementSchemaList();
        if (row instanceof PipeResetTabletRow) {
            this.collectTabletInsertionEvent();
        }
        if (this.tablet == null) {
            String deviceId = pipeRow.getDeviceId();
            ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>(Arrays.asList(measurementSchemaArray));
            Pair<Integer, Integer> rowCountAndMemorySize = PipeMemoryWeightUtil.calculateTabletRowCountAndMemory(pipeRow);
            this.tablet = new Tablet(deviceId, measurementSchemaList, ((Integer)rowCountAndMemorySize.getLeft()).intValue());
            this.tablet.initBitMaps();
            this.isAligned = pipeRow.isAligned();
        }
        int rowIndex = this.tablet.rowSize;
        this.tablet.addTimestamp(rowIndex, row.getTime());
        for (int i = 0; i < row.size(); ++i) {
            Object value = row.getObject(i);
            if (value instanceof Binary) {
                this.tablet.addValue(measurementSchemaArray[i].getMeasurementId(), rowIndex, (Object)PipeBinaryTransformer.transformToBinary((Binary)value));
            } else {
                this.tablet.addValue(measurementSchemaArray[i].getMeasurementId(), rowIndex, value);
            }
            if (!row.isNull(i)) continue;
            this.tablet.bitMaps[i].mark(rowIndex);
        }
        ++this.tablet.rowSize;
        if (this.tablet.rowSize == this.tablet.getMaxRowNumber()) {
            this.collectTabletInsertionEvent();
        }
    }

    private void collectTabletInsertionEvent() {
        if (this.tablet != null) {
            this.tabletInsertionEventList.add(new PipeRawTabletInsertionEvent(this.tablet, this.isAligned, this.sourceEvent == null ? null : this.sourceEvent.getPipeName(), this.sourceEvent == null ? 0L : this.sourceEvent.getCreationTime(), this.pipeTaskMeta, this.sourceEvent, false));
        }
        this.tablet = null;
    }

    @Override
    public List<TabletInsertionEvent> convertToTabletInsertionEvents(boolean shouldReport) {
        this.collectTabletInsertionEvent();
        return super.convertToTabletInsertionEvents(shouldReport);
    }
}

