/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientManagerMetrics;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.ainode.AINodeClient;
import org.apache.iotdb.commons.client.ainode.AsyncAINodeServiceClient;
import org.apache.iotdb.commons.client.async.AsyncConfigNodeInternalServiceClient;
import org.apache.iotdb.commons.client.async.AsyncDataNodeExternalServiceClient;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.async.AsyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.client.property.ClientPoolProperty;
import org.apache.iotdb.commons.client.property.PipeConsensusClientProperty;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.client.sync.SyncConfigNodeIServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.commons.client.sync.SyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;

public class ClientPoolFactory {
    private static final CommonConfig conf = CommonDescriptor.getInstance().getConfig();

    private ClientPoolFactory() {
    }

    public static class AsyncPipeConsensusServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncPipeConsensusServiceClient> {
        private final PipeConsensusClientProperty config;

        public AsyncPipeConsensusServiceClientPoolFactory(PipeConsensusClientProperty config) {
            this.config = config;
        }

        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncPipeConsensusServiceClient> createClientPool(ClientManager<TEndPoint, AsyncPipeConsensusServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncPipeConsensusServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(0).setRpcThriftCompressionEnabled(this.config.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(this.config.getSelectorNumOfClientManager()).setPrintLogWhenEncounterException(this.config.isPrintLogWhenThriftClientEncounterException()).build(), ThreadName.ASYNC_DATANODE_PIPE_CONSENSUS_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setMaxClientNumForEachNode(this.config.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class SyncPipeConsensusServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncPipeConsensusServiceClient> {
        private final PipeConsensusClientProperty config;

        public SyncPipeConsensusServiceClientPoolFactory(PipeConsensusClientProperty config) {
            this.config = config;
        }

        @Override
        public GenericKeyedObjectPool<TEndPoint, SyncPipeConsensusServiceClient> createClientPool(ClientManager<TEndPoint, SyncPipeConsensusServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncPipeConsensusServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(0).setRpcThriftCompressionEnabled(this.config.isRpcThriftCompressionEnabled()).setPrintLogWhenEncounterException(this.config.isPrintLogWhenThriftClientEncounterException()).build()), new ClientPoolProperty.Builder().setMaxClientNumForEachNode(this.config.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AINodeClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AINodeClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AINodeClient> createClientPool(ClientManager<TEndPoint, AINodeClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AINodeClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getDnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).build()), new ClientPoolProperty.Builder().setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncAINodeHeartbeatServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncAINodeServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncAINodeServiceClient> createClientPool(ClientManager<TEndPoint, AsyncAINodeServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncAINodeServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getCnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).setPrintLogWhenEncounterException(false).build(), ThreadName.ASYNC_DATANODE_HEARTBEAT_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncPipeTsFileDataTransferServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncPipeDataTransferServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncPipeDataTransferServiceClient> createClientPool(ClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncPipeDataTransferServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getPipeConnectorTransferTimeoutMs()).setRpcThriftCompressionEnabled(conf.isPipeConnectorRPCThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getPipeAsyncConnectorSelectorNumber()).setPrintLogWhenEncounterException(conf.isPrintLogWhenEncounterException()).build(), ThreadName.PIPE_ASYNC_CONNECTOR_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setMaxClientNumForEachNode(conf.getPipeAsyncConnectorMaxTsFileClientNumber()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncPipeDataTransferServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncPipeDataTransferServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncPipeDataTransferServiceClient> createClientPool(ClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncPipeDataTransferServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getPipeConnectorTransferTimeoutMs()).setRpcThriftCompressionEnabled(conf.isPipeConnectorRPCThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getPipeAsyncConnectorSelectorNumber()).build(), ThreadName.PIPE_ASYNC_CONNECTOR_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setMaxClientNumForEachNode(conf.getPipeAsyncConnectorMaxClientNumber()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncDataNodeMPPDataExchangeServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataNodeMPPDataExchangeServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getDnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_DATANODE_MPP_DATA_EXCHANGE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class SyncDataNodeMPPDataExchangeServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> createClientPool(ClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncDataNodeMPPDataExchangeServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getDnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).build()), new ClientPoolProperty.Builder().build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncDataNodeHeartbeatServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeInternalServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataNodeInternalServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getCnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).setPrintLogWhenEncounterException(false).build(), ThreadName.ASYNC_DATANODE_HEARTBEAT_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncConfigNodeHeartbeatServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncConfigNodeInternalServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncConfigNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, AsyncConfigNodeInternalServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncConfigNodeInternalServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getCnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).setPrintLogWhenEncounterException(false).build(), ThreadName.ASYNC_CONFIGNODE_HEARTBEAT_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncDataNodeExternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeExternalServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncDataNodeExternalServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeExternalServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataNodeExternalServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getDnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_DATANODE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncDataNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeInternalServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataNodeInternalServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getDnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_DATANODE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class SyncDataNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncDataNodeInternalServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, SyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, SyncDataNodeInternalServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncDataNodeInternalServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getDnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).build()), new ClientPoolProperty.Builder().build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AsyncConfigNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncConfigNodeInternalServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, AsyncConfigNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, AsyncConfigNodeInternalServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncConfigNodeInternalServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getCnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_CONFIGNODE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class SyncConfigNodeIServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncConfigNodeIServiceClient> {
        @Override
        public GenericKeyedObjectPool<TEndPoint, SyncConfigNodeIServiceClient> createClientPool(ClientManager<TEndPoint, SyncConfigNodeIServiceClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncConfigNodeIServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getCnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).build()), new ClientPoolProperty.Builder().build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }
}

