/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;

public class WindowsOSUtils {
    private static final String ILLEGAL_WINDOWS_CHARS = "\\/:*?\"<>|";
    private static final Set<String> ILLEGAL_WINDOWS_NAMES = new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1-COM9, LPT1-LPT9"));
    public static final String OS_SEGMENT_ERROR;

    public static boolean isLegalPathSegment4Windows(String pathSegment) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return true;
        }
        for (char illegalChar : ILLEGAL_WINDOWS_CHARS.toCharArray()) {
            if (pathSegment.indexOf(illegalChar) == -1) continue;
            return false;
        }
        if (pathSegment.endsWith(".") || pathSegment.endsWith(" ")) {
            return false;
        }
        Object object = ILLEGAL_WINDOWS_NAMES.iterator();
        while (object.hasNext()) {
            String illegalName = (String)object.next();
            if (!pathSegment.equalsIgnoreCase(illegalName)) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < 10; ++i) {
            ILLEGAL_WINDOWS_NAMES.add("COM" + i);
            ILLEGAL_WINDOWS_NAMES.add("LPT" + i);
        }
        OS_SEGMENT_ERROR = String.format("In Windows System, the path shall not contains %s, equals one of %s, or ends with '.' or ' '.", ILLEGAL_WINDOWS_CHARS, ILLEGAL_WINDOWS_NAMES);
    }
}

