/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePatternOperations;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PrefixPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.UnionIoTDBPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.UnionPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.WithExclusionIoTDBPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.WithExclusionPipePattern;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipePattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePattern.class);

    public abstract String getPattern();

    public abstract boolean isRoot();

    public abstract boolean isSingle();

    public abstract boolean isLegal();

    public abstract boolean coversDb(String var1);

    public abstract boolean coversDevice(String var1);

    public abstract boolean mayOverlapWithDb(String var1);

    public abstract boolean mayOverlapWithDevice(String var1);

    public abstract boolean matchesMeasurement(String var1, String var2);

    public abstract List<PartialPath> getBaseInclusionPaths();

    public static <T> List<T> applyIndexesOnList(int[] filteredIndexes, List<T> originalList) {
        return Objects.nonNull(originalList) ? Arrays.stream(filteredIndexes).mapToObj(originalList::get).collect(Collectors.toList()) : null;
    }

    public static PipePattern parsePipePatternFromSourceParameters(PipeParameters sourceParameters) {
        PipePattern pipePattern = PipePattern.parsePipePatternFromSourceParametersInternal(sourceParameters);
        if (!pipePattern.isSingle()) {
            String msg = String.format("Pipe: The provided pattern should be single now. Inclusion: %s, Exclusion: %s", sourceParameters.getStringByKeys(new String[]{"extractor.pattern", "source.pattern"}), sourceParameters.getStringByKeys(new String[]{"extractor.pattern.exclusion", "source.pattern.exclusion"}));
            LOGGER.warn(msg);
            throw new PipeException(msg);
        }
        return pipePattern;
    }

    public static PipePattern parsePipePatternFromSourceParametersInternal(PipeParameters sourceParameters) {
        List<PipePattern> inclusionPatterns = PipePattern.parsePatternList(sourceParameters, "extractor.path", "source.path", "extractor.pattern", "source.pattern");
        if (inclusionPatterns.isEmpty()) {
            inclusionPatterns = new ArrayList<IoTDBPipePattern>(Collections.singletonList(new IoTDBPipePattern(null)));
        }
        List<PipePattern> exclusionPatterns = PipePattern.parsePatternList(sourceParameters, "extractor.path.exclusion", "source.path.exclusion", "extractor.pattern.exclusion", "source.pattern.exclusion");
        inclusionPatterns = PipePattern.optimizePatterns(inclusionPatterns);
        if ((inclusionPatterns = PipePattern.pruneInclusionPatterns(inclusionPatterns, exclusionPatterns = PipePattern.optimizePatterns(exclusionPatterns))).isEmpty()) {
            String msg = String.format("Pipe: The provided exclusion pattern fully covers the inclusion pattern. This pipe pattern will match nothing. Inclusion: %s, Exclusion: %s", sourceParameters.getStringByKeys(new String[]{"extractor.pattern", "source.pattern"}), sourceParameters.getStringByKeys(new String[]{"extractor.pattern.exclusion", "source.pattern.exclusion"}));
            LOGGER.warn(msg);
            throw new PipeException(msg);
        }
        exclusionPatterns = PipePattern.pruneIrrelevantExclusions(inclusionPatterns, exclusionPatterns);
        PipePattern finalInclusionPattern = PipePattern.buildUnionPattern(inclusionPatterns);
        if (exclusionPatterns.isEmpty()) {
            return finalInclusionPattern;
        }
        PipePattern finalExclusionPattern = PipePattern.buildUnionPattern(exclusionPatterns);
        if (finalInclusionPattern instanceof IoTDBPipePatternOperations && finalExclusionPattern instanceof IoTDBPipePatternOperations) {
            return new WithExclusionIoTDBPipePattern((IoTDBPipePatternOperations)finalInclusionPattern, (IoTDBPipePatternOperations)finalExclusionPattern);
        }
        return new WithExclusionPipePattern(finalInclusionPattern, finalExclusionPattern);
    }

    public static PipePattern parsePatternFromString(String patternString, Function<String, PipePattern> basePatternSupplier) {
        String trimmedPattern;
        String string = trimmedPattern = patternString == null ? "" : patternString.trim();
        if (trimmedPattern.isEmpty()) {
            return basePatternSupplier.apply("");
        }
        if (trimmedPattern.startsWith("INCLUSION(") && trimmedPattern.endsWith(")")) {
            int inclusionEndIndex = PipePattern.findMatchingParenthesis(trimmedPattern, "INCLUSION(".length() - 1);
            if (inclusionEndIndex == -1) {
                return PipePattern.buildUnionPattern(PipePattern.parseMultiplePatterns(trimmedPattern, basePatternSupplier));
            }
            String remaining = trimmedPattern.substring(inclusionEndIndex + 1).trim();
            if (!remaining.startsWith(", EXCLUSION(")) {
                return PipePattern.buildUnionPattern(PipePattern.parseMultiplePatterns(trimmedPattern, basePatternSupplier));
            }
            try {
                String inclusionSubstring = trimmedPattern.substring("INCLUSION(".length(), inclusionEndIndex);
                String exclusionSubstring = trimmedPattern.substring(inclusionEndIndex + ", EXCLUSION(".length() + 1, trimmedPattern.length() - 1);
                PipePattern inclusionPattern = PipePattern.parsePatternFromString(inclusionSubstring, basePatternSupplier);
                PipePattern exclusionPattern = PipePattern.parsePatternFromString(exclusionSubstring, basePatternSupplier);
                if (inclusionPattern instanceof IoTDBPipePatternOperations && exclusionPattern instanceof IoTDBPipePatternOperations) {
                    return new WithExclusionIoTDBPipePattern((IoTDBPipePatternOperations)inclusionPattern, (IoTDBPipePatternOperations)exclusionPattern);
                }
                return new WithExclusionPipePattern(inclusionPattern, exclusionPattern);
            }
            catch (Exception e) {
                return PipePattern.buildUnionPattern(PipePattern.parseMultiplePatterns(trimmedPattern, basePatternSupplier));
            }
        }
        return PipePattern.buildUnionPattern(PipePattern.parseMultiplePatterns(trimmedPattern, basePatternSupplier));
    }

    private static List<PipePattern> parsePatternList(PipeParameters sourceParameters, String extractorPathKey, String sourcePathKey, String extractorPatternKey, String sourcePatternKey) {
        String path = sourceParameters.getStringByKeys(new String[]{extractorPathKey, sourcePathKey});
        String pattern = sourceParameters.getStringByKeys(new String[]{extractorPatternKey, sourcePatternKey});
        ArrayList<PipePattern> result = new ArrayList<PipePattern>();
        if (path != null) {
            result.addAll(PipePattern.parseMultiplePatterns(path, IoTDBPipePattern::new));
        }
        if (pattern != null) {
            result.addAll(PipePattern.parsePatternsFromPatternParameter(pattern, sourceParameters));
        }
        return result;
    }

    private static List<PipePattern> optimizePatterns(List<PipePattern> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return new ArrayList<PipePattern>();
        }
        if (patterns.size() == 1) {
            return patterns;
        }
        ArrayList<PipePattern> sortedPatterns = new ArrayList<PipePattern>(patterns);
        sortedPatterns.sort((o1, o2) -> {
            PartialPath p1 = o1.getBaseInclusionPaths().get(0);
            PartialPath p2 = o2.getBaseInclusionPaths().get(0);
            int lenCompare = Integer.compare(p1.getNodeLength(), p2.getNodeLength());
            if (lenCompare != 0) {
                return lenCompare;
            }
            boolean w1 = p1.hasWildcard();
            boolean w2 = p2.hasWildcard();
            if (w1 && !w2) {
                return -1;
            }
            if (!w1 && w2) {
                return 1;
            }
            return p1.compareTo(p2);
        });
        PatternTrie trie = new PatternTrie();
        ArrayList<PipePattern> optimized = new ArrayList<PipePattern>();
        for (PipePattern pattern : sortedPatterns) {
            boolean isCovered = true;
            for (PartialPath path : pattern.getBaseInclusionPaths()) {
                if (trie.isCovered(path)) continue;
                isCovered = false;
                break;
            }
            if (isCovered) continue;
            optimized.add(pattern);
            for (PartialPath path : pattern.getBaseInclusionPaths()) {
                trie.add(path);
            }
        }
        return optimized;
    }

    private static List<PipePattern> pruneInclusionPatterns(List<PipePattern> inclusion, List<PipePattern> exclusion) {
        if (inclusion == null || inclusion.isEmpty()) {
            return new ArrayList<PipePattern>();
        }
        if (exclusion == null || exclusion.isEmpty()) {
            return inclusion;
        }
        PatternTrie exclusionTrie = new PatternTrie();
        for (PipePattern exc : exclusion) {
            for (PartialPath path : exc.getBaseInclusionPaths()) {
                exclusionTrie.add(path);
            }
        }
        ArrayList<PipePattern> prunedInclusion = new ArrayList<PipePattern>();
        for (PipePattern inc : inclusion) {
            boolean isFullyExcluded = true;
            for (PartialPath path : inc.getBaseInclusionPaths()) {
                if (exclusionTrie.isCovered(path)) continue;
                isFullyExcluded = false;
                break;
            }
            if (isFullyExcluded) continue;
            prunedInclusion.add(inc);
        }
        return prunedInclusion;
    }

    private static List<PipePattern> pruneIrrelevantExclusions(List<PipePattern> inclusion, List<PipePattern> exclusion) {
        if (exclusion == null || exclusion.isEmpty()) {
            return new ArrayList<PipePattern>();
        }
        if (inclusion == null || inclusion.isEmpty()) {
            return new ArrayList<PipePattern>();
        }
        PatternTrie inclusionTrie = new PatternTrie();
        for (PipePattern inc : inclusion) {
            for (PartialPath path : inc.getBaseInclusionPaths()) {
                inclusionTrie.add(path);
            }
        }
        ArrayList<PipePattern> relevantExclusion = new ArrayList<PipePattern>();
        for (PipePattern exc : exclusion) {
            boolean overlapsWithAnyInclusion = false;
            for (PartialPath path : exc.getBaseInclusionPaths()) {
                if (!inclusionTrie.overlaps(path)) continue;
                overlapsWithAnyInclusion = true;
                break;
            }
            if (!overlapsWithAnyInclusion) continue;
            relevantExclusion.add(exc);
        }
        return relevantExclusion;
    }

    private static List<PipePattern> parsePatternsFromPatternParameter(String pattern, PipeParameters sourceParameters) {
        String patternFormat = sourceParameters.getStringByKeys(new String[]{"extractor.pattern.format", "source.pattern.format"});
        if (patternFormat == null) {
            return PipePattern.parseMultiplePatterns(pattern, PrefixPipePattern::new);
        }
        switch (patternFormat.toLowerCase()) {
            case "iotdb": {
                return PipePattern.parseMultiplePatterns(pattern, IoTDBPipePattern::new);
            }
            case "prefix": {
                return PipePattern.parseMultiplePatterns(pattern, PrefixPipePattern::new);
            }
        }
        LOGGER.info("Unknown pattern format: {}, use prefix matching format by default.", (Object)patternFormat);
        return PipePattern.parseMultiplePatterns(pattern, PrefixPipePattern::new);
    }

    private static List<PipePattern> parseMultiplePatterns(String pattern, Function<String, PipePattern> patternSupplier) {
        if (pattern.isEmpty()) {
            return Collections.singletonList(patternSupplier.apply(pattern));
        }
        ArrayList<PipePattern> patterns = new ArrayList<PipePattern>();
        StringBuilder currentPattern = new StringBuilder();
        boolean inBackticks = false;
        for (char c : pattern.toCharArray()) {
            if (c == '`') {
                inBackticks = !inBackticks;
                currentPattern.append(c);
                continue;
            }
            if (c == ',' && !inBackticks) {
                String singlePattern = currentPattern.toString().trim();
                if (!singlePattern.isEmpty()) {
                    patterns.add(patternSupplier.apply(singlePattern));
                }
                currentPattern.setLength(0);
                continue;
            }
            currentPattern.append(c);
        }
        String lastPattern = currentPattern.toString().trim();
        if (!lastPattern.isEmpty()) {
            patterns.add(patternSupplier.apply(lastPattern));
        }
        return patterns;
    }

    private static PipePattern buildUnionPattern(List<PipePattern> patterns) {
        if (patterns.size() == 1) {
            return patterns.get(0);
        }
        boolean allIoTDB = true;
        for (PipePattern p : patterns) {
            if (p instanceof IoTDBPipePattern) continue;
            allIoTDB = false;
            break;
        }
        if (allIoTDB) {
            ArrayList<IoTDBPipePattern> iotdbPatterns = new ArrayList<IoTDBPipePattern>(patterns.size());
            for (PipePattern p : patterns) {
                iotdbPatterns.add((IoTDBPipePattern)p);
            }
            return new UnionIoTDBPipePattern(iotdbPatterns);
        }
        return new UnionPipePattern(patterns);
    }

    private static int findMatchingParenthesis(String text, int openParenIndex) {
        int depth = 1;
        boolean inBackticks = false;
        for (int i = openParenIndex + 1; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '`') {
                inBackticks = !inBackticks;
                continue;
            }
            if (c == '(' && !inBackticks) {
                ++depth;
                continue;
            }
            if (c != ')' || inBackticks || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    public static int[] checkAndLogPatternCoverage(PipePattern inclusion, PipePattern exclusion) throws PipeException {
        List<PartialPath> inclusionPaths;
        if (inclusion == null || exclusion == null) {
            return new int[]{0, 0};
        }
        int coveredCount = 0;
        try {
            inclusionPaths = inclusion.getBaseInclusionPaths();
            List<PartialPath> exclusionPaths = exclusion.getBaseInclusionPaths();
            if (inclusionPaths.isEmpty() || exclusionPaths.isEmpty()) {
                return new int[]{0, inclusionPaths.size()};
            }
            for (PartialPath incPath : inclusionPaths) {
                boolean isCovered = exclusionPaths.stream().anyMatch(excPath -> excPath.include(incPath));
                if (!isCovered) continue;
                ++coveredCount;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Pipe: Failed to perform pattern coverage check for inclusion [{}] and exclusion [{}].", new Object[]{inclusion.getPattern(), exclusion.getPattern(), e});
            return new int[]{-1, -1};
        }
        if (coveredCount == inclusionPaths.size() && !inclusionPaths.isEmpty()) {
            String msg = String.format("Pipe: The provided exclusion pattern fully covers the inclusion pattern. This pipe pattern will match nothing. Inclusion: [%s], Exclusion: [%s]", inclusion.getPattern(), exclusion.getPattern());
            LOGGER.warn(msg);
            throw new PipeException(msg);
        }
        if (coveredCount > 0) {
            LOGGER.warn("Pipe: The provided exclusion pattern covers {} out of {} inclusion paths. These paths will be excluded. Inclusion: [{}], Exclusion: [{}]", new Object[]{coveredCount, inclusionPaths.size(), inclusion.getPattern(), exclusion.getPattern()});
        }
        return new int[]{coveredCount, inclusionPaths.size()};
    }

    private static class PatternTrie {
        private final TrieNode root = new TrieNode();

        private PatternTrie() {
        }

        public void add(PartialPath path) {
            String[] nodes;
            TrieNode node = this.root;
            for (String segment : nodes = path.getNodes()) {
                if (node.isMultiLevelWildcard) {
                    return;
                }
                if (segment.equals("**")) {
                    node.isMultiLevelWildcard = true;
                    node.children = Collections.emptyMap();
                    node.wildcardNode = null;
                    node.isLeaf = true;
                    return;
                }
                if (segment.equals("*")) {
                    if (node.wildcardNode == null) {
                        node.wildcardNode = new TrieNode();
                    }
                    node = node.wildcardNode;
                    continue;
                }
                node = node.children.computeIfAbsent(segment, k -> new TrieNode());
            }
            node.isLeaf = true;
        }

        public boolean isCovered(PartialPath path) {
            return this.checkCoverage(this.root, path.getNodes(), 0);
        }

        private boolean checkCoverage(TrieNode node, String[] pathNodes, int index) {
            if (node.isMultiLevelWildcard) {
                return true;
            }
            if (index >= pathNodes.length) {
                return node.isLeaf;
            }
            String currentSegment = pathNodes[index];
            TrieNode child = node.children.get(currentSegment);
            if (child != null && this.checkCoverage(child, pathNodes, index + 1)) {
                return true;
            }
            if (node.wildcardNode != null) {
                return this.checkCoverage(node.wildcardNode, pathNodes, index + 1);
            }
            return false;
        }

        public boolean overlaps(PartialPath path) {
            return this.checkOverlap(this.root, path.getNodes(), 0);
        }

        private boolean checkOverlap(TrieNode node, String[] pathNodes, int index) {
            if (node.isMultiLevelWildcard) {
                return true;
            }
            if (index < pathNodes.length && pathNodes[index].equals("**")) {
                return true;
            }
            if (index >= pathNodes.length) {
                return node.isLeaf;
            }
            String pNode = pathNodes[index];
            if (pNode.equals("*")) {
                for (TrieNode child : node.children.values()) {
                    if (!this.checkOverlap(child, pathNodes, index + 1)) continue;
                    return true;
                }
                if (node.wildcardNode != null) {
                    return this.checkOverlap(node.wildcardNode, pathNodes, index + 1);
                }
                return false;
            }
            TrieNode exactChild = node.children.get(pNode);
            if (exactChild != null && this.checkOverlap(exactChild, pathNodes, index + 1)) {
                return true;
            }
            return node.wildcardNode != null && this.checkOverlap(node.wildcardNode, pathNodes, index + 1);
        }

        private static class TrieNode {
            Map<String, TrieNode> children = new HashMap<String, TrieNode>();
            TrieNode wildcardNode = null;
            boolean isLeaf = false;
            boolean isMultiLevelWildcard = false;

            private TrieNode() {
            }
        }
    }
}

