/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa.match;

import java.util.Iterator;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;
import org.apache.iotdb.commons.path.fa.IPatternFA;
import org.apache.iotdb.commons.path.fa.match.IStateMatchInfo;

public class StateSingleMatchInfo
implements IStateMatchInfo {
    private final IPatternFA patternFA;
    private final IFAState matchedState;
    private final IFAState scopeState;

    public StateSingleMatchInfo(IPatternFA patternFA, IFAState matchedState, IFAState scopeState) {
        this.patternFA = patternFA;
        this.matchedState = matchedState;
        this.scopeState = scopeState;
    }

    @Override
    public boolean hasFinalState() {
        return this.matchedState.isFinal();
    }

    @Override
    public boolean hasOnlyPreciseMatchTransition() {
        return this.patternFA.getFuzzyMatchTransitionSize(this.matchedState) == 0;
    }

    @Override
    public boolean hasNoPreciseMatchTransition() {
        return this.patternFA.getPreciseMatchTransition(this.matchedState).isEmpty();
    }

    @Override
    public boolean isSingleFuzzyMatchTransition() {
        return this.patternFA.getFuzzyMatchTransitionSize(this.matchedState) == 1;
    }

    @Override
    public IFAState getOneMatchedState() {
        return this.matchedState;
    }

    @Override
    public void addMatchedState(IFAState state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFAState getMatchedState(int stateOrdinal) {
        if (stateOrdinal == 0) {
            return this.matchedState;
        }
        throw new IllegalStateException();
    }

    @Override
    public int getMatchedStateSize() {
        return 1;
    }

    @Override
    public int getSourceStateOrdinal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSourceStateOrdinal(int sourceStateOrdinal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IFATransition> getSourceTransitionIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSourceTransitionIterator(Iterator<IFATransition> sourceTransitionIterator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFAState getScopeMatchedState() {
        return this.scopeState;
    }
}

