/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.ICache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.ICacheStats;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheEntryGroupImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheStats;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheSizeComputer;
import org.apache.tsfile.utils.RamUsageEstimator;

class CacheImpl<SK, V>
implements ICache<SK, V> {
    private ICacheEntryGroup<SK, V> cacheEntryGroup;
    private final ICacheEntryManager<SK, V> cacheEntryManager;
    private final ICacheSizeComputer<SK, V> sizeComputer;
    private final CacheStats cacheStats;

    CacheImpl(ICacheEntryManager<SK, V> cacheEntryManager, ICacheSizeComputer<SK, V> sizeComputer, long memoryCapacity) {
        this.cacheEntryManager = cacheEntryManager;
        this.sizeComputer = sizeComputer;
        this.cacheStats = new CacheStats(memoryCapacity, this::getMemory, this::getEntriesCount);
        this.cacheEntryGroup = new CacheEntryGroupImpl<SK, V>(sizeComputer);
    }

    @Override
    public V get(SK secondKey) {
        CacheEntry<SK, V> cacheEntry = this.cacheEntryGroup.getCacheEntry(secondKey);
        if (cacheEntry == null) {
            this.cacheStats.recordMiss(1);
            return null;
        }
        this.cacheEntryManager.access(cacheEntry);
        this.cacheStats.recordHit(1);
        return cacheEntry.getValue();
    }

    @Override
    public <R> boolean batchApply(Map<SK, R> inputMap, BiFunction<V, R, Boolean> mappingFunction) {
        for (Map.Entry<SK, R> skrEntry : inputMap.entrySet()) {
            CacheEntry<SK, V> cacheEntry = this.cacheEntryGroup.getCacheEntry(skrEntry.getKey());
            if (cacheEntry == null) {
                return false;
            }
            if (mappingFunction.apply(cacheEntry.getValue(), skrEntry.getValue()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(@Nonnull SK secondKey, V value, ToIntFunction<V> updater, boolean createIfNotExists) {
        ICacheEntryGroup<SK, V> finalCacheEntryGroup = this.cacheEntryGroup;
        this.cacheEntryGroup.computeCacheEntry(secondKey, memory -> (sk, cacheEntry) -> {
            if (Objects.isNull(cacheEntry)) {
                if (!createIfNotExists) {
                    return null;
                }
                cacheEntry = this.cacheEntryManager.createCacheEntry(secondKey, value, finalCacheEntryGroup);
                this.cacheEntryManager.put((CacheEntry<Object, Object>)cacheEntry);
                memory.getAndAdd((long)(this.sizeComputer.computeSecondKeySize(sk) + this.sizeComputer.computeValueSize(cacheEntry.getValue())) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
            }
            memory.getAndAdd(updater.applyAsInt(cacheEntry.getValue()));
            return cacheEntry;
        });
        this.mayEvict();
    }

    @Override
    public void update(Predicate<SK> secondKeyChecker, ToIntFunction<V> updater) {
        this.clearSecondEntry(this.cacheEntryGroup, secondKeyChecker, updater);
        this.mayEvict();
    }

    public void clearSecondEntry(ICacheEntryGroup<SK, V> entryGroup, Predicate<SK> secondKeyChecker, ToIntFunction<V> updater) {
        if (Objects.nonNull(entryGroup)) {
            entryGroup.getAllCacheEntries().forEachRemaining(entry -> {
                if (!secondKeyChecker.test(entry.getKey())) {
                    return;
                }
                entryGroup.computeCacheEntryIfPresent(entry.getKey(), memory -> (secondKey, cacheEntry) -> {
                    memory.getAndAdd(updater.applyAsInt(cacheEntry.getValue()));
                    return cacheEntry;
                });
            });
        }
    }

    private void mayEvict() {
        long exceedMemory;
        while ((exceedMemory = this.cacheStats.getExceedMemory()) > 0L) {
            while ((exceedMemory -= this.evictOneCacheEntry()) > 0L) {
            }
        }
    }

    private long evictOneCacheEntry() {
        CacheEntry<SK, V> evictCacheEntry = this.cacheEntryManager.evict();
        if (evictCacheEntry == null) {
            return 0L;
        }
        ICacheEntryGroup belongedGroup = evictCacheEntry.getBelongedGroup();
        evictCacheEntry.setBelongedGroup(null);
        return belongedGroup.removeCacheEntry(evictCacheEntry.getSecondKey());
    }

    @Override
    public void invalidateAll() {
        this.cacheEntryManager.cleanUp();
        this.cacheEntryGroup = new CacheEntryGroupImpl<SK, V>(this.sizeComputer);
    }

    @Override
    public ICacheStats stats() {
        return this.cacheStats;
    }

    @Override
    public void invalidate(SK secondKey) {
        CacheEntry<SK, V> entry = this.cacheEntryGroup.getCacheEntry(secondKey);
        if (Objects.nonNull(entry) && this.cacheEntryManager.invalidate(entry)) {
            this.cacheEntryGroup.removeCacheEntry(entry.getSecondKey());
        }
    }

    @Override
    public void invalidate(Predicate<SK> secondKeyChecker) {
        Iterator<Map.Entry<SK, CacheEntry<SK, V>>> it = this.cacheEntryGroup.getAllCacheEntries();
        while (it.hasNext()) {
            Map.Entry<SK, CacheEntry<SK, V>> entry = it.next();
            if (!secondKeyChecker.test(entry.getKey()) || !this.cacheEntryManager.invalidate(entry.getValue())) continue;
            this.cacheEntryGroup.removeCacheEntry(entry.getKey());
        }
    }

    private long getMemory() {
        return this.cacheEntryGroup.getMemory();
    }

    private long getEntriesCount() {
        return this.cacheEntryGroup.getEntriesCount();
    }
}

