/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePatternOperations;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;

public class UnionIoTDBPipePattern
extends IoTDBPipePatternOperations {
    private final List<IoTDBPipePattern> patterns;

    public UnionIoTDBPipePattern(List<IoTDBPipePattern> patterns) {
        this.patterns = patterns;
    }

    public UnionIoTDBPipePattern(IoTDBPipePattern pattern) {
        this.patterns = Collections.singletonList(pattern);
    }

    @Override
    public String getPattern() {
        return this.patterns.stream().map(PipePattern::getPattern).collect(Collectors.joining(","));
    }

    @Override
    public boolean isRoot() {
        return this.patterns.stream().anyMatch(PipePattern::isRoot);
    }

    @Override
    public boolean isLegal() {
        return this.patterns.stream().allMatch(PipePattern::isLegal);
    }

    @Override
    public boolean coversDb(String db) {
        return this.patterns.stream().anyMatch(p -> p.coversDb(db));
    }

    @Override
    public boolean coversDevice(String device) {
        return this.patterns.stream().anyMatch(p -> p.coversDevice(device));
    }

    @Override
    public boolean mayOverlapWithDb(String db) {
        return this.patterns.stream().anyMatch(p -> p.mayOverlapWithDb(db));
    }

    @Override
    public boolean mayOverlapWithDevice(String device) {
        return this.patterns.stream().anyMatch(p -> p.mayOverlapWithDevice(device));
    }

    @Override
    public boolean matchesMeasurement(String device, String measurement) {
        return this.patterns.stream().anyMatch(p -> p.matchesMeasurement(device, measurement));
    }

    @Override
    public List<PartialPath> getBaseInclusionPaths() {
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (PipePattern pipePattern : this.patterns) {
            paths.addAll(pipePattern.getBaseInclusionPaths());
        }
        return paths;
    }

    @Override
    public boolean matchPrefixPath(String path) {
        return this.patterns.stream().anyMatch(p -> p.matchPrefixPath(path));
    }

    @Override
    public boolean matchDevice(String devicePath) {
        return this.patterns.stream().anyMatch(p -> p.matchDevice(devicePath));
    }

    @Override
    public boolean matchTailNode(String tailNode) {
        return this.patterns.stream().anyMatch(p -> p.matchTailNode(tailNode));
    }

    @Override
    public List<PartialPath> getIntersection(PartialPath partialPath) {
        LinkedHashSet<PartialPath> uniqueIntersections = new LinkedHashSet<PartialPath>();
        for (IoTDBPipePattern pattern : this.patterns) {
            uniqueIntersections.addAll(pattern.getIntersection(partialPath));
        }
        return new ArrayList<PartialPath>(uniqueIntersections);
    }

    @Override
    public PathPatternTree getIntersection(PathPatternTree patternTree) {
        PathPatternTree resultTree = new PathPatternTree();
        for (IoTDBPipePattern pattern : this.patterns) {
            PathPatternTree intersection = pattern.getIntersection(patternTree);
            if (intersection.isEmpty()) continue;
            intersection.getAllPathPatterns().forEach(resultTree::appendPathPattern);
        }
        resultTree.constructTree();
        return resultTree;
    }

    @Override
    public boolean isPrefixOrFullPath() {
        return this.patterns.stream().allMatch(IoTDBPipePattern::isPrefixOrFullPath);
    }

    @Override
    public boolean mayMatchMultipleTimeSeriesInOneDevice() {
        return this.patterns.stream().anyMatch(IoTDBPipePattern::mayMatchMultipleTimeSeriesInOneDevice);
    }

    public String toString() {
        return "UnionIoTDBPipePattern{patterns=" + this.patterns + '}';
    }
}

