/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.redis.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.seata.common.exception.RedisException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.metadata.Instance;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.store.MappingDO;
import org.apache.seata.server.storage.redis.JedisPooledFactory;
import org.apache.seata.server.store.VGroupMappingStoreManager;
import redis.clients.jedis.Jedis;

@LoadLevel(name="redis")
public class RedisVGroupMappingStoreManager
implements VGroupMappingStoreManager {
    private static final String REDIS_PREFIX = "SEATA_NAMINGSERVER_NAMESPACE_";

    public boolean addVGroup(MappingDO mappingDO) {
        boolean bl;
        block8: {
            String vGroup = mappingDO.getVGroup();
            String namespace = REDIS_PREFIX + mappingDO.getNamespace();
            String clusterName = mappingDO.getCluster();
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                jedis.hset(namespace, vGroup, clusterName);
                bl = true;
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RedisException((Throwable)ex);
                }
            }
            jedis.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeVGroup(String vGroup) {
        Instance instance = Instance.getInstance();
        String namespace = REDIS_PREFIX + instance.getNamespace();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String currentVgroup = jedis.hget(namespace, vGroup);
            if (StringUtils.equalsIgnoreCase((String)currentVgroup, (String)instance.getClusterName())) {
                jedis.hdel(namespace, new String[]{vGroup});
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    public Map<String, Object> loadVGroups() {
        HashMap<String, Object> hashMap;
        block8: {
            Instance instance = Instance.getInstance();
            String namespace = REDIS_PREFIX + instance.getNamespace();
            String clusterName = instance.getClusterName();
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                Map mappingKeyMap = jedis.hgetAll(namespace);
                HashMap<String, Object> result = new HashMap<String, Object>();
                mappingKeyMap.forEach((vgroup, clusterNameValue) -> {
                    if (StringUtils.equals((String)clusterName, (String)clusterNameValue)) {
                        result.put((String)vgroup, null);
                    }
                });
                hashMap = result;
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RedisException((Throwable)ex);
                }
            }
            jedis.close();
        }
        return hashMap;
    }
}

