/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.seata.common.metadata.ClusterRole;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.metadata.namingserver.NamingServerNode;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.mcp.core.props.NameSpaceDetail;
import org.apache.seata.mcp.core.utils.UrlUtils;
import org.apache.seata.mcp.exception.ServiceCallException;
import org.apache.seata.mcp.service.ConsoleApiService;
import org.apache.seata.namingserver.manager.NamingManager;
import org.apache.seata.namingserver.service.NamingServerLocalMarkerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@ConditionalOnBean(value={NamingServerLocalMarkerImpl.class})
@Primary
@Service
public class ConsoleLocalServiceImpl
implements ConsoleApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleLocalServiceImpl.class);
    private final NamingManager namingManager;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    public ConsoleLocalServiceImpl(NamingManager namingManager, RestTemplate restTemplate, ObjectMapper objectMapper) {
        this.namingManager = namingManager;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        LOGGER.info("ConsoleLocalServiceImpl initialized.");
    }

    public String getResult(NameSpaceDetail nameSpaceDetail, HttpMethod httpMethod, String path, Object objectQueryParams, Map<String, String> queryParams, HttpHeaders headers) {
        String namespace = nameSpaceDetail.getNamespace();
        String cluster = nameSpaceDetail.getCluster();
        String vgroup = nameSpaceDetail.getvGroup();
        if (StringUtils.isNotBlank((String)namespace) && (StringUtils.isNotBlank((String)cluster) || StringUtils.isNotBlank((String)vgroup))) {
            NamingServerNode node;
            Node.Endpoint controlEndpoint;
            List list = null;
            if (StringUtils.isNotBlank((String)vgroup)) {
                list = this.namingManager.getInstancesByVgroupAndNamespace(namespace, vgroup, HttpMethod.GET.equals((Object)httpMethod));
            } else if (StringUtils.isNotBlank((String)cluster)) {
                list = this.namingManager.getInstances(namespace, cluster);
            }
            if (CollectionUtils.isNotEmpty(list) && (controlEndpoint = (node = (NamingServerNode)list.get(ThreadLocalRandom.current().nextInt(list.size()))).getControl()) != null) {
                String baseUrl = "http://" + controlEndpoint.getHost() + ":" + controlEndpoint.getPort();
                Map queryParamsMap = UrlUtils.objectToQueryParamMap((Object)objectQueryParams, (ObjectMapper)this.objectMapper);
                String targetUrl = UrlUtils.buildUrl((String)baseUrl, (String)path, queryParams, (Map)queryParamsMap);
                if (node.getRole() == ClusterRole.LEADER) {
                    headers.add("X-SEATA-RAFT-GROUP", node.getUnit());
                }
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                try {
                    ResponseEntity response = this.restTemplate.exchange(targetUrl, httpMethod, entity, String.class, new Object[0]);
                    String responseBody = (String)response.getBody();
                    if (!response.getStatusCode().is2xxSuccessful()) {
                        String errorMsg = String.format("MCP request failed with status: %s, response: %s", response.getStatusCode(), response.getBody());
                        LOGGER.warn(errorMsg);
                        throw new ServiceCallException(errorMsg, response.getStatusCode());
                    }
                    return responseBody;
                }
                catch (RestClientException e) {
                    String errorMsg = "MCP Call TC Failed.";
                    LOGGER.error(errorMsg, (Throwable)e);
                    throw new ServiceCallException(errorMsg);
                }
            }
            throw new IllegalArgumentException("Couldn't find target node url");
        }
        throw new IllegalArgumentException("Invalid NameSpace Detail");
    }

    public String getCallTC(NameSpaceDetail nameSpaceDetail, String path, Object objectQueryParams, Map<String, String> queryParams, HttpHeaders headers) {
        return this.getResult(nameSpaceDetail, HttpMethod.GET, path, objectQueryParams, queryParams, headers);
    }

    public String deleteCallTC(NameSpaceDetail nameSpaceDetail, String path, Object objectQueryParams, Map<String, String> queryParams, HttpHeaders headers) {
        return this.getResult(nameSpaceDetail, HttpMethod.DELETE, path, objectQueryParams, queryParams, headers);
    }

    public String putCallTC(NameSpaceDetail nameSpaceDetail, String path, Object objectQueryParams, Map<String, String> queryParams, HttpHeaders headers) {
        return this.getResult(nameSpaceDetail, HttpMethod.PUT, path, objectQueryParams, queryParams, headers);
    }

    public String getCallNameSpace(String path) {
        String namespace;
        try {
            namespace = this.objectMapper.writeValueAsString((Object)this.namingManager.namespace());
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Get NameSpace failed: {}", (Object)e.getMessage());
            return "Failed to get namespace";
        }
        return namespace;
    }
}

