/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.bootstrap;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.persistence.bootstrap.ImmutableRootCredentials;
import org.apache.polaris.core.persistence.bootstrap.ImmutableRootCredentialsSet;
import org.apache.polaris.core.persistence.bootstrap.RootCredentials;
import org.apache.polaris.immutables.PolarisImmutable;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableRootCredentialsSet.class)
@JsonDeserialize(as=ImmutableRootCredentialsSet.class)
@PolarisImmutable
@Value.Style(jdkOnly=true)
public interface RootCredentialsSet {
    public static final RootCredentialsSet EMPTY = ImmutableRootCredentialsSet.builder().build();
    public static final String SYSTEM_PROPERTY = "polaris.bootstrap.credentials";
    public static final String ENVIRONMENT_VARIABLE = "POLARIS_BOOTSTRAP_CREDENTIALS";

    public static RootCredentialsSet fromEnvironment() {
        return RootCredentialsSet.fromString(System.getProperty(SYSTEM_PROPERTY, System.getenv().get(ENVIRONMENT_VARIABLE)));
    }

    public static RootCredentialsSet fromString(@Nullable String credentialsString) {
        return credentialsString != null && !credentialsString.isBlank() ? RootCredentialsSet.fromList(Splitter.on((char)';').trimResults().splitToList((CharSequence)credentialsString)) : EMPTY;
    }

    public static RootCredentialsSet fromList(List<String> credentialsList) {
        HashMap<String, ImmutableRootCredentials> credentials = new HashMap<String, ImmutableRootCredentials>();
        for (String triplet : credentialsList) {
            if (triplet.isBlank()) continue;
            List parts = Splitter.on((char)',').trimResults().splitToList((CharSequence)triplet);
            if (parts.size() != 3) {
                throw new IllegalArgumentException("Invalid credentials format: " + triplet);
            }
            String realm = (String)parts.get(0);
            ImmutableRootCredentials creds = ImmutableRootCredentials.of((String)parts.get(1), (String)parts.get(2));
            if (credentials.containsKey(realm)) {
                throw new IllegalArgumentException("Duplicate realm: " + realm);
            }
            credentials.put(realm, creds);
        }
        return credentials.isEmpty() ? EMPTY : ImmutableRootCredentialsSet.of(credentials);
    }

    public static RootCredentialsSet fromUri(URI uri) {
        RootCredentialsSet rootCredentialsSet;
        block8: {
            Preconditions.checkNotNull((Object)uri);
            Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)uri.getHost()), (String)"Remote URIs are not allowed for RootCredentialsSet: %s", (Object)uri);
            InputStream is = uri.toURL().openStream();
            try {
                rootCredentialsSet = RootCredentialsSet.fromInputStream(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to read credentials from " + String.valueOf(uri), e);
                }
            }
            is.close();
        }
        return rootCredentialsSet;
    }

    private static RootCredentialsSet fromInputStream(InputStream in) throws IOException {
        YAMLFactory factory = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try (YAMLParser parser = factory.createParser(in);){
            MappingIterator values = mapper.readValues((JsonParser)parser, RootCredentialsSet.class);
            ImmutableRootCredentialsSet.Builder builder = ImmutableRootCredentialsSet.builder();
            while (values.hasNext()) {
                builder.putAllCredentials(((RootCredentialsSet)values.next()).credentials());
            }
            ImmutableRootCredentialsSet immutableRootCredentialsSet = builder.build();
            return immutableRootCredentialsSet;
        }
    }

    @JsonAnyGetter
    @JsonAnySetter
    @Value.Parameter(order=0)
    public Map<String, RootCredentials> credentials();
}

