/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.identity;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithParentName;
import io.smallrye.config.WithUnnamedKey;
import java.util.Map;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.identity.RealmServiceIdentityConfiguration;

@ConfigMapping(prefix="polaris.service-identity")
public interface ServiceIdentityConfiguration {
    public static final String DEFAULT_REALM_KEY = "<default>";

    @WithParentName
    @WithUnnamedKey(value="<default>")
    @WithDefaults
    public @WithUnnamedKey(value="<default>") Map<String, RealmServiceIdentityConfiguration> realms();

    default public RealmConfigEntry forRealm(RealmContext realmContext) {
        return this.forRealm(realmContext.getRealmIdentifier());
    }

    default public RealmConfigEntry forRealm(String realmIdentifier) {
        String resolvedRealmIdentifier = this.realms().containsKey(realmIdentifier) ? realmIdentifier : DEFAULT_REALM_KEY;
        RealmServiceIdentityConfiguration config = this.realms().containsKey(resolvedRealmIdentifier) ? this.realms().get(resolvedRealmIdentifier) : RealmServiceIdentityConfiguration.defaultConfiguration();
        return new RealmConfigEntry(resolvedRealmIdentifier, config);
    }

    public record RealmConfigEntry(String realm, RealmServiceIdentityConfiguration config) {
    }
}

