/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.storage.blob.implementation.models.BlobPropertiesInternal;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.ObjectReplicationPolicy;
import com.azure.storage.blob.models.RehydratePriority;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class BlobPropertiesInternalDownload
implements BlobPropertiesInternal {
    private final BlobDownloadHeaders headers;

    public BlobPropertiesInternalDownload(BlobDownloadHeaders headers) {
        this.headers = headers;
    }

    @Override
    public OffsetDateTime getCreationTime() {
        return this.headers.getCreationTime();
    }

    @Override
    public OffsetDateTime getLastModified() {
        return this.headers.getLastModified();
    }

    @Override
    public String getETag() {
        return this.headers.getETag();
    }

    @Override
    public long getBlobSize() {
        return ModelHelper.getBlobLength(this.headers);
    }

    @Override
    public String getContentType() {
        return this.headers.getContentType();
    }

    @Override
    public byte[] getContentMd5() {
        return this.headers.getContentMd5();
    }

    @Override
    public String getContentEncoding() {
        return this.headers.getContentEncoding();
    }

    @Override
    public String getContentDisposition() {
        return this.headers.getContentDisposition();
    }

    @Override
    public String getContentLanguage() {
        return this.headers.getContentLanguage();
    }

    @Override
    public String getCacheControl() {
        return this.headers.getCacheControl();
    }

    @Override
    public Long getBlobSequenceNumber() {
        return this.headers.getBlobSequenceNumber();
    }

    @Override
    public BlobType getBlobType() {
        return this.headers.getBlobType();
    }

    @Override
    public LeaseStatusType getLeaseStatus() {
        return this.headers.getLeaseStatus();
    }

    @Override
    public LeaseStateType getLeaseState() {
        return this.headers.getLeaseState();
    }

    @Override
    public LeaseDurationType getLeaseDuration() {
        return this.headers.getLeaseDuration();
    }

    @Override
    public String getCopyId() {
        return this.headers.getCopyId();
    }

    @Override
    public CopyStatusType getCopyStatus() {
        return this.headers.getCopyStatus();
    }

    @Override
    public String getCopySource() {
        return this.headers.getCopySource();
    }

    @Override
    public String getCopyProgress() {
        return this.headers.getCopyProgress();
    }

    @Override
    public OffsetDateTime getCopyCompletionTime() {
        return this.headers.getCopyCompletionTime();
    }

    @Override
    public String getCopyStatusDescription() {
        return this.headers.getCopyStatusDescription();
    }

    @Override
    public Boolean isServerEncrypted() {
        return this.headers.isServerEncrypted();
    }

    @Override
    public Boolean isIncrementalCopy() {
        return null;
    }

    @Override
    public String getCopyDestinationSnapshot() {
        return null;
    }

    @Override
    public AccessTier getAccessTier() {
        return null;
    }

    @Override
    public Boolean isAccessTierInferred() {
        return null;
    }

    @Override
    public ArchiveStatus getArchiveStatus() {
        return null;
    }

    @Override
    public String getEncryptionKeySha256() {
        return this.headers.getEncryptionKeySha256();
    }

    @Override
    public String getEncryptionScope() {
        return this.headers.getEncryptionScope();
    }

    @Override
    public OffsetDateTime getAccessTierChangeTime() {
        return null;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.headers.getMetadata();
    }

    @Override
    public Integer getCommittedBlockCount() {
        return this.headers.getBlobCommittedBlockCount();
    }

    @Override
    public Long getTagCount() {
        return this.headers.getTagCount();
    }

    @Override
    public String getVersionId() {
        return this.headers.getVersionId();
    }

    @Override
    public Boolean isCurrentVersion() {
        return this.headers.isCurrentVersion();
    }

    @Override
    public List<ObjectReplicationPolicy> getObjectReplicationSourcePolicies() {
        return this.headers.getObjectReplicationSourcePolicies();
    }

    @Override
    public String getObjectReplicationDestinationPolicyId() {
        return this.headers.getObjectReplicationDestinationPolicyId();
    }

    @Override
    public RehydratePriority getRehydratePriority() {
        return null;
    }

    @Override
    public Boolean isSealed() {
        return this.headers.isSealed();
    }

    @Override
    public OffsetDateTime getLastAccessedTime() {
        return this.headers.getLastAccessedTime();
    }

    @Override
    public OffsetDateTime getExpiresOn() {
        return null;
    }

    @Override
    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        return this.headers.getImmutabilityPolicy();
    }

    @Override
    public Boolean hasLegalHold() {
        return this.headers.hasLegalHold();
    }

    @Override
    public String getRequestId() {
        return this.headers.getRequestId();
    }
}

