/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.sessions;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.server.batch.BatchSession;
import org.apache.livy.server.recovery.SessionStore;
import org.apache.livy.sessions.FinishedSessionState;
import org.apache.livy.sessions.Session;
import org.apache.livy.sessions.SessionManager$;
import org.apache.livy.sessions.SessionState;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\rs!B\u0016-\u0011\u0003)d!B\u001c-\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005bB!\u0002\u0005\u0004%\tA\u0011\u0005\u0007\u0017\u0006\u0001\u000b\u0011B\"\t\u000f1\u000b!\u0019!C\u0001\u0005\"1Q*\u0001Q\u0001\n\rCqAT\u0001\u0012\u0002\u0013\u0005qJ\u0002\u00038Y\u0001a\bBCA\u0003\u0011\t\u0015\r\u0011\"\u0005\u0002\b!Q\u0011q\u0002\u0005\u0003\u0002\u0003\u0006I!!\u0003\t\u0015\u0005E\u0001B!A!\u0002\u0013\t\u0019\u0002\u0003\u0006\u0002$!\u0011\t\u0011)A\u0005\u0003KA!\"!\u000e\t\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011)\t)\u0005\u0003B\u0001B\u0003%\u0011q\t\u0005\u000b\u0003?B!1!Q\u0001\f\u0005\u0005\u0004BB \t\t\u0003\ti\u0007C\u0004\u0002\u0000!!\u0019\"!!\t\u0013\u0005=\u0005B1Q\u0005\u0016\u0005E\u0005\u0002CAS\u0011\u0001\u0006i!a%\t\u00115B!\u0019)C\u000b\u0003OC\u0001\"a0\tA\u00035\u0011\u0011\u0016\u0005\t\u0003\u0003D\u0001\u0015!\u0004\u0002D\"A\u0011\u0011\u001a\u0005!\u0002\u001b\tY\r\u0003\u0005\u0002R\"\u0001\u000bQBAf\u0011!\t\u0019\u000e\u0003Q\u0001\u000e\u0005U\u0007\u0002CAn\u0011\u0001\u0006i!a3\t\u0011\u0005u\u0007\u0002)A\u0007\u0003+D\u0001\"a8\tA\u00035\u0011Q\u001b\u0005\b\u0003CDA\u0011AAr\u0011\u001d\t)\u000f\u0003C\u0001\u0003ODq!!<\t\t\u0003\ty\u000fC\u0004\u0002n\"!\t!a>\t\u000f\u0005u\b\u0002\"\u0001\u0002d\"9\u0011q \u0005\u0005\u0002\t\u0005\u0001b\u0002B\u0005\u0011\u0011\u0005!1\u0002\u0005\b\u0005\u0013AA\u0011\u0001B\u000f\u0011\u001d\u0011\t\u0003\u0003C\u0001\u0005GAqA!\n\t\t\u0003\u00119\u0003C\u0004\u0003.!!IAa\f\u0007\r\tE\u0002\u0002\u0002B\u001a\u0011\u0019y\u0004\u0006\"\u0001\u0003<!9!\u0011\t\u0015\u0005B\t\r\u0012AD*fgNLwN\\'b]\u0006<WM\u001d\u0006\u0003[9\n\u0001b]3tg&|gn\u001d\u0006\u0003_A\nA\u0001\\5ws*\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0007\u0001\u0001\"AN\u0001\u000e\u00031\u0012abU3tg&|g.T1oC\u001e,'o\u0005\u0002\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001b\u00023M+5kU%P\u001d~\u0013ViQ(W\u000bJKv,T(E\u000b~{eIR\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0005Y\u0006twMC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)+%AB*ue&tw-\u0001\u000eT\u000bN\u001b\u0016j\u0014(`%\u0016\u001buJV#S3~ku\nR#`\u001f\u001a3\u0005%\u0001\u0010T\u000bN\u001b\u0016j\u0014(`%\u0016\u001buJV#S3~ku\nR#`%\u0016\u001buJV#S3\u0006y2+R*T\u0013>suLU#D\u001fZ+%+W0N\u001f\u0012+uLU#D\u001fZ+%+\u0017\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\r\u0001flZ\u000b\u0002#*\u0012!+\u0016\b\u0003uMK!\u0001V\u001e\u0002\t9{g.Z\u0016\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\nk:\u001c\u0007.Z2lK\u0012T!aW\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002^1\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b};!\u0019\u00011\u0003\u0003M\u000b\"!\u00193\u0011\u0005i\u0012\u0017BA2<\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AN3\n\u0005\u0019d#aB*fgNLwN\u001c\u0003\u0006Q\u001e\u0011\r!\u001b\u0002\u0002%F\u0011\u0011M\u001b\t\u0003Wft!\u0001\\<\u000f\u000554hB\u00018v\u001d\tyGO\u0004\u0002qg6\t\u0011O\u0003\u0002si\u00051AH]8pizJ\u0011aM\u0005\u0003cIJ!a\f\u0019\n\u00055r\u0013B\u0001=-\u0003\u001d\u0019Vm]:j_:L!A_>\u0003!I+7m\u001c<feflU\r^1eCR\f'B\u0001=-+\u0015i\u0018\u0011EA\u000f'\rA\u0011H \t\u0004\u007f\u0006\u0005Q\"\u0001\u0018\n\u0007\u0005\raFA\u0004M_\u001e<\u0017N\\4\u0002\u00111Lg/_\"p]\u001a,\"!!\u0003\u0011\u0007}\fY!C\u0002\u0002\u000e9\u0012\u0001\u0002T5ws\u000e{gNZ\u0001\nY&4\u0018pQ8oM\u0002\nqb]3tg&|gNU3d_Z,'/\u001f\t\bu\u0005U\u0011\u0011DA\u0010\u0013\r\t9b\u000f\u0002\n\rVt7\r^5p]F\u0002B!a\u0007\u0002\u001e1\u0001A!\u00025\t\u0005\u0004I\u0007\u0003BA\u000e\u0003C!Qa\u0018\u0005C\u0002\u0001\fAb]3tg&|gn\u0015;pe\u0016\u0004B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0005sK\u000e|g/\u001a:z\u0015\r\tyCL\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005M\u0012\u0011\u0006\u0002\r'\u0016\u001c8/[8o'R|'/Z\u0001\fg\u0016\u001c8/[8o)f\u0004X\r\u0005\u0003\u0002:\u0005\u0005c\u0002BA\u001e\u0003{\u0001\"\u0001]\u001e\n\u0007\u0005}2(\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0015\u0006\r#bAA w\u0005aQn\\2l'\u0016\u001c8/[8ogB)!(!\u0013\u0002N%\u0019\u00111J\u001e\u0003\r=\u0003H/[8o!\u0019\ty%!\u0017\u0002 9!\u0011\u0011KA+\u001d\r\u0001\u00181K\u0005\u0002y%\u0019\u0011qK\u001e\u0002\u000fA\f7m[1hK&!\u00111LA/\u0005\r\u0019V-\u001d\u0006\u0004\u0003/Z\u0014AC3wS\u0012,gnY3%cA1\u00111MA5\u00033i!!!\u001a\u000b\u0007\u0005\u001d4(A\u0004sK\u001adWm\u0019;\n\t\u0005-\u0014Q\r\u0002\t\u00072\f7o\u001d+bORa\u0011qNA;\u0003o\nI(a\u001f\u0002~Q!\u0011\u0011OA:!\u00191\u0004\"a\b\u0002\u001a!9\u0011q\f\tA\u0004\u0005\u0005\u0004bBA\u0003!\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003#\u0001\u0002\u0019AA\n\u0011\u001d\t\u0019\u0003\u0005a\u0001\u0003KAq!!\u000e\u0011\u0001\u0004\t9\u0004C\u0005\u0002FA\u0001\n\u00111\u0001\u0002H\u0005AQ\r_3dkR|'/\u0006\u0002\u0002\u0004B!\u0011QQAF\u001b\t\t9IC\u0002\u0002\nn\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\ti)a\"\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018!C5e\u0007>,h\u000e^3s+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006\u0005VBAAL\u0015\u0011\tI*a'\u0002\r\u0005$x.\\5d\u0015\u0011\tI)!(\u000b\u0007\u0005}u)\u0001\u0003vi&d\u0017\u0002BAR\u0003/\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018AC5e\u0007>,h\u000e^3sAU\u0011\u0011\u0011\u0016\t\t\u0003W\u000b),!/\u0002 5\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,A\u0004nkR\f'\r\\3\u000b\u0007\u0005M6(\u0001\u0006d_2dWm\u0019;j_:LA!a.\u0002.\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u00042AOA^\u0013\r\til\u000f\u0002\u0004\u0013:$\u0018!C:fgNLwN\\:!\u00039\u0019Xm]:j_:\u001c()\u001f(b[\u0016\u0004r!a+\u0002F\u000e\u000by\"\u0003\u0003\u0002H\u00065&a\u0002%bg\"l\u0015\r]\u0001\u0014g\u0016\u001c8/[8o)&lWm\\;u\u0007\",7m\u001b\t\u0004u\u00055\u0017bAAhw\t9!i\\8mK\u0006t\u0017aG:fgNLwN\u001c+j[\u0016|W\u000f^\"iK\u000e\\7k[5q\u0005V\u001c\u00180\u0001\btKN\u001c\u0018n\u001c8US6,w.\u001e;\u0011\u0007i\n9.C\u0002\u0002Zn\u0012A\u0001T8oO\u0006y1/Z:tS>tG\u000b\u001e7DQ\u0016\u001c7.\u0001\u0006tKN\u001c\u0018n\u001c8Ui2\f\u0011d]3tg&|gn\u0015;bi\u0016\u0014V\r^1j]\u0016$\u0017J\\*fG\u00061a.\u001a=u\u0013\u0012$\"!!/\u0002\u0011I,w-[:uKJ$B!a\b\u0002j\"9\u00111\u001e\u0010A\u0002\u0005}\u0011aB:fgNLwN\\\u0001\u0004O\u0016$H\u0003BAy\u0003g\u0004RAOA%\u0003?Aq!!> \u0001\u0004\tI,\u0001\u0002jIR!\u0011\u0011_A}\u0011\u001d\tY\u0010\ta\u0001\u0003o\t1b]3tg&|gNT1nK\u0006!1/\u001b>f\u0003\r\tG\u000e\u001c\u000b\u0003\u0005\u0007\u0001b!a\u0014\u0003\u0006\u0005}\u0011\u0002\u0002B\u0004\u0003;\u0012\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\u0007I\u0016dW\r^3\u0015\t\t5!1\u0004\t\u0006u\u0005%#q\u0002\t\u0007\u0003\u000b\u0013\tB!\u0006\n\t\tM\u0011q\u0011\u0002\u0007\rV$XO]3\u0011\u0007i\u00129\"C\u0002\u0003\u001am\u0012A!\u00168ji\"9\u0011Q_\u0012A\u0002\u0005eF\u0003\u0002B\b\u0005?Aq!a;%\u0001\u0004\ty\"\u0001\u0005tQV$Hm\\<o)\t\u0011)\"\u0001\bd_2dWm\u0019;HCJ\u0014\u0017mZ3\u0015\u0005\t%\u0002CBAC\u0005#\u0011Y\u0003\u0005\u0004\u0002P\t\u0015!QC\u0001\be\u0016\u001cwN^3s)\t\tiE\u0001\tHCJ\u0014\u0017mZ3D_2dWm\u0019;peN\u0019\u0001F!\u000e\u0011\u0007\u0011\u00139$C\u0002\u0003:\u0015\u0013a\u0001\u00165sK\u0006$GC\u0001B\u001f!\r\u0011y\u0004K\u0007\u0002\u0011\u0005\u0019!/\u001e8")
public class SessionManager<S extends Session, R extends Session.RecoveryMetadata>
implements Logging {
    private final LivyConf livyConf;
    private final Function1<R, S> sessionRecovery;
    private final SessionStore sessionStore;
    private final String sessionType;
    private final ClassTag<R> evidence$1;
    private final AtomicInteger idCounter;
    private final LinkedHashMap<Object, S> sessions;
    private final HashMap<String, S> sessionsByName;
    private final boolean sessionTimeoutCheck;
    private final boolean sessionTimeoutCheckSkipBusy;
    private final long sessionTimeout;
    private final boolean sessionTtlCheck;
    private final long sessionTtl;
    private final long sessionStateRetainedInSec;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static <S extends Session, R extends Session.RecoveryMetadata> None$ $lessinit$greater$default$5() {
        return SessionManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String SESSION_RECOVERY_MODE_RECOVERY() {
        return SessionManager$.MODULE$.SESSION_RECOVERY_MODE_RECOVERY();
    }

    public static String SESSION_RECOVERY_MODE_OFF() {
        return SessionManager$.MODULE$.SESSION_RECOVERY_MODE_OFF();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public LivyConf livyConf() {
        return this.livyConf;
    }

    public ExecutionContext executor() {
        return ExecutionContext$.MODULE$.global();
    }

    public final AtomicInteger idCounter() {
        return this.idCounter;
    }

    public final LinkedHashMap<Object, S> sessions() {
        return this.sessions;
    }

    public synchronized int nextId() {
        int id = this.idCounter().getAndIncrement();
        this.sessionStore.saveNextSessionId(this.sessionType, this.idCounter().get());
        return id;
    }

    public S register(S session) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Registering new session ").append(session.id()).toString());
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            ((Session)session).name().foreach((Function1 & Serializable & scala.Serializable)sessionName -> {
                if ($this.sessionsByName.contains(sessionName)) {
                    String errMsg = new StringBuilder(37).append("Duplicate session name: ").append(session.name()).append(" for session ").append(session.id()).toString();
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
                    session.stop();
                    throw new IllegalArgumentException(errMsg);
                }
                return $this.sessionsByName.put(sessionName, session);
            });
            this.sessions().put((Object)BoxesRunTime.boxToInteger((int)((Session)session).id()), session);
            ((Session)session).start();
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Registered new session ").append(session.id()).toString());
        return session;
    }

    public Option<S> get(int id) {
        return this.sessions().get((Object)BoxesRunTime.boxToInteger((int)id));
    }

    public Option<S> get(String sessionName) {
        return this.sessionsByName.get((Object)sessionName);
    }

    public int size() {
        return this.sessions().size();
    }

    public Iterable<S> all() {
        return this.sessions().values();
    }

    public Option<Future<BoxedUnit>> delete(int id) {
        return this.get(id).map((Function1 & Serializable & scala.Serializable)session -> this.delete(session));
    }

    public Future<BoxedUnit> delete(S session) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Deleting ").append(session).toString());
        return ((Session)session).stop().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SessionManager.$anonfun$delete$3(this, session, x0$1);
            return BoxedUnit.UNIT;
        }, this.executor());
    }

    public void shutdown() {
        boolean recoveryEnabled;
        String string = this.livyConf().get(LivyConf$.MODULE$.RECOVERY_MODE());
        String string2 = SessionManager$.MODULE$.SESSION_RECOVERY_MODE_OFF();
        boolean bl = (string == null ? string2 != null : !string.equals(string2)) ? true : (recoveryEnabled = false);
        if (!recoveryEnabled) {
            ((IterableLike)this.sessions().values().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.stop(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)future -> (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)Duration$.MODULE$.Inf()));
            return;
        }
    }

    public Future<Iterable<BoxedUnit>> collectGarbage() {
        return Future$.MODULE$.sequence((TraversableOnce)((TraversableLike)this.all().filter((Function1 & Serializable & scala.Serializable)session -> BoxesRunTime.boxToBoolean((boolean)this.expired$1(session)))).map((Function1 & Serializable & scala.Serializable)s -> {
            SessionState sessionState = s.state();
            if (sessionState instanceof FinishedSessionState) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Deleting ").append(s).append(" because it finished before ").append((double)$this.sessionStateRetainedInSec / 1.0E9).append(" secs.").toString());
            } else {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Deleting ").append(s).append(" because it was inactive for more than ").append((double)$this.sessionTimeout / 1.0E9).append(" secs.").toString());
            }
            return this.delete(s);
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom(), this.executor());
    }

    private Seq<S> recover() {
        this.idCounter().set(this.sessionStore.getNextSessionId(this.sessionType));
        Seq<Try<R>> sessionMetadata = this.sessionStore.getAllSessions(this.sessionType, this.evidence$1);
        Seq recoveredSessions = (Seq)((TraversableLike)sessionMetadata.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(x$4.toOption()), Seq$.MODULE$.canBuildFrom())).map(this.sessionRecovery, Seq$.MODULE$.canBuildFrom());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Recovered ").append(recoveredSessions.length()).append(" ").append($this.sessionType).append(" sessions.").append(" Next session id: ").append(this.idCounter()).toString());
        Seq recoveryFailure = (Seq)((TraversableLike)sessionMetadata.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isFailure()))).map((Function1 & Serializable & scala.Serializable)x$6 -> (Throwable)x$6.failed().get(), Seq$.MODULE$.canBuildFrom());
        recoveryFailure.foreach((Function1 & Serializable & scala.Serializable)ex -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> ex.getMessage(), ex.getCause());
            return BoxedUnit.UNIT;
        });
        return recoveredSessions;
    }

    public static final /* synthetic */ void $anonfun$delete$3(SessionManager $this, Session session$2, Object x0$1) {
        Object object = x0$1;
        try {
            try {
                $this.sessionStore.remove($this.sessionType, session$2.id());
                SessionManager sessionManager = $this;
                synchronized (sessionManager) {
                    $this.sessions().remove((Object)BoxesRunTime.boxToInteger((int)session$2.id()));
                    session$2.name().foreach((Function1 & Serializable & scala.Serializable)key -> $this.sessionsByName.remove(key));
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Exception was thrown during stop session:", e);
                    throw e;
                }
                throw throwable;
            }
        }
        finally {
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Deleted ").append(session$2).toString());
        }
    }

    private final boolean expired$1(Session session) {
        SessionState sessionState = session.state();
        if (sessionState instanceof FinishedSessionState) {
            FinishedSessionState finishedSessionState = (FinishedSessionState)sessionState;
            long currentTime = System.nanoTime();
            return currentTime - finishedSessionState.time() > this.sessionStateRetainedInSec;
        }
        if (!this.sessionTimeoutCheck) {
            return false;
        }
        SessionState sessionState2 = session.state();
        SessionState.Busy$ busy$ = SessionState.Busy$.MODULE$;
        if (!(sessionState2 != null ? !sessionState2.equals(busy$) : busy$ != null) && this.sessionTimeoutCheckSkipBusy) {
            return false;
        }
        if (session instanceof BatchSession) {
            return false;
        }
        long currentTime = System.nanoTime();
        long calculatedTimeout = this.sessionTimeout;
        if (session.idleTimeout().isDefined()) {
            calculatedTimeout = ClientConf.getTimeAsMs((String)((String)session.idleTimeout().get()));
        }
        calculatedTimeout = TimeUnit.MILLISECONDS.toNanos(calculatedTimeout);
        if (currentTime - session.lastActivity() > calculatedTimeout) {
            return true;
        }
        if (this.sessionTtlCheck && session.startedOn().isDefined()) {
            calculatedTimeout = session.ttl().isDefined() ? TimeUnit.MILLISECONDS.toNanos(ClientConf.getTimeAsMs((String)((String)session.ttl().get()))) : TimeUnit.MILLISECONDS.toNanos(this.sessionTtl);
            if (currentTime - BoxesRunTime.unboxToLong((Object)session.startedOn().get()) > calculatedTimeout) {
                return true;
            }
        }
        return false;
    }

    public SessionManager(LivyConf livyConf, Function1<R, S> sessionRecovery, SessionStore sessionStore, String sessionType, Option<Seq<S>> mockSessions, ClassTag<R> evidence$1) {
        this.livyConf = livyConf;
        this.sessionRecovery = sessionRecovery;
        this.sessionStore = sessionStore;
        this.sessionType = sessionType;
        this.evidence$1 = evidence$1;
        Logging.$init$((Logging)this);
        this.idCounter = new AtomicInteger(0);
        this.sessions = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.sessionsByName = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.sessionTimeoutCheck = livyConf.getBoolean(LivyConf$.MODULE$.SESSION_TIMEOUT_CHECK());
        this.sessionTimeoutCheckSkipBusy = livyConf.getBoolean(LivyConf$.MODULE$.SESSION_TIMEOUT_CHECK_SKIP_BUSY());
        this.sessionTimeout = livyConf.getTimeAsMs(LivyConf$.MODULE$.SESSION_TIMEOUT());
        this.sessionTtlCheck = livyConf.getBoolean(LivyConf$.MODULE$.SESSION_TTL_CHECK());
        this.sessionTtl = livyConf.getTimeAsMs(LivyConf$.MODULE$.SESSION_TTL());
        this.sessionStateRetainedInSec = TimeUnit.MILLISECONDS.toNanos(livyConf.getTimeAsMs(LivyConf$.MODULE$.SESSION_STATE_RETAIN_TIME()));
        ((IterableLike)mockSessions.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.recover())).foreach((Function1 & Serializable & scala.Serializable)session -> this.register(session));
        new GarbageCollector().start();
    }

    private class GarbageCollector
    extends Thread {
        @Override
        public void run() {
            while (true) {
                this.org$apache$livy$sessions$SessionManager$GarbageCollector$$$outer().collectGarbage();
                Thread.sleep(60000L);
            }
        }

        public /* synthetic */ SessionManager org$apache$livy$sessions$SessionManager$GarbageCollector$$$outer() {
            return SessionManager.this;
        }

        public GarbageCollector() {
            if (SessionManager.this == null) {
                throw null;
            }
            super("session gc thread");
            this.setDaemon(true);
        }
    }
}

