/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.mqtt.ConnListenerBuilder;
import org.apache.bifromq.mqtt.IMQTTBroker;
import org.apache.bifromq.mqtt.MQTTBrokerBuilder;
import org.apache.bifromq.plugin.authprovider.AuthProviderManager;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.clientbalancer.ClientBalancerManager;
import org.apache.bifromq.plugin.clientbalancer.IClientBalancer;
import org.apache.bifromq.plugin.eventcollector.EventCollectorManager;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.ResourceThrottlerManager;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.SettingProviderManager;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.mqtt.MQTTServerConfig;
import org.apache.bifromq.starter.module.SSLUtil;
import org.apache.bifromq.starter.module.ServiceInjector;

public class MQTTServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Optional<IMQTTBroker>>(){}).toProvider(MQTTBrokerServerProvider.class).in(Singleton.class);
    }

    private static class MQTTBrokerServerProvider
    implements Provider<Optional<IMQTTBroker>> {
        private final StandaloneConfig config;
        private final ServiceInjector injector;

        @Inject
        private MQTTBrokerServerProvider(StandaloneConfig config, ServiceInjector injector) {
            this.config = config;
            this.injector = injector;
        }

        public Optional<IMQTTBroker> get() {
            MQTTServerConfig serverConfig = this.config.getMqttServiceConfig().getServer();
            if (!serverConfig.isEnable()) {
                return Optional.empty();
            }
            MQTTBrokerBuilder brokerBuilder = IMQTTBroker.builder().rpcServerBuilder(this.injector.getInstance(RPCServerBuilder.class)).mqttBossELGThreads(serverConfig.getBossELGThreads()).mqttWorkerELGThreads(serverConfig.getWorkerELGThreads()).authProvider((IAuthProvider)this.injector.getInstance(AuthProviderManager.class)).clientBalancer((IClientBalancer)this.injector.getInstance(ClientBalancerManager.class)).eventCollector((IEventCollector)this.injector.getInstance(EventCollectorManager.class)).resourceThrottler((IResourceThrottler)this.injector.getInstance(ResourceThrottlerManager.class)).settingProvider((ISettingProvider)this.injector.getInstance(SettingProviderManager.class)).distClient(this.injector.getInstance(IDistClient.class)).inboxClient(this.injector.getInstance(IInboxClient.class)).sessionDictClient(this.injector.getInstance(ISessionDictClient.class)).retainClient(this.injector.getInstance(IRetainClient.class)).connectTimeoutSeconds(serverConfig.getConnTimeoutSec()).connectRateLimit(serverConfig.getMaxConnPerSec()).disconnectRate(serverConfig.getMaxDisconnPerSec()).readLimit((long)serverConfig.getMaxConnBandwidth()).writeLimit((long)serverConfig.getMaxConnBandwidth()).maxBytesInMessage(serverConfig.getMaxMsgByteSize()).userPropsCustomizerFactoryConfig(serverConfig.getUserPropsCustomizerFactoryConfig());
            if (serverConfig.getTcpListener().isEnable()) {
                ((ConnListenerBuilder.TCPConnListenerBuilder)((ConnListenerBuilder.TCPConnListenerBuilder)brokerBuilder.buildTcpConnListener().host(serverConfig.getTcpListener().getHost())).port(serverConfig.getTcpListener().getPort())).buildListener();
            }
            if (serverConfig.getTlsListener().isEnable()) {
                ((ConnListenerBuilder.TLSConnListenerBuilder)((ConnListenerBuilder.TLSConnListenerBuilder)((ConnListenerBuilder.TLSConnListenerBuilder)brokerBuilder.buildTLSConnListener().host(serverConfig.getTlsListener().getHost())).port(serverConfig.getTlsListener().getPort())).sslContext(SSLUtil.buildServerSslContext(serverConfig.getTlsListener().getSslConfig()))).buildListener();
            }
            if (serverConfig.getWsListener().isEnable()) {
                ((ConnListenerBuilder.WSConnListenerBuilder)((ConnListenerBuilder.WSConnListenerBuilder)brokerBuilder.buildWSConnListener().host(serverConfig.getWsListener().getHost())).port(serverConfig.getWsListener().getPort())).path(serverConfig.getWsListener().getWsPath()).buildListener();
            }
            if (serverConfig.getWssListener().isEnable()) {
                ((ConnListenerBuilder.WSSConnListenerBuilder)((ConnListenerBuilder.WSSConnListenerBuilder)((ConnListenerBuilder.WSSConnListenerBuilder)brokerBuilder.buildWSSConnListener().host(serverConfig.getWssListener().getHost())).port(serverConfig.getWssListener().getPort())).path(serverConfig.getWssListener().getWsPath()).sslContext(SSLUtil.buildServerSslContext(serverConfig.getWssListener().getSslConfig()))).buildListener();
            }
            return Optional.of(brokerBuilder.build());
        }
    }
}

