/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.network.OutNetworkObject;
import org.apache.ignite3.internal.network.netty.NettySender;
import org.apache.ignite3.internal.network.recovery.DescriptorAcquiry;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class RecoveryDescriptor {
    private final Queue<OutNetworkObject> unacknowledgedMessages;
    private long sentCount;
    private long acknowledgedCount;
    private long receivedCount;
    private final AtomicReference<DescriptorAcquiry> channelHolder = new AtomicReference();

    public RecoveryDescriptor(int queueLimit) {
        this.unacknowledgedMessages = new ArrayDeque<OutNetworkObject>(queueLimit);
    }

    public long receivedCount() {
        return this.receivedCount;
    }

    public void acknowledge(long messagesReceivedByRemote) {
        while (this.acknowledgedCount < messagesReceivedByRemote) {
            OutNetworkObject req = this.unacknowledgedMessages.poll();
            assert (req != null);
            req.acknowledge();
            ++this.acknowledgedCount;
        }
    }

    public int unacknowledgedCount() {
        long res = this.sentCount - this.acknowledgedCount;
        int size = this.unacknowledgedMessages.size();
        assert (res >= 0L);
        assert (res == (long)size);
        return size;
    }

    public List<OutNetworkObject> unacknowledgedMessages() {
        return new ArrayList<OutNetworkObject>(this.unacknowledgedMessages);
    }

    public void add(OutNetworkObject msg) {
        msg.shouldBeSavedForRecovery(false);
        ++this.sentCount;
        boolean added = this.unacknowledgedMessages.add(msg);
        assert (added) : "Wasn't added as the queue is full: " + msg.networkMessage();
    }

    public long onReceive() {
        ++this.receivedCount;
        return this.receivedCount;
    }

    public String toString() {
        return S.toString(RecoveryDescriptor.class, this);
    }

    public void release(ChannelHandlerContext ctx) {
        DescriptorAcquiry oldAcquiry = this.channelHolder.getAndUpdate(acquiry -> {
            if (acquiry != null && acquiry.channel() == ctx.channel()) {
                return null;
            }
            return acquiry;
        });
        if (oldAcquiry != null && oldAcquiry.channel() == ctx.channel()) {
            oldAcquiry.markClinchResolved();
        }
    }

    public boolean tryAcquire(ChannelHandlerContext ctx, CompletableFuture<NettySender> handshakeCompleteFuture) {
        return this.doTryAcquire(ctx.channel(), handshakeCompleteFuture);
    }

    private boolean doTryAcquire(@Nullable Channel channel, CompletableFuture<NettySender> handshakeCompleteFuture) {
        return this.channelHolder.compareAndSet(null, new DescriptorAcquiry(channel, handshakeCompleteFuture));
    }

    public boolean tryBlockForever(Exception ex) {
        return this.doTryAcquire(null, CompletableFuture.failedFuture(ex));
    }

    public boolean isBlockedForever() {
        DescriptorAcquiry acquiry = this.channelHolder.get();
        return acquiry != null && acquiry.channel() == null;
    }

    @Nullable
    public DescriptorAcquiry holder() {
        return this.channelHolder.get();
    }

    @Nullable
    public Channel holderChannel() {
        DescriptorAcquiry acquiry = this.holder();
        return acquiry == null ? null : acquiry.channel();
    }

    String holderDescription() {
        DescriptorAcquiry acquiry = this.channelHolder.get();
        if (acquiry == null) {
            return "No acquiry";
        }
        Channel channel = acquiry.channel();
        if (channel == null) {
            return "Blocked (no channel)";
        }
        return channel.toString();
    }

    public void dispose(Exception exceptionToFailSendFutures) {
        for (OutNetworkObject unackedMessageObj : this.unacknowledgedMessages) {
            unackedMessageObj.failAcknowledgement(exceptionToFailSendFutures);
        }
        this.unacknowledgedMessages.clear();
    }
}

