/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ignite.internal.marshaller.MarshallerColumn;
import org.apache.ignite.internal.marshaller.MarshallerSchema;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.mapping.ColumnMapping;
import org.apache.ignite.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.type.TemporalNativeType;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SchemaDescriptor {
    private final int ver;
    private final List<Column> columns;
    private final List<Column> keyCols;
    private final List<Column> valCols;
    private final List<Column> colocationCols;
    private final Map<String, Column> columnsByName;
    private final boolean hasTemporalColumns;
    private ColumnMapper colMapper = ColumnMapping.identityMapping();
    private MarshallerSchema marshallerSchema;

    @TestOnly
    public SchemaDescriptor(int ver, Column[] keyCols, Column[] valCols) {
        this(ver, SchemaDescriptor.mergeColumns(keyCols, valCols), Arrays.stream(keyCols).map(Column::name).collect(Collectors.toList()), null);
    }

    public SchemaDescriptor(int ver, List<Column> columns, List<String> keyColumns, @Nullable List<String> colocationColumns) {
        Object2IntMap<String> columnNameToPositionInColocation;
        assert (!CollectionUtils.nullOrEmpty(columns)) : "Schema should have at least one column";
        HashMap<String, Object> columnsByName = new HashMap<String, Object>();
        ArrayList<Object> orderedColumns = new ArrayList<Object>(columns.size());
        Object2IntMap<String> columnNameToPositionInKey = SchemaDescriptor.toElementToPositionMap(keyColumns);
        if (colocationColumns == null) {
            columnNameToPositionInColocation = columnNameToPositionInKey;
        } else {
            columnNameToPositionInColocation = SchemaDescriptor.toElementToPositionMap(colocationColumns);
            assert (columnNameToPositionInKey.keySet().containsAll(colocationColumns)) : "Colocation column must be part of the key: keyCols=" + String.valueOf(keyColumns) + ", colocationCols=" + String.valueOf(colocationColumns);
        }
        boolean hasTemporalColumns = false;
        int rowPosition = 0;
        int valuePosition = 0;
        for (Column column : columns) {
            Column orderedColumn = column.copy(rowPosition++, columnNameToPositionInKey.getOrDefault((Object)column.name(), -1), columnNameToPositionInKey.containsKey((Object)column.name()) ? -1 : valuePosition++, columnNameToPositionInColocation.getOrDefault((Object)column.name(), -1));
            Column old = (Column)columnsByName.put(orderedColumn.name(), orderedColumn);
            assert (old == null) : "Columns with similar names are not allowed: " + old.name();
            orderedColumns.add(orderedColumn);
            if (!(column.type() instanceof TemporalNativeType)) continue;
            hasTemporalColumns = true;
        }
        this.ver = ver;
        this.columns = List.copyOf(orderedColumns);
        this.columnsByName = Map.copyOf(columnsByName);
        this.hasTemporalColumns = hasTemporalColumns;
        ArrayList<Column> tmpKeyColumns = new ArrayList<Column>(keyColumns.size());
        BitSet keyColumnsBitSet = new BitSet(columns.size());
        for (String name : keyColumns) {
            Column column = (Column)columnsByName.get(name);
            assert (column != null) : name;
            assert (!column.nullable()) : "Primary key cannot contain nullable column: " + name;
            tmpKeyColumns.add(column);
            assert (!keyColumnsBitSet.get(column.positionInRow())) : column.name();
            keyColumnsBitSet.set(column.positionInRow());
        }
        this.keyCols = List.copyOf(tmpKeyColumns);
        this.colocationCols = colocationColumns == null ? this.keyCols : colocationColumns.stream().map(columnsByName::get).collect(Collectors.toList());
        ArrayList<Column> tmpValueColumns = new ArrayList<Column>(columns.size() - keyColumnsBitSet.cardinality());
        for (Column column : orderedColumns) {
            if (keyColumnsBitSet.get(column.positionInRow())) continue;
            tmpValueColumns.add(column);
        }
        this.valCols = List.copyOf(tmpValueColumns);
    }

    private static List<Column> mergeColumns(Column[] keyColumns, Column[] valueColumns) {
        ArrayList<Column> columns = new ArrayList<Column>(keyColumns.length + valueColumns.length);
        Collections.addAll(columns, keyColumns);
        Collections.addAll(columns, valueColumns);
        return columns;
    }

    public int version() {
        return this.ver;
    }

    public Column column(int colIdx) {
        this.validateColumnIndex(colIdx);
        return this.columns.get(colIdx);
    }

    @Nullable
    public Column column(String name) {
        return this.columnsByName.get(name);
    }

    public List<Column> columns() {
        return this.columns;
    }

    private void validateColumnIndex(int colIdx) {
        Objects.checkIndex(colIdx, this.length());
    }

    public List<Column> keyColumns() {
        return this.keyCols;
    }

    public List<Column> colocationColumns() {
        return this.colocationCols;
    }

    public List<Column> valueColumns() {
        return this.valCols;
    }

    public int length() {
        return this.columns.size();
    }

    public void columnMapping(ColumnMapper colMapper) {
        this.colMapper = colMapper;
    }

    public ColumnMapper columnMapping() {
        return this.colMapper;
    }

    public boolean hasTemporalColumns() {
        return this.hasTemporalColumns;
    }

    public String toString() {
        return S.toString(SchemaDescriptor.class, (Object)this);
    }

    public MarshallerSchema marshallerSchema() {
        if (this.marshallerSchema == null) {
            this.marshallerSchema = new ServerMarshallerSchema(this);
        }
        return this.marshallerSchema;
    }

    private static Object2IntMap<String> toElementToPositionMap(List<String> elements) {
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        int idx = 0;
        for (String element : elements) {
            assert (!result.containsKey((Object)element)) : "Elements should not have duplicates: " + element;
            result.put((Object)element, idx++);
        }
        return result;
    }

    private static class ServerMarshallerSchema
    implements MarshallerSchema {
        private final SchemaDescriptor schema;
        private MarshallerColumn[] keys;
        private MarshallerColumn[] values;
        private MarshallerColumn[] row;

        private ServerMarshallerSchema(SchemaDescriptor schema) {
            this.schema = schema;
        }

        public int schemaVersion() {
            return this.schema.version();
        }

        public MarshallerColumn[] keys() {
            if (this.keys == null) {
                this.keys = MarshallerUtil.toMarshallerColumns(this.schema.keyColumns());
            }
            return this.keys;
        }

        public MarshallerColumn[] values() {
            if (this.values == null) {
                this.values = MarshallerUtil.toMarshallerColumns(this.schema.valueColumns());
            }
            return this.values;
        }

        public MarshallerColumn[] row() {
            if (this.row == null) {
                this.row = MarshallerUtil.toMarshallerColumns(this.schema.columns());
            }
            return this.row;
        }
    }
}

