/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.decorators;

import com.jakewharton.fliptables.FlipTable;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.util.PlainTableRenderer;
import org.apache.ignite.rest.client.model.MetricSource;
import org.apache.ignite.rest.client.model.NodeMetricSources;

public class ClusterMetricSourceListDecorator
implements Decorator<List<NodeMetricSources>, TerminalOutput> {
    private static final String[] HEADERS = new String[]{"Node", "Source name", "Availability"};
    private final boolean plain;

    public ClusterMetricSourceListDecorator(boolean plain) {
        this.plain = plain;
    }

    @Override
    public TerminalOutput decorate(List<NodeMetricSources> data) {
        if (this.plain) {
            return () -> PlainTableRenderer.render(HEADERS, ClusterMetricSourceListDecorator.metricSourcesToContent(data));
        }
        return () -> FlipTable.of((String[])HEADERS, (String[][])ClusterMetricSourceListDecorator.metricSourcesToContent(data));
    }

    private static String[][] metricSourcesToContent(List<NodeMetricSources> data) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (NodeMetricSources nodeMetricSources : data) {
            result.add(new String[]{nodeMetricSources.getNode(), "", ""});
            for (MetricSource source : nodeMetricSources.getSources()) {
                result.add(new String[]{"", source.getName(), source.getEnabled() != false ? "enabled" : "disabled"});
            }
        }
        return (String[][])result.toArray((T[])new String[0][]);
    }
}

