/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.QuickSelect;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.HeapUpdateSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.UpdateReturnState;
import com.yahoo.sketches.theta.UpdateSketch;
import java.util.Arrays;

final class HeapQuickSelectSketch
extends HeapUpdateSketch {
    private final Family MY_FAMILY;
    private final int preambleLongs_;
    private int lgArrLongs_;
    private int hashTableThreshold_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private long[] cache_;

    private HeapQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, int preambleLongs, Family family) {
        super(lgNomLongs, seed, p, rf);
        this.preambleLongs_ = preambleLongs;
        this.MY_FAMILY = family;
    }

    static HeapQuickSelectSketch initNewHeapInstance(int lgNomLongs, long seed, float p, ResizeFactor rf, boolean unionGadget) {
        int lgArrLongs;
        Family family;
        int preambleLongs;
        if (unionGadget) {
            preambleLongs = Family.UNION.getMinPreLongs();
            family = Family.UNION;
        } else {
            preambleLongs = Family.QUICKSELECT.getMinPreLongs();
            family = Family.QUICKSELECT;
        }
        HeapQuickSelectSketch hqss = new HeapQuickSelectSketch(lgNomLongs, seed, p, rf, preambleLongs, family);
        hqss.lgArrLongs_ = lgArrLongs = Util.startingSubMultiple(lgNomLongs + 1, rf, 5);
        hqss.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        hqss.curCount_ = 0;
        hqss.thetaLong_ = (long)((double)p * 9.223372036854776E18);
        hqss.empty_ = true;
        hqss.cache_ = new long[1 << lgArrLongs];
        return hqss;
    }

    static HeapQuickSelectSketch heapifyInstance(Memory srcMem, long seed) {
        long thetaLong;
        float p;
        int curCount;
        short seedHash;
        int flags;
        int lgArrLongs;
        int lgNomLongs;
        int familyID;
        int serVer;
        ResizeFactor myRF;
        int preambleLongs;
        boolean readOnly = srcMem.isReadOnly();
        boolean direct = srcMem.isDirect();
        if (readOnly && !direct) {
            preambleLongs = srcMem.getByte(0L) & 0x3F;
            myRF = ResizeFactor.getRF(srcMem.getByte(0L) >>> 6);
            serVer = srcMem.getByte(1L);
            familyID = srcMem.getByte(2L);
            lgNomLongs = srcMem.getByte(3L);
            lgArrLongs = srcMem.getByte(4L);
            flags = srcMem.getByte(5L);
            seedHash = srcMem.getShort(6L);
            curCount = srcMem.getInt(8L);
            p = srcMem.getFloat(12L);
            thetaLong = srcMem.getLong(16L);
        } else {
            Object memObj = direct ? null : srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preambleLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            myRF = ResizeFactor.getRF(PreambleUtil.extractLgResizeFactor(memObj, memAdd));
            serVer = PreambleUtil.extractSerVer(memObj, memAdd);
            familyID = PreambleUtil.extractFamilyID(memObj, memAdd);
            lgNomLongs = PreambleUtil.extractLgNomLongs(memObj, memAdd);
            lgArrLongs = PreambleUtil.extractLgArrLongs(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            seedHash = (short)PreambleUtil.extractSeedHash(memObj, memAdd);
            curCount = PreambleUtil.extractCurCount(memObj, memAdd);
            p = PreambleUtil.extractP(memObj, memAdd);
            thetaLong = PreambleUtil.extractThetaLong(memObj, memAdd);
        }
        if (serVer != 3) {
            throw new SketchesArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
        }
        Family family = Family.idToFamily(familyID);
        if (family.equals((Object)Family.UNION)) {
            if (preambleLongs != Family.UNION.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for UNION: " + preambleLongs);
            }
        } else if (family.equals((Object)Family.QUICKSELECT)) {
            if (preambleLongs != Family.QUICKSELECT.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for QUICKSELECT: " + preambleLongs);
            }
        } else {
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
        if (lgNomLongs < 4) {
            throw new SketchesArgumentException("Possible corruption: Current Memory lgNomLongs < min required size: " + lgNomLongs + " < " + 4);
        }
        int flagsMask = 27;
        if ((flags & 0x1B) > 0) {
            throw new SketchesArgumentException("Possible corruption: Input srcMem cannot be: big-endian, compact, ordered, or read-only");
        }
        Util.checkSeedHashes(seedHash, Util.computeSeedHash(seed));
        long curCapBytes = srcMem.getCapacity();
        int minReqBytes = PreambleUtil.getMemBytes(lgArrLongs, preambleLongs);
        if (curCapBytes < (long)minReqBytes) {
            throw new SketchesArgumentException("Possible corruption: Current Memory size < min required size: " + curCapBytes + " < " + minReqBytes);
        }
        double theta = (double)thetaLong / 9.223372036854776E18;
        if (lgArrLongs <= lgNomLongs && theta < (double)p) {
            throw new SketchesArgumentException("Possible corruption: Theta cannot be < p and lgArrLongs <= lgNomLongs. " + lgArrLongs + " <= " + lgNomLongs + ", Theta: " + theta + ", p: " + p);
        }
        HeapQuickSelectSketch hqss = new HeapQuickSelectSketch(lgNomLongs, seed, p, myRF, preambleLongs, family);
        hqss.lgArrLongs_ = lgArrLongs;
        hqss.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        hqss.curCount_ = curCount;
        hqss.thetaLong_ = thetaLong;
        hqss.empty_ = (flags & 4) > 0;
        hqss.cache_ = new long[1 << lgArrLongs];
        srcMem.getLongArray((long)(preambleLongs << 3), hqss.cache_, 0, 1 << lgArrLongs);
        return hqss;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(this.preambleLongs_, (byte)this.MY_FAMILY.getID());
    }

    @Override
    public Family getFamily() {
        return this.MY_FAMILY;
    }

    @Override
    public UpdateSketch rebuild() {
        if (this.getRetainedEntries(true) > 1 << this.getLgNomLongs()) {
            this.quickSelectAndRebuild();
        }
        return this;
    }

    @Override
    public final void reset() {
        ResizeFactor rf = this.getResizeFactor();
        int lgArrLongsSM = Util.startingSubMultiple(this.lgNomLongs_ + 1, rf, 5);
        if (lgArrLongsSM == this.lgArrLongs_) {
            int arrLongs = this.cache_.length;
            assert (1 << this.lgArrLongs_ == arrLongs);
            Arrays.fill(this.cache_, 0L);
        } else {
            this.cache_ = new long[1 << lgArrLongsSM];
            this.lgArrLongs_ = lgArrLongsSM;
        }
        this.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        this.empty_ = true;
        this.curCount_ = 0;
        this.thetaLong_ = (long)((double)this.getP() * 9.223372036854776E18);
    }

    @Override
    int getPreambleLongs() {
        return this.preambleLongs_;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    int getLgArrLongs() {
        return this.lgArrLongs_;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        HashOperations.checkHashCorruption(hash);
        this.empty_ = false;
        if (HashOperations.continueCondition(this.thetaLong_, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        if (HashOperations.hashSearchOrInsert(this.cache_, this.lgArrLongs_, hash) >= 0) {
            return UpdateReturnState.RejectedDuplicate;
        }
        ++this.curCount_;
        if (this.curCount_ > this.hashTableThreshold_) {
            if (this.lgArrLongs_ <= this.lgNomLongs_) {
                this.resizeCache();
            } else {
                assert (this.lgArrLongs_ == this.lgNomLongs_ + 1) : "lgArr: " + this.lgArrLongs_ + ", lgNom: " + this.lgNomLongs_;
                this.quickSelectAndRebuild();
            }
        }
        return UpdateReturnState.InsertedCountIncremented;
    }

    private final void resizeCache() {
        ResizeFactor rf = this.getResizeFactor();
        int lgTgtLongs = this.lgNomLongs_ + 1;
        int lgDeltaLongs = lgTgtLongs - this.lgArrLongs_;
        int lgResizeFactor = Math.max(Math.min(rf.lg(), lgDeltaLongs), 1);
        this.lgArrLongs_ += lgResizeFactor;
        long[] tgtArr = new long[1 << this.lgArrLongs_];
        int newCount = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        assert (newCount == this.curCount_);
        this.curCount_ = newCount;
        this.cache_ = tgtArr;
        this.hashTableThreshold_ = HeapQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
    }

    private final void quickSelectAndRebuild() {
        int arrLongs = 1 << this.lgArrLongs_;
        int pivot = (1 << this.lgNomLongs_) + 1;
        this.thetaLong_ = QuickSelect.selectExcludingZeros(this.cache_, this.curCount_, pivot);
        long[] tgtArr = new long[arrLongs];
        this.curCount_ = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        this.cache_ = tgtArr;
    }

    static final int setHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.5 : 0.9375;
        return (int)Math.floor(fraction * (double)(1 << lgArrLongs));
    }
}

