/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.util.CancelFlag;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.rex.IgniteRexBuilder;
import org.apache.ignite.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public final class PlanningContext
implements Context {
    private static final CalciteConnectionConfig CALCITE_CONNECTION_CONFIG;
    public static final RelOptCluster CLUSTER;
    private static final IgniteCostFactory COST_FACTORY;
    private static final PlanningContext EMPTY_CONTEXT;
    private static final SchemaPlus EMPTY_SCHEMA;
    private final Context parentCtx;
    private final FrameworkConfig cfg;
    private final String qry;
    private final CancelFlag cancelFlag = new CancelFlag(new AtomicBoolean());
    private final Set<String> rulesToDisable = new HashSet<String>();
    private IgnitePlanner planner;
    private final long plannerTimeout;
    private volatile boolean timeouted;
    private final Int2ObjectMap<ColumnType> parameters;
    @Nullable
    private CalciteCatalogReader catalogReader;
    private final boolean explicitTx;
    private final int catalogVersion;
    @Nullable
    private final String defaultSchemaName;

    private PlanningContext(FrameworkConfig config, String qry, long plannerTimeout, Int2ObjectMap<ColumnType> parameters, boolean explicitTx, int catalogVersion, @Nullable String defaultSchemaName) {
        this.parentCtx = config.getContext();
        this.cfg = Frameworks.newConfigBuilder((FrameworkConfig)config).context((Context)this).build();
        this.qry = qry;
        this.plannerTimeout = plannerTimeout;
        this.parameters = parameters;
        this.explicitTx = explicitTx;
        this.catalogVersion = catalogVersion;
        this.defaultSchemaName = defaultSchemaName;
    }

    public FrameworkConfig config() {
        return this.cfg;
    }

    public String query() {
        return this.qry;
    }

    public Int2ObjectMap<ColumnType> parameters() {
        return this.parameters;
    }

    public SqlOperatorTable opTable() {
        return this.config().getOperatorTable();
    }

    public SqlConformance conformance() {
        return this.config().getParserConfig().conformance();
    }

    public long plannerTimeout() {
        return this.plannerTimeout;
    }

    public IgnitePlanner planner() {
        if (this.planner == null) {
            this.planner = new IgnitePlanner(this);
        }
        return this.planner;
    }

    @Nullable
    public String schemaName() {
        return this.defaultSchemaName;
    }

    public SchemaPlus schema() {
        return Objects.requireNonNull(this.config().getDefaultSchema());
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    public IgniteTypeFactory typeFactory() {
        return IgniteTypeFactory.INSTANCE;
    }

    public CalciteCatalogReader catalogReader() {
        SchemaPlus rootSchema;
        if (this.catalogReader != null) {
            return this.catalogReader;
        }
        SchemaPlus dfltSchema = this.config().getDefaultSchema();
        if (dfltSchema == null) {
            dfltSchema = EMPTY_SCHEMA;
            rootSchema = EMPTY_SCHEMA;
        } else {
            rootSchema = dfltSchema;
            while (rootSchema.getParentSchema() != null) {
                rootSchema = rootSchema.getParentSchema();
            }
        }
        this.catalogReader = new IgniteCatalogReader(CalciteSchema.from((SchemaPlus)rootSchema), CalciteSchema.from((SchemaPlus)dfltSchema).path(null), (RelDataTypeFactory)IgniteTypeFactory.INSTANCE, CALCITE_CONNECTION_CONFIG);
        return this.catalogReader;
    }

    public RelOptCluster cluster() {
        return this.planner().cluster();
    }

    public <C> C unwrap(Class<C> clazz) {
        if (clazz == this.getClass()) {
            return clazz.cast(this);
        }
        if (clazz == CancelFlag.class) {
            return clazz.cast(this.cancelFlag);
        }
        return (C)this.parentCtx.unwrap(clazz);
    }

    public static Builder builder() {
        return new Builder();
    }

    public RuleSet rules(RuleSet set) {
        if (this.rulesToDisable.isEmpty()) {
            return set;
        }
        ArrayList<RelOptRule> filtered = new ArrayList<RelOptRule>();
        for (RelOptRule r : set) {
            if (this.rulesToDisable.contains(Commons.shortRuleName(r))) continue;
            filtered.add(r);
        }
        return RuleSets.ofList(filtered);
    }

    public void disableRule(String ruleName) {
        this.rulesToDisable.add(ruleName);
    }

    public void abortByTimeout() {
        this.timeouted = true;
    }

    public boolean timeouted() {
        return this.timeouted;
    }

    public boolean explicitTx() {
        return this.explicitTx;
    }

    static {
        COST_FACTORY = new IgniteCostFactory();
        Properties props = new Properties();
        props.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(Commons.FRAMEWORK_CONFIG.getParserConfig().caseSensitive()));
        props.setProperty(CalciteConnectionProperty.CONFORMANCE.camelName(), String.valueOf(Commons.FRAMEWORK_CONFIG.getParserConfig().conformance()));
        props.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), String.valueOf(true));
        CALCITE_CONNECTION_CONFIG = new CalciteConnectionConfigImpl(props);
        IgniteRexBuilder defaultRexBuilder = IgniteRexBuilder.INSTANCE;
        EMPTY_CONTEXT = PlanningContext.builder().catalogVersion(-1).build();
        EMPTY_SCHEMA = Frameworks.createRootSchema((boolean)false);
        VolcanoPlanner planner = new VolcanoPlanner(COST_FACTORY, EMPTY_CONTEXT){

            public void registerSchema(RelOptSchema schema) {
            }
        };
        for (RelTraitDef def : Commons.DISTRIBUTED_TRAITS_SET) {
            planner.addRelTraitDef(def);
        }
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)defaultRexBuilder);
        final String cantBeUsedMsg = "Empty cluster can't be used for planning or mapping";
        cluster.setMetadataProvider(new RelMetadataProvider(){

            public <M extends Metadata> UnboundMetadata<M> apply(Class<? extends RelNode> relCls, Class<? extends M> metadataCls) {
                throw new AssertionError((Object)cantBeUsedMsg);
            }

            public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
                throw new AssertionError((Object)cantBeUsedMsg);
            }

            public List<MetadataHandler<?>> handlers(Class<? extends MetadataHandler<?>> hndCls) {
                throw new AssertionError((Object)cantBeUsedMsg);
            }
        });
        cluster.setMetadataQuerySupplier(() -> {
            throw new AssertionError((Object)cantBeUsedMsg);
        });
        CLUSTER = cluster;
    }

    private static class IgniteCatalogReader
    extends CalciteCatalogReader {
        private final HashMap<String, Double> cacheSizeOfTables = new HashMap();

        public IgniteCatalogReader(CalciteSchema rootSchema, List<String> defaultSchema, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
            super(rootSchema, defaultSchema, typeFactory, config);
        }

        public Prepare.PreparingTable getTable(List<String> names) {
            CalciteSchema.TableEntry entry = SqlValidatorUtil.getTableEntry((SqlValidatorCatalogReader)this, names);
            if (entry != null) {
                Prepare.PreparingTable relOptTable;
                Table table = entry.getTable();
                if (table instanceof Wrapper && (relOptTable = (Prepare.PreparingTable)((Wrapper)table).unwrap(Prepare.PreparingTable.class)) != null) {
                    return relOptTable;
                }
                Double rowCount = null;
                if (table instanceof IgniteDataSource) {
                    IgniteDataSource ds = (IgniteDataSource)table;
                    rowCount = this.cacheSizeOfTables.computeIfAbsent(ds.name(), k -> ds.getStatistic().getRowCount());
                }
                return RelOptTableImpl.create((RelOptSchema)this, (RelDataType)table.getRowType(this.typeFactory), (CalciteSchema.TableEntry)entry, rowCount);
            }
            return null;
        }
    }

    public static class Builder {
        private static final FrameworkConfig EMPTY_CONFIG = Frameworks.newConfigBuilder((FrameworkConfig)Commons.FRAMEWORK_CONFIG).defaultSchema(Frameworks.createRootSchema((boolean)false)).traitDefs(Commons.DISTRIBUTED_TRAITS_SET).build();
        private FrameworkConfig frameworkConfig = EMPTY_CONFIG;
        private String qry;
        private long plannerTimeout;
        private Int2ObjectMap<ColumnType> parameters = Int2ObjectMaps.emptyMap();
        private boolean explicitTx;
        private int catalogVersion;
        @Nullable
        private String defaultSchemaName;

        public Builder frameworkConfig(FrameworkConfig frameworkCfg) {
            this.frameworkConfig = Objects.requireNonNull(frameworkCfg);
            return this;
        }

        public Builder query(String qry) {
            this.qry = qry;
            return this;
        }

        public Builder catalogVersion(int catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder defaultSchemaName(String defaultSchemaName) {
            this.defaultSchemaName = defaultSchemaName;
            return this;
        }

        public Builder plannerTimeout(long plannerTimeout) {
            this.plannerTimeout = plannerTimeout;
            return this;
        }

        public Builder parameters(Int2ObjectMap<ColumnType> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder explicitTx(boolean explicitTx) {
            this.explicitTx = explicitTx;
            return this;
        }

        public PlanningContext build() {
            return new PlanningContext(this.frameworkConfig, this.qry, this.plannerTimeout, this.parameters, this.explicitTx, this.catalogVersion, this.defaultSchemaName);
        }
    }
}

